/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.listener;

import java.awt.AWTEvent;
import java.awt.event.AWTEventListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.swing.SwingUtilities;
import org.fest.util.Lists;
import org.fest.util.Preconditions;

@ThreadSafe
public abstract class EventDispatchThreadedEventListener
implements AWTEventListener {
    @GuardedBy(value="lock")
    private final List<AWTEvent> deferredEvents = Lists.newArrayList();
    private final Object lock = new Object();
    private final Runnable processDeferredEventsTask = new Runnable(){

        @Override
        public void run() {
            EventDispatchThreadedEventListener.this.processDeferredEvents();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventDispatched(AWTEvent event) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Object object = this.lock;
            synchronized (object) {
                this.deferredEvents.add(event);
            }
            SwingUtilities.invokeLater(this.processDeferredEventsTask);
            return;
        }
        this.processDeferredEvents();
        this.processEvent((AWTEvent)Preconditions.checkNotNull((Object)event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeferredEvents() {
        ArrayList queue = Lists.newArrayList();
        Object object = this.lock;
        synchronized (object) {
            queue.addAll(this.deferredEvents);
            this.deferredEvents.clear();
        }
        while (queue.size() > 0) {
            AWTEvent event = (AWTEvent)queue.get(0);
            queue.remove(0);
            this.processEvent((AWTEvent)Preconditions.checkNotNull((Object)event));
        }
    }

    protected abstract void processEvent(@Nonnull AWTEvent var1);
}

