/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.IntArrayAssert;
import org.fest.assertions.IntAssert;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.cell.JTableCellWriter;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellFinder;
import org.fest.swing.driver.BasicJTableCellReader;
import org.fest.swing.driver.BasicJTableCellWriter;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTableCellEditableQuery;
import org.fest.swing.driver.JTableCellPreconditions;
import org.fest.swing.driver.JTableColumnCountQuery;
import org.fest.swing.driver.JTableContentsQuery;
import org.fest.swing.driver.JTableHasSelectionQuery;
import org.fest.swing.driver.JTableHeaderQuery;
import org.fest.swing.driver.JTableLocation;
import org.fest.swing.driver.JTableMatchingCellQuery;
import org.fest.swing.driver.JTableRowCountQuery;
import org.fest.swing.driver.JTableSingleRowCellSelectedQuery;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.query.JTableColumnByIdentifierQuery;
import org.fest.swing.util.ArrayPreconditions;
import org.fest.swing.util.Arrays;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.StringTextMatcher;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

@InternalApi
public class JTableDriver
extends JComponentDriver {
    private static final String CONTENTS_PROPERTY = "contents";
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTED_ROWS_PROPERTY = "selectedRows";
    private static final String SELECTION_PROPERTY = "selection";
    private static final String VALUE_PROPERTY = "value";
    private final JTableLocation location = new JTableLocation();
    private JTableCellReader cellReader;
    private JTableCellWriter cellWriter;

    public JTableDriver(@Nonnull Robot robot) {
        super(robot);
        this.replaceCellReader(new BasicJTableCellReader());
        this.replaceCellWriter(new BasicJTableCellWriter(robot));
    }

    @Nullable
    @RunsInEDT
    public JTableHeader tableHeaderOf(@Nonnull JTable table) {
        return JTableHeaderQuery.tableHeader(table);
    }

    @Nullable
    @RunsInEDT
    public String selectionValue(@Nonnull JTable table) {
        return JTableDriver.selectionValue(table, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static String selectionValue(final @Nonnull JTable table, final @Nonnull JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                if (table.getSelectedRowCount() == 0) {
                    return null;
                }
                return cellReader.valueAt(table, table.getSelectedRow(), table.getSelectedColumn());
            }
        });
    }

    @Nonnull
    @RunsInEDT
    public TableCell cell(@Nonnull JTable table, @Nonnull TableCellFinder cellFinder) {
        Preconditions.checkNotNull((Object)cellFinder);
        TableCell cell = cellFinder.findCell(table, this.cellReader());
        this.checkCellIndicesInBounds(table, cell);
        return cell;
    }

    @Nonnull
    @RunsInEDT
    public TableCell cell(@Nonnull JTable table, @Nullable String value) {
        return JTableMatchingCellQuery.cellWithValue(table, new StringTextMatcher(value), this.cellReader());
    }

    @Nonnull
    @RunsInEDT
    public TableCell cell(@Nonnull JTable table, @Nonnull Pattern pattern) {
        return JTableMatchingCellQuery.cellWithValue(table, new PatternTextMatcher(pattern), this.cellReader());
    }

    @Nullable
    @RunsInEDT
    public String value(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull((Object)cell);
        return JTableDriver.cellValue(table, cell, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static String cellValue(final @Nonnull JTable table, final @Nonnull TableCell cell, final @Nonnull JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
                return cellReader.valueAt(table, cell.row, cell.column);
            }
        });
    }

    @Nullable
    @RunsInEDT
    public String value(@Nonnull JTable table, int row, int column) {
        return JTableDriver.cellValue(table, row, column, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static String cellValue(final @Nonnull JTable table, final int row, final int column, final @Nonnull JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
                return cellReader.valueAt(table, row, column);
            }
        });
    }

    @Nullable
    @RunsInEDT
    public Font font(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull((Object)cell);
        return JTableDriver.cellFont(table, cell, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static Font cellFont(final @Nonnull JTable table, final @Nonnull TableCell cell, final @Nonnull JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Font>(){

            @Override
            protected Font executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
                return cellReader.fontAt(table, cell.row, cell.column);
            }
        });
    }

    @RunsInEDT
    public Color background(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull((Object)cell);
        return JTableDriver.cellBackground(table, cell, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static Color cellBackground(final @Nonnull JTable table, final @Nonnull TableCell cell, final @Nonnull JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Color>(){

            @Override
            protected Color executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
                return cellReader.backgroundAt(table, cell.row, cell.column);
            }
        });
    }

    @Nullable
    @RunsInEDT
    public Color foreground(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull((Object)cell);
        return JTableDriver.cellForeground(table, cell, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static Color cellForeground(final @Nonnull JTable table, final @Nonnull TableCell cell, final @Nonnull JTableCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Color>(){

            @Override
            protected Color executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
                return cellReader.foregroundAt(table, cell.row, cell.column);
            }
        });
    }

    public void selectCells(final @Nonnull JTable table, final @Nonnull TableCell[] cells) {
        Preconditions.checkNotNullOrEmpty((Object[])cells);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return cells.length;
            }

            @Override
            void selectElement(int index) {
                JTableDriver.this.selectCell(table, (TableCell)Preconditions.checkNotNull((Object)cells[index]));
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void requireNoSelection(@Nonnull JTable table) {
        JTableDriver.assertNoSelection(table);
    }

    @RunsInEDT
    private static void assertNoSelection(final @Nonnull JTable table) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                if (!JTableHasSelectionQuery.hasSelection(table)) {
                    return;
                }
                String format = "[%s] expected no selection but was:<rows=%s, columns=%s>";
                String msg = String.format(format, ComponentDriver.propertyName(table, JTableDriver.SELECTION_PROPERTY).value(), org.fest.util.Arrays.format((Object)JTableDriver.selectedRowsOf(table)), org.fest.util.Arrays.format((Object)table.getSelectedColumns()));
                Fail.fail((String)msg);
            }
        });
    }

    @RunsInEDT
    public void selectCell(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull((Object)cell);
        this.selectCell(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void click(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull MouseButton mouseButton, @Nonnegative int times) {
        if (times <= 0) {
            throw new IllegalArgumentException("The number of times to click a cell should be greater than zero");
        }
        Point pointAtCell = JTableDriver.scrollToPointAtCell(table, cell, this.location());
        this.robot.click(table, pointAtCell, mouseButton, times);
    }

    @RunsInEDT
    public void drag(@Nonnull JTable table, @Nonnull TableCell cell) {
        Point pointAtCell = JTableDriver.scrollToPointAtCell(table, cell, this.location());
        this.drag(table, pointAtCell);
    }

    @RunsInEDT
    public void drop(@Nonnull JTable table, @Nonnull TableCell cell) {
        Point pointAtCell = JTableDriver.scrollToPointAtCell(table, cell, this.location());
        this.drop(table, pointAtCell);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenuAt(@Nonnull JTable table, @Nonnull TableCell cell) {
        Point pointAtCell = JTableDriver.scrollToPointAtCell(table, cell, this.location());
        return this.robot.showPopupMenu(table, pointAtCell);
    }

    @Nonnull
    @RunsInEDT
    private static Point scrollToPointAtCell(final @Nonnull JTable table, final @Nonnull TableCell cell, final @Nonnull JTableLocation location) {
        Preconditions.checkNotNull((Object)cell);
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                JTableDriver.scrollToCell(table, cell, location);
                return location.pointAt(table, cell.row, cell.column);
            }
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @RunsInCurrentThread
    private static void scrollToCell(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull JTableLocation location) {
        ComponentPreconditions.checkEnabledAndShowing(table);
        JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
        table.scrollRectToVisible(location.cellBounds(table, cell));
    }

    @Nonnull
    @RunsInEDT
    public Point pointAt(@Nonnull JTable table, @Nonnull TableCell cell) {
        return JTableDriver.pointAtCell(table, cell, this.location());
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtCell(final @Nonnull JTable table, final @Nonnull TableCell cell, final @Nonnull JTableLocation location) {
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
                return location.pointAt(table, cell.row, cell.column);
            }
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @RunsInEDT
    public void requireContents(@Nonnull JTable table, @Nonnull String[][] contents) {
        String[][] actual = this.contents(table);
        if (!Arrays.equal(actual, contents)) {
            JTableDriver.failNotEqual(actual, contents, JTableDriver.propertyName(table, CONTENTS_PROPERTY));
        }
    }

    private static void failNotEqual(@Nonnull String[][] actual, @Nonnull String[][] expected, @Nullable Description description) {
        String descriptionValue = description != null ? description.value() : null;
        String message = descriptionValue == null ? "" : String.format("[%s] ", descriptionValue);
        Fail.fail((String)(message + String.format("expected:<%s> but was:<%s>", Arrays.format(expected), Arrays.format(actual))));
    }

    @Nonnull
    @RunsInEDT
    public String[][] contents(@Nonnull JTable table) {
        return JTableContentsQuery.tableContents(table, this.cellReader());
    }

    @RunsInEDT
    public void requireCellValue(@Nonnull JTable table, @Nonnull TableCell cell, @Nullable String value) {
        TextAssert.verifyThat(this.value(table, cell)).as(this.cellValueProperty(table, cell)).isEqualOrMatches(value);
    }

    @RunsInEDT
    public void requireCellValue(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull Pattern pattern) {
        TextAssert.verifyThat(this.value(table, cell)).as(this.cellValueProperty(table, cell)).matches(pattern);
    }

    @Nonnull
    @RunsInEDT
    private Description cellValueProperty(@Nonnull JTable table, @Nonnull TableCell cell) {
        return JTableDriver.cellProperty(table, Strings.concat((Object[])new Object[]{VALUE_PROPERTY, " ", cell}));
    }

    @RunsInEDT
    public void enterValueInCell(@Nonnull JTable table, @Nonnull TableCell cell, @Nonnull String value) {
        Preconditions.checkNotNull((Object)cell);
        this.cellWriter.enterValue(table, cell.row, cell.column, value);
    }

    @RunsInEDT
    public void requireEditable(@Nonnull JTable table, @Nonnull TableCell cell) {
        JTableDriver.requireEditableEqualTo(table, cell, true);
    }

    @RunsInEDT
    public void requireNotEditable(@Nonnull JTable table, @Nonnull TableCell cell) {
        JTableDriver.requireEditableEqualTo(table, cell, false);
    }

    @RunsInEDT
    private static void requireEditableEqualTo(final @Nonnull JTable table, final @Nonnull TableCell cell, boolean editable) {
        Preconditions.checkNotNull((Object)cell);
        boolean cellEditable = (Boolean)Preconditions.checkNotNull((Object)GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return JTableCellEditableQuery.isCellEditable(table, cell);
            }
        }));
        ((BooleanAssert)Assertions.assertThat((boolean)cellEditable).as(JTableDriver.cellProperty(table, Strings.concat((Object[])new Object[]{EDITABLE_PROPERTY, " ", cell})))).isEqualTo(editable);
    }

    @Nonnull
    @RunsInEDT
    private static Description cellProperty(@Nonnull JTable table, @Nonnull String propertyName) {
        return JTableDriver.propertyName(table, propertyName);
    }

    @RunsInEDT
    public Component cellEditor(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull((Object)cell);
        return this.cellWriter.editorForCell(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void startCellEditing(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull((Object)cell);
        this.cellWriter.startCellEditing(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void stopCellEditing(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull((Object)cell);
        this.cellWriter.stopCellEditing(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void cancelCellEditing(@Nonnull JTable table, @Nonnull TableCell cell) {
        Preconditions.checkNotNull((Object)cell);
        this.cellWriter.cancelCellEditing(table, cell.row, cell.column);
    }

    @RunsInEDT
    public void checkCellIndicesInBounds(final @Nonnull JTable table, final @Nonnull TableCell cell) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, cell);
            }
        });
    }

    public void replaceCellReader(@Nonnull JTableCellReader newCellReader) {
        this.cellReader = (JTableCellReader)Preconditions.checkNotNull((Object)newCellReader);
    }

    public void replaceCellWriter(JTableCellWriter newCellWriter) {
        this.cellWriter = (JTableCellWriter)Preconditions.checkNotNull((Object)newCellWriter);
    }

    @RunsInEDT
    public int rowCountOf(@Nonnull JTable table) {
        return JTableRowCountQuery.rowCountOf(table);
    }

    @RunsInEDT
    public int columnIndex(@Nonnull JTable table, @Nonnull Object columnId) {
        return JTableDriver.findColumnIndex(table, columnId);
    }

    @RunsInEDT
    private static int findColumnIndex(final @Nonnull JTable table, final @Nonnull Object columnId) {
        Integer result = GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                int index = JTableColumnByIdentifierQuery.columnIndexByIdentifier(table, columnId);
                if (index < 0) {
                    JTableDriver.failColumnIndexNotFound(columnId);
                }
                return index;
            }
        });
        return (Integer)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    private static ActionFailedException failColumnIndexNotFound(@Nonnull Object columnId) {
        throw ActionFailedException.actionFailure(String.format("Unable to find a column with id '%s'", columnId.toString()));
    }

    @RunsInEDT
    public void requireRowCount(@Nonnull JTable table, int rowCount) {
        ((IntAssert)Assertions.assertThat((int)this.rowCountOf(table)).as(JTableDriver.propertyName(table, "rowCount"))).isEqualTo(rowCount);
    }

    @RunsInEDT
    public void requireColumnCount(@Nonnull JTable table, int columnCount) {
        ((IntAssert)Assertions.assertThat((int)JTableColumnCountQuery.columnCountOf(table)).as(JTableDriver.propertyName(table, "columnCount"))).isEqualTo(columnCount);
    }

    @RunsInEDT
    public void selectRows(final @Nonnull JTable table, final int ... rows) {
        ArrayPreconditions.checkNotNullOrEmpty(rows);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return rows.length;
            }

            @Override
            void selectElement(int index) {
                JTableDriver.this.selectCell(table, rows[index], 0);
            }
        }.multiSelect();
    }

    @RunsInEDT
    private void selectCell(@Nonnull JTable table, int row, int column) {
        Pair<Boolean, Point> cellSelectionInfo = JTableDriver.cellSelectionInfo(table, row, column, this.location);
        if (((Boolean)cellSelectionInfo.first).booleanValue()) {
            return;
        }
        this.robot.click(table, (Point)Preconditions.checkNotNull(cellSelectionInfo.second), MouseButton.LEFT_BUTTON, 1);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> cellSelectionInfo(final @Nonnull JTable table, final int row, final int column, final @Nonnull JTableLocation location) {
        Pair<Boolean, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                if (JTableSingleRowCellSelectedQuery.isCellSelected(table, row, column)) {
                    return Pair.of(true, null);
                }
                JTableDriver.scrollToCell(table, row, column, location);
                Point pointAtCell = location.pointAt(table, row, column);
                return Pair.of(false, pointAtCell);
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @RunsInCurrentThread
    private static void scrollToCell(@Nonnull JTable table, int row, int column, @Nonnull JTableLocation location) {
        ComponentPreconditions.checkEnabledAndShowing(table);
        JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
        table.scrollRectToVisible(location.cellBounds(table, row, column));
    }

    @RunsInEDT
    public void requireSelectedRows(@Nonnull JTable table, int ... rows) {
        int[] selectedRows = JTableDriver.selectedRowsOf(table);
        ((IntArrayAssert)Assertions.assertThat((int[])selectedRows).as(JTableDriver.propertyName(table, SELECTED_ROWS_PROPERTY))).contains(rows);
    }

    @Nonnull
    @RunsInEDT
    private static int[] selectedRowsOf(final @Nonnull JTable table) {
        int[] result = GuiActionRunner.execute(new GuiQuery<int[]>(){

            @Override
            protected int[] executeInEDT() {
                return table.getSelectedRows();
            }
        });
        return (int[])Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    @VisibleForTesting
    JTableCellReader cellReader() {
        return this.cellReader;
    }

    @Nonnull
    private JTableLocation location() {
        return this.location;
    }
}

