/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.addressbook;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.addressbook.AddressBook;
import net.i2p.addressbook.Subscription;

class SubscriptionIterator
implements Iterator<AddressBook> {
    private final Iterator<Subscription> subIterator;
    private final String proxyHost;
    private final int proxyPort;
    private final long delay;

    public SubscriptionIterator(List<Subscription> subscriptions, long delay, String proxyHost, int proxyPort) {
        this.subIterator = subscriptions.iterator();
        this.delay = delay;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    @Override
    public boolean hasNext() {
        return this.subIterator.hasNext();
    }

    @Override
    public AddressBook next() {
        Subscription sub = this.subIterator.next();
        if (sub.getLocation().startsWith("file:")) {
            return new AddressBook(sub.getLocation().substring(5));
        }
        if (sub.getLastFetched() + this.delay < I2PAppContext.getGlobalContext().clock().now() && I2PAppContext.getGlobalContext().portMapper().getPort("HTTP") >= 0 && !I2PAppContext.getGlobalContext().getBooleanProperty("i2p.vmCommSystem")) {
            return new AddressBook(sub, this.proxyHost, this.proxyPort);
        }
        return new AddressBook(Collections.emptyMap());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

