/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.io.IOException;
import java.io.OutputStream;
import net.i2p.data.DataHelper;
import net.i2p.stat.Frequency;

public class FrequencyStat {
    private final String _statName;
    private final String _groupName;
    private final String _description;
    private final Frequency[] _frequencies;
    private static final String NL = System.getProperty("line.separator");

    public FrequencyStat(String name, String description, String group, long[] periods) {
        this._statName = name;
        this._description = description;
        this._groupName = group;
        this._frequencies = new Frequency[periods.length];
        for (int i = 0; i < periods.length; ++i) {
            this._frequencies[i] = new Frequency(periods[i]);
        }
    }

    public void eventOccurred() {
        for (int i = 0; i < this._frequencies.length; ++i) {
            this._frequencies[i].eventOccurred();
        }
    }

    public void coalesceStats() {
        for (int i = 0; i < this._frequencies.length; ++i) {
            this._frequencies[i].recalculate();
        }
    }

    public String getName() {
        return this._statName;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public String getDescription() {
        return this._description;
    }

    public long[] getPeriods() {
        long[] rv = new long[this._frequencies.length];
        for (int i = 0; i < this._frequencies.length; ++i) {
            rv[i] = this._frequencies[i].getPeriod();
        }
        return rv;
    }

    public Frequency getFrequency(long period) {
        for (int i = 0; i < this._frequencies.length; ++i) {
            if (this._frequencies[i].getPeriod() != period) continue;
            return this._frequencies[i];
        }
        return null;
    }

    public long getEventCount() {
        if (this._frequencies == null || this._frequencies.length <= 0) {
            return 0L;
        }
        return this._frequencies[0].getEventCount();
    }

    public long getFrequency() {
        if (this._frequencies == null || this._frequencies.length <= 0) {
            return Long.MAX_VALUE;
        }
        double d = this._frequencies[0].getStrictAverageInterval();
        if (d > (double)this._frequencies[0].getPeriod()) {
            return Long.MAX_VALUE;
        }
        return Math.round(d);
    }

    public int hashCode() {
        return this._statName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FrequencyStat)) {
            return false;
        }
        return this._statName.equals(((FrequencyStat)obj)._statName);
    }

    public void store(OutputStream out, String prefix) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append(NL);
        buf.append("################################################################################").append(NL);
        buf.append("# Frequency: ").append(this._groupName).append(": ").append(this._statName).append(NL);
        buf.append("# ").append(this._description).append(NL);
        buf.append("# ").append(NL).append(NL);
        out.write(buf.toString().getBytes("UTF-8"));
        buf.setLength(0);
        for (Frequency r : this._frequencies) {
            buf.append("#######").append(NL);
            buf.append("# Period : ").append(DataHelper.formatDuration(r.getPeriod())).append(" for rate ").append(this._groupName).append(" - ").append(this._statName).append(NL);
            buf.append(NL);
            r.store(buf);
            out.write(buf.toString().getBytes("UTF-8"));
            buf.setLength(0);
        }
    }
}

