/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import com.southernstorm.noise.crypto.chacha20.ChaChaCore;
import net.i2p.data.DataHelper;

public final class ChaCha20 {
    private ChaCha20() {
    }

    public static void encrypt(byte[] key, byte[] iv, byte[] plaintext, int plaintextOffset, byte[] ciphertext, int ciphertextOffset, int length) {
        int[] input = new int[16];
        int[] output = new int[16];
        ChaChaCore.initKey256(input, key, 0);
        input[12] = 1;
        input[13] = (int)DataHelper.fromLongLE(iv, 0, 4);
        input[14] = (int)DataHelper.fromLongLE(iv, 4, 4);
        input[15] = (int)DataHelper.fromLongLE(iv, 8, 4);
        ChaChaCore.hash(output, input);
        while (length > 0) {
            int tempLen = 64;
            if (tempLen > length) {
                tempLen = length;
            }
            ChaChaCore.hash(output, input);
            ChaChaCore.xorBlock(plaintext, plaintextOffset, ciphertext, ciphertextOffset, tempLen, output);
            input[12] = input[12] + 1;
            if (input[12] == 0) {
                input[13] = input[13] + 1;
            }
            plaintextOffset += tempLen;
            ciphertextOffset += tempLen;
            length -= tempLen;
        }
    }

    public static void decrypt(byte[] key, byte[] iv, byte[] ciphertext, int ciphertextOffset, byte[] plaintext, int plaintextOffset, int length) {
        ChaCha20.encrypt(key, iv, ciphertext, ciphertextOffset, plaintext, plaintextOffset, length);
    }
}

