/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.ShortEncryptedBuildRecord;
import net.i2p.data.i2np.TunnelBuildReplyMessage;

public class OutboundTunnelBuildReplyMessage
extends TunnelBuildReplyMessage {
    public static final int MESSAGE_TYPE = 26;
    public static final int SHORT_RECORD_SIZE = 236;
    public static final int MAX_PLAINTEXT_RECORD_SIZE = 172;
    private int _plaintextSlot;
    private byte[] _plaintextRecord;

    public OutboundTunnelBuildReplyMessage(I2PAppContext context) {
        super(context, 0);
    }

    public OutboundTunnelBuildReplyMessage(I2PAppContext context, int records) {
        super(context, records);
    }

    public void setPlaintextRecord(int slot, byte[] data) {
        if (slot < 0 || slot >= this.RECORD_COUNT || data.length == 0 || data.length > 172) {
            throw new IllegalArgumentException();
        }
        this._plaintextSlot = slot;
        this._plaintextRecord = data;
    }

    public int getPlaintextSlot() {
        return this._plaintextSlot;
    }

    public byte[] getPlaintextRecord() {
        return this._plaintextRecord;
    }

    @Override
    protected int calculateWrittenLength() {
        return 4 + this._plaintextRecord.length + (this.RECORD_COUNT - 1) * 236;
    }

    @Override
    public int getType() {
        return 26;
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        int r;
        if (type != 26) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        if ((r = data[offset++] & 0xFF) <= 0 || r > 8) {
            throw new I2NPMessageException("Bad record count " + r);
        }
        this.RECORD_COUNT = r;
        this._plaintextSlot = data[offset++] & 0xFF;
        if (this._plaintextSlot < 0 || this._plaintextSlot >= r) {
            throw new I2NPMessageException("Bad slot " + this._plaintextSlot);
        }
        int size = (int)DataHelper.fromLong(data, offset, 2);
        if (size <= 0 || size > 172) {
            throw new I2NPMessageException("Bad size " + size);
        }
        this._plaintextRecord = new byte[size];
        System.arraycopy(data, offset += 2, this._plaintextRecord, 0, size);
        offset += size;
        if (dataSize != this.calculateWrittenLength()) {
            throw new I2NPMessageException("Wrong length (expects " + this.calculateWrittenLength() + ", recv " + dataSize + ")");
        }
        this._records = new EncryptedBuildRecord[this.RECORD_COUNT];
        for (int i = 0; i < this.RECORD_COUNT; ++i) {
            if (i == this._plaintextSlot) continue;
            byte[] rec = new byte[236];
            System.arraycopy(data, offset, rec, 0, 236);
            this.setRecord(i, new ShortEncryptedBuildRecord(rec));
            offset += 236;
        }
    }

    @Override
    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        int remaining = out.length - (curIndex + this.calculateWrittenLength());
        if (remaining < 0) {
            throw new I2NPMessageException("Not large enough (too short by " + remaining + ")");
        }
        if (this.RECORD_COUNT <= 0 || this.RECORD_COUNT > 8) {
            throw new I2NPMessageException("Bad record count " + this.RECORD_COUNT);
        }
        out[curIndex++] = (byte)this.RECORD_COUNT;
        out[curIndex++] = (byte)this._plaintextSlot;
        DataHelper.toLong(out, curIndex, 2, this._plaintextRecord.length);
        System.arraycopy(this._plaintextRecord, 0, out, curIndex += 2, this._plaintextRecord.length);
        curIndex += this._plaintextRecord.length;
        for (int i = 0; i < this.RECORD_COUNT; ++i) {
            if (i == this._plaintextSlot) continue;
            System.arraycopy(this._records[i].getData(), 0, out, curIndex, 236);
            curIndex += 236;
        }
        return curIndex;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[OutboundTunnelBuildReplyMessage: \n\tID: ").append(this.getUniqueId()).append("\n\tRecords: ").append(this.getRecordCount()).append(']');
        return buf.toString();
    }
}

