/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.util.Map;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.socks.SOCKSHeader;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;

public class SOCKSUDPWrapper
implements Source,
Sink {
    private Sink sink;
    private Map<Destination, SOCKSHeader> cache;

    public SOCKSUDPWrapper(Map<Destination, SOCKSHeader> cache) {
        this.cache = cache;
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public void start() {
    }

    @Override
    public void send(Destination from, byte[] data) {
        if (this.sink == null) {
            return;
        }
        SOCKSHeader h = this.cache.get(from);
        if (h == null) {
            return;
        }
        byte[] header = h.getBytes();
        byte[] wrapped = new byte[header.length + data.length];
        System.arraycopy(header, 0, wrapped, 0, header.length);
        System.arraycopy(data, 0, wrapped, header.length, data.length);
        this.sink.send(from, wrapped);
    }
}

