/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GDLabel;
import docking.widgets.textfield.IntegerTextField;
import ghidra.app.util.viewer.field.ArrayElementWrappedOption;
import ghidra.framework.options.CustomOptionsEditor;
import ghidra.util.HTMLUtilities;
import ghidra.util.layout.VerticalLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditorSupport;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ArrayElementPropertyEditor
extends PropertyEditorSupport
implements CustomOptionsEditor {
    private static final String SHOW_MULTI_ELEMENTS_LABEL = "Group Array Elements";
    private static final String GROUP_SIZE_LABEL = "Elements Per Line";
    private static final String[] NAMES = new String[]{"Group Array Elements", "Elements Per Line"};
    private static final String SHOW_MULTI_ELEMENTS_TOOLTIP = HTMLUtilities.toWrappedHTML((String)"Groups multiple array elements on the same listing line", (int)75);
    private static final String GROUP_SIZE_LABEL_TOOLTIP = HTMLUtilities.toWrappedHTML((String)"Number of array elements to show on a line", (int)75);
    private static final String[] DESCRIPTIONS = new String[]{SHOW_MULTI_ELEMENTS_TOOLTIP, GROUP_SIZE_LABEL_TOOLTIP};
    private ArrayElementWrappedOption elementWrappedOption;
    private Component editorComponent = this.buildEditor();
    private JCheckBox groupElementsCheckBox;
    private IntegerTextField elementsPerLineField;
    private JComponent elementsLabel;

    private Component buildEditor() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(3));
        this.groupElementsCheckBox = new GCheckBox(SHOW_MULTI_ELEMENTS_LABEL);
        this.groupElementsCheckBox.setSelected(true);
        this.groupElementsCheckBox.setToolTipText(SHOW_MULTI_ELEMENTS_TOOLTIP);
        panel.add(this.groupElementsCheckBox);
        this.elementsPerLineField = this.createLocalPrefixTextField(GROUP_SIZE_LABEL, GROUP_SIZE_LABEL_TOOLTIP, panel);
        this.elementsLabel.setToolTipText(GROUP_SIZE_LABEL_TOOLTIP);
        this.groupElementsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = ArrayElementPropertyEditor.this.groupElementsCheckBox.isSelected();
                ArrayElementPropertyEditor.this.elementsPerLineField.setEnabled(enabled);
                ArrayElementPropertyEditor.this.elementsLabel.setEnabled(enabled);
                ArrayElementPropertyEditor.this.firePropertyChange();
            }
        });
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0), new TitledBorder("Grouping")));
        return panel;
    }

    private IntegerTextField createLocalPrefixTextField(String labelText, String tooltipText, Container parent) {
        IntegerTextField textField = new IntegerTextField(10);
        textField.setAllowNegativeValues(false);
        textField.setEnabled(true);
        JPanel textFieldPanel = new JPanel();
        textFieldPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.elementsLabel = new GDLabel(labelText);
        textFieldPanel.add(this.elementsLabel);
        textFieldPanel.add(textField.getComponent());
        textField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ArrayElementPropertyEditor.this.firePropertyChange();
            }
        });
        parent.add(textFieldPanel);
        return textField;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof ArrayElementWrappedOption)) {
            return;
        }
        this.elementWrappedOption = (ArrayElementWrappedOption)value;
        this.setLocalValues(this.elementWrappedOption);
        this.firePropertyChange();
    }

    private void setLocalValues(ArrayElementWrappedOption namespaceOption) {
        if (namespaceOption.showMultipleArrayElementPerLine() != this.groupElementsCheckBox.isSelected()) {
            this.groupElementsCheckBox.setSelected(namespaceOption.showMultipleArrayElementPerLine());
        }
        if (namespaceOption.getArrayElementsPerLine() != this.elementsPerLineField.getIntValue()) {
            this.elementsPerLineField.setValue(namespaceOption.getArrayElementsPerLine());
        }
        boolean enabled = this.groupElementsCheckBox.isSelected();
        this.elementsPerLineField.setEnabled(enabled);
    }

    private ArrayElementWrappedOption cloneNamespaceValues() {
        ArrayElementWrappedOption newOption = new ArrayElementWrappedOption();
        newOption.setShowMultipleArrayElementPerLine(this.groupElementsCheckBox.isSelected());
        newOption.setArrayElementsPerLine(this.elementsPerLineField.getIntValue());
        return newOption;
    }

    public String[] getOptionDescriptions() {
        return DESCRIPTIONS;
    }

    public String[] getOptionNames() {
        return NAMES;
    }

    @Override
    public Object getValue() {
        return this.cloneNamespaceValues();
    }

    @Override
    public Component getCustomEditor() {
        return this.editorComponent;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }
}

