/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import generic.io.NullPrintWriter;
import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUnsupportedClassVersionError;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.JavaScriptClassLoader;
import ghidra.app.script.ResourceFileJavaFileManager;
import ghidra.app.script.ResourceFileJavaFileObject;
import ghidra.app.script.ScriptInfo;
import ghidra.app.util.headless.HeadlessScript;
import ghidra.util.Msg;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public class JavaScriptProvider
extends GhidraScriptProvider {
    private JavaScriptClassLoader loader = new JavaScriptClassLoader();

    @Override
    public String getDescription() {
        return "Java";
    }

    @Override
    public String getExtension() {
        return ".java";
    }

    @Override
    public boolean deleteScript(ResourceFile scriptSource) {
        File clazzFile = this.getClassFile(scriptSource, GhidraScriptUtil.getBaseName(scriptSource));
        clazzFile.delete();
        return super.deleteScript(scriptSource);
    }

    @Override
    public GhidraScript getScriptInstance(ResourceFile sourceFile, PrintWriter writer) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        File clazzFile;
        if (writer == null) {
            writer = new NullPrintWriter();
        }
        if (this.needsCompile(sourceFile, clazzFile = this.getClassFile(sourceFile, GhidraScriptUtil.getBaseName(sourceFile)))) {
            this.compile(sourceFile, writer);
        } else if (this.scriptCompiledExternally(clazzFile)) {
            this.forceClassReload();
        }
        String clazzName = GhidraScriptUtil.getBaseName(sourceFile);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(clazzName, true, this.loader);
        }
        catch (GhidraScriptUnsupportedClassVersionError e) {
            ResourceFile classFile = e.getClassFile();
            classFile.delete();
            return this.getScriptInstance(sourceFile, writer);
        }
        Object object = clazz.newInstance();
        if (object instanceof GhidraScript) {
            GhidraScript script = (GhidraScript)object;
            script.setSourceFile(sourceFile);
            return script;
        }
        String message = "Not a valid Ghidra script: " + sourceFile.getName();
        writer.println(message);
        Msg.error((Object)this, (Object)message);
        return null;
    }

    private void forceClassReload() {
        this.loader = new JavaScriptClassLoader();
    }

    protected File getClassFile(ResourceFile sourceFile, String className) {
        ResourceFile resourceFile = GhidraScriptUtil.getClassFileByResourceFile(sourceFile, className);
        File file = resourceFile.getFile(false);
        return file;
    }

    protected boolean needsCompile(ResourceFile sourceFile, File classFile) {
        if (!classFile.exists()) {
            return true;
        }
        if (sourceFile.lastModified() > classFile.lastModified()) {
            return true;
        }
        return !this.areAllParentClassesUpToDate(sourceFile);
    }

    protected boolean scriptCompiledExternally(File classFile) {
        Long modifiedTimeWhenLoaded = this.loader.lastModified(classFile);
        if (modifiedTimeWhenLoaded == null) {
            return false;
        }
        return classFile.lastModified() > modifiedTimeWhenLoaded;
    }

    private boolean areAllParentClassesUpToDate(ResourceFile sourceFile) {
        List<Class<?>> parentClasses = this.getParentClasses(sourceFile);
        if (parentClasses == null) {
            return false;
        }
        if (parentClasses.isEmpty()) {
            return true;
        }
        for (Class<?> clazz : parentClasses) {
            ResourceFile parentFile = this.getSourceFile(clazz);
            if (parentFile == null) continue;
            File clazzFile = this.getClassFile(parentFile, clazz.getName());
            if (parentFile.lastModified() <= clazzFile.lastModified()) continue;
            return false;
        }
        return true;
    }

    protected boolean compile(ResourceFile sourceFile, PrintWriter writer) throws ClassNotFoundException {
        ScriptInfo info = GhidraScriptUtil.getScriptInfo(sourceFile);
        info.setCompileErrors(true);
        if (!this.doCompile(sourceFile, writer)) {
            writer.flush();
            throw new ClassNotFoundException("Unable to compile class: " + sourceFile.getName());
        }
        this.compileParentClasses(sourceFile, writer);
        this.forceClassReload();
        info.setCompileErrors(false);
        writer.println("Successfully compiled: " + sourceFile.getName());
        return true;
    }

    private boolean doCompile(ResourceFile sourceFile, PrintWriter writer) {
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (javaCompiler == null) {
            String message = "Compile failed: java compiler provider not found (you must be using a JDK to compile scripts)!";
            writer.println(message);
            Msg.error((Object)this, (Object)message);
            return false;
        }
        ResourceFileJavaFileManager fileManager = new ResourceFileJavaFileManager(GhidraScriptUtil.getScriptSourceDirectories());
        ArrayList<ResourceFileJavaFileObject> list = new ArrayList<ResourceFileJavaFileObject>();
        list.add(new ResourceFileJavaFileObject(sourceFile.getParentFile(), sourceFile, JavaFileObject.Kind.SOURCE));
        String outputDirectory = GhidraScriptUtil.getScriptCompileOutputDirectory(sourceFile).getAbsolutePath();
        Msg.trace((Object)this, (Object)("Compiling script " + sourceFile + " to dir " + outputDirectory));
        ArrayList<String> options = new ArrayList<String>();
        options.add("-g");
        options.add("-d");
        options.add(outputDirectory);
        options.add("-sourcepath");
        options.add(this.getSourcePath());
        options.add("-classpath");
        options.add(this.getClassPath());
        options.add("-proc:none");
        JavaCompiler.CompilationTask task = javaCompiler.getTask(writer, fileManager, null, options, null, list);
        return task.call();
    }

    private List<Class<?>> getParentClasses(ResourceFile scriptSourceFile) {
        Class<?> scriptClass = this.getScriptClass(scriptSourceFile);
        if (scriptClass == null) {
            return null;
        }
        ArrayList parentClasses = new ArrayList();
        for (Class<?> superClass = scriptClass.getSuperclass(); superClass != null && !superClass.equals(GhidraScript.class) && !superClass.equals(HeadlessScript.class); superClass = superClass.getSuperclass()) {
            parentClasses.add(superClass);
        }
        return parentClasses;
    }

    private Class<?> getScriptClass(ResourceFile scriptSourceFile) {
        String clazzName = GhidraScriptUtil.getBaseName(scriptSourceFile);
        try {
            return Class.forName(clazzName, true, new JavaScriptClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            Msg.error((Object)this, (Object)("Unable to find class file for script file: " + scriptSourceFile), (Throwable)e);
        }
        catch (GhidraScriptUnsupportedClassVersionError e) {
            ResourceFile classFile = e.getClassFile();
            classFile.delete();
            return null;
        }
        return null;
    }

    private void compileParentClasses(ResourceFile sourceFile, PrintWriter writer) {
        List<Class<?>> parentClasses = this.getParentClasses(sourceFile);
        if (parentClasses == null) {
            return;
        }
        if (parentClasses.isEmpty()) {
            return;
        }
        Collections.reverse(parentClasses);
        Class<?> scriptClass = this.getScriptClass(sourceFile);
        if (scriptClass == null) {
            return;
        }
        parentClasses.add(scriptClass);
        for (Class<?> parentClass : parentClasses) {
            ResourceFile parentFile = this.getSourceFile(parentClass);
            if (parentFile == null || this.doCompile(parentFile, writer)) continue;
            Msg.error((Object)this, (Object)("Failed to re-compile parent class: " + parentClass));
            return;
        }
    }

    private ResourceFile getSourceFile(Class<?> c) {
        String classname = c.getName();
        String filename = classname.replace('.', '/') + ".java";
        List<ResourceFile> scriptDirs = GhidraScriptUtil.getScriptSourceDirectories();
        for (ResourceFile dir : scriptDirs) {
            ResourceFile possibleFile = new ResourceFile(dir, filename);
            if (!possibleFile.exists()) continue;
            return possibleFile;
        }
        return null;
    }

    private String getSourcePath() {
        Object classpath = System.getProperty("java.class.path");
        List<ResourceFile> dirs = GhidraScriptUtil.getScriptSourceDirectories();
        for (ResourceFile dir : dirs) {
            classpath = (String)classpath + System.getProperty("path.separator") + dir.getAbsolutePath();
        }
        return classpath;
    }

    private String getClassPath() {
        Object classpath = System.getProperty("java.class.path");
        List<ResourceFile> dirs = GhidraScriptUtil.getScriptBinDirectories();
        for (ResourceFile dir : dirs) {
            classpath = (String)classpath + System.getProperty("path.separator") + dir.getAbsolutePath();
        }
        return classpath;
    }

    @Override
    public void createNewScript(ResourceFile newScript, String category) throws IOException {
        String scriptName;
        String className = scriptName = newScript.getName();
        int dotpos = scriptName.lastIndexOf(46);
        if (dotpos >= 0) {
            className = scriptName.substring(0, dotpos);
        }
        PrintWriter writer = new PrintWriter(new FileWriter(newScript.getFile(false)));
        this.writeHeader(writer, category);
        writer.println("import ghidra.app.script.GhidraScript;");
        for (Package pkg : Package.getPackages()) {
            if (!pkg.getName().startsWith("ghidra.program.model.")) continue;
            writer.println("import " + pkg.getName() + ".*;");
        }
        writer.println("");
        writer.println("public class " + className + " extends GhidraScript {");
        writer.println("");
        writer.println("    public void run() throws Exception {");
        this.writeBody(writer);
        writer.println("    }");
        writer.println("");
        writer.println("}");
        writer.close();
    }

    @Override
    public String getCommentCharacter() {
        return "//";
    }
}

