/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.label.LabelMgrPlugin;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import javax.swing.KeyStroke;

class RemoveLabelAction
extends ListingContextAction {
    private LabelMgrPlugin plugin;
    private static final String[] POPUP_PATH = new String[]{"Remove Label"};
    private static final KeyStroke KEYBINDING = KeyStroke.getKeyStroke(127, 0);

    RemoveLabelAction(LabelMgrPlugin plugin) {
        super("Remove Label", plugin.getName());
        this.setPopupMenuData(new MenuData(POPUP_PATH, null, "Label"));
        this.setKeyBindingData(new KeyBindingData(KEYBINDING));
        this.plugin = plugin;
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.removeLabelCallback(context);
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        return !this.plugin.isOnExternalReference(context) && this.isOnSymbol(context);
    }

    public boolean isValidGlobalContext(ActionContext globalContext) {
        return false;
    }

    boolean isOnSymbol(ListingActionContext context) {
        Symbol s = this.plugin.getSymbol(context);
        return s instanceof CodeSymbol && !s.isDynamic() || s instanceof FunctionSymbol && s.getSource() != SourceType.DEFAULT;
    }

    public void dispose() {
        super.dispose();
        this.plugin = null;
    }
}

