/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class PdbProgramAttributes {
    private String pdbAge;
    private String pdbGuid;
    private String pdbSignature;
    private String guidAgeCombo;
    private String pdbFile;
    private boolean pdbLoaded;
    private boolean programAnalyzed;
    private String executablePath;
    private List<String> potentialPdbFilenames = null;

    public PdbProgramAttributes(Program program) {
        Options propList = program.getOptions("Program Information");
        this.pdbGuid = propList.getString("PDB GUID", (String)null);
        this.pdbAge = propList.getString("PDB Age", (String)null);
        this.pdbLoaded = propList.getBoolean("PDB Loaded", false);
        this.programAnalyzed = propList.getBoolean("Analyzed", false);
        this.pdbSignature = propList.getString("PDB Signature", (String)null);
        this.pdbFile = propList.getString("PDB File", (String)null);
        this.executablePath = program.getExecutablePath();
        this.createGuidAgeString();
    }

    public PdbProgramAttributes(String guid, String age, boolean loaded, boolean analyzed, String signature, String file, String execPath) {
        this.pdbGuid = guid;
        this.pdbAge = age;
        this.pdbLoaded = loaded;
        this.programAnalyzed = analyzed;
        this.pdbSignature = signature;
        this.pdbFile = file;
        this.executablePath = execPath;
        this.createGuidAgeString();
    }

    public String getPdbAge() {
        return this.pdbAge;
    }

    public String getPdbGuid() {
        return this.pdbGuid;
    }

    public String getPdbSignature() {
        return this.pdbSignature;
    }

    public String getPdbFile() {
        return this.pdbFile;
    }

    public boolean isPdbLoaded() {
        return this.pdbLoaded;
    }

    public String getExecutablePath() {
        return this.executablePath;
    }

    public boolean isProgramAnalyzed() {
        return this.programAnalyzed;
    }

    public List<String> getPotentialPdbFilenames() {
        if (this.potentialPdbFilenames == null) {
            LinkedHashSet<Object> setOfPotentialFilenames = new LinkedHashSet<Object>();
            if (this.pdbFile != null) {
                setOfPotentialFilenames.add(PdbProgramAttributes.getFilename(this.pdbFile).toLowerCase());
                setOfPotentialFilenames.add(this.pdbFile);
            }
            if (!this.executablePath.equals("unknown")) {
                String executableFilename = PdbProgramAttributes.getFilename(this.executablePath);
                setOfPotentialFilenames.add(this.getBinaryBasename(executableFilename).toLowerCase() + PdbParser.PdbFileType.PDB.toString());
            }
            this.potentialPdbFilenames = new ArrayList<String>(setOfPotentialFilenames);
        }
        return this.potentialPdbFilenames;
    }

    public String getGuidAgeCombo() {
        return this.guidAgeCombo;
    }

    private String getBinaryBasename(String filename) {
        String binaryName = filename;
        int dotpos = binaryName.lastIndexOf(46);
        if (dotpos > 0) {
            binaryName = binaryName.substring(0, dotpos);
        }
        return binaryName;
    }

    private void createGuidAgeString() {
        if (this.pdbGuid == null && this.pdbSignature == null || this.pdbAge == null) {
            this.guidAgeCombo = null;
            return;
        }
        this.guidAgeCombo = this.pdbGuid == null ? this.pdbSignature : this.pdbGuid;
        this.guidAgeCombo = this.guidAgeCombo.replaceAll("-", "");
        this.guidAgeCombo = this.guidAgeCombo.toUpperCase();
        int pdbAgeDecimal = Integer.parseInt(this.pdbAge, 16);
        this.guidAgeCombo = this.guidAgeCombo + pdbAgeDecimal;
    }

    private static String getFilename(String fullPath) {
        String editedPath = fullPath;
        editedPath = editedPath.replaceAll("[\\/]$", "");
        int lastIndexForwardSlash = editedPath.lastIndexOf(47);
        int lastIndexBackSlash = editedPath.lastIndexOf(92);
        if (lastIndexForwardSlash == -1 && lastIndexBackSlash == -1) {
            return editedPath;
        }
        int indexToUse = lastIndexForwardSlash > lastIndexBackSlash ? lastIndexForwardSlash : lastIndexBackSlash;
        return editedPath.substring(indexToUse + 1);
    }
}

