/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.format.pdb.PdbBitField;
import ghidra.app.util.bin.format.pdb.PdbDataTypeParser;
import ghidra.app.util.bin.format.pdb.PdbKind;
import ghidra.app.util.bin.format.pdb.PdbMember;
import ghidra.app.util.bin.format.pdb.WrappedDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;

public class DefaultPdbMember
extends PdbMember {
    final PdbKind kind;
    private boolean isBitField;
    private int bitFieldSize = -1;
    private int bitFieldOffset = -1;
    private final PdbDataTypeParser dataTypeParser;

    DefaultPdbMember(String name, String dataTypeName, int offset, PdbKind kind, PdbDataTypeParser dataTypeParser) {
        super(DefaultPdbMember.getMemberName(name, kind), dataTypeName, offset);
        this.kind = kind;
        this.dataTypeParser = dataTypeParser;
        this.parseBitField(name);
    }

    public PdbKind getKind() {
        return this.kind;
    }

    @Override
    public String toString() {
        Object str = super.toString();
        if (this.isBitField) {
            str = (String)str + ", bitSize=" + this.bitFieldSize + ", bitOffset=" + this.bitFieldOffset;
        }
        return str;
    }

    private static String getMemberName(String name, PdbKind kind) {
        int bitFieldColonIndex;
        if (name == null) {
            return null;
        }
        if (kind == PdbKind.MEMBER && (bitFieldColonIndex = name.indexOf(58)) >= 0) {
            return name.substring(0, bitFieldColonIndex);
        }
        int lastColonIndex = name.lastIndexOf(58);
        if (lastColonIndex > 0) {
            name = name.substring(lastColonIndex + 1);
        }
        return name;
    }

    @Override
    protected WrappedDataType getDataType() throws CancelledException {
        WrappedDataType wrappedDt = this.dataTypeParser.findDataType(this.getDataTypeName());
        if (wrappedDt != null && this.isBitField) {
            PdbBitField bitFieldDt;
            if (wrappedDt.isZeroLengthArray()) {
                return null;
            }
            try {
                DataType baseDataType = wrappedDt.getDataType().clone(this.dataTypeParser.getProgramDataTypeManager());
                bitFieldDt = new PdbBitField(baseDataType, this.bitFieldSize, this.bitFieldOffset >= 0 ? this.bitFieldOffset : 0);
            }
            catch (InvalidDataTypeException e) {
                Msg.error((Object)this, (Object)("PDB parse error: " + e.getMessage()));
                return null;
            }
            wrappedDt = new WrappedDataType((DataType)bitFieldDt, false, false);
        }
        return wrappedDt;
    }

    private void parseBitField(String name) {
        if (name == null || this.kind != PdbKind.MEMBER) {
            return;
        }
        int bitFieldColonIndex = name.indexOf(58);
        if (bitFieldColonIndex >= 0) {
            this.isBitField = true;
            String bitSizeOffsetStr = name.substring(bitFieldColonIndex + 1);
            try {
                int colonIndex = bitSizeOffsetStr.indexOf(58);
                if (colonIndex > 0) {
                    this.bitFieldOffset = (int)NumericUtilities.parseNumber((String)bitSizeOffsetStr.substring(colonIndex + 1));
                    bitSizeOffsetStr = bitSizeOffsetStr.substring(0, colonIndex);
                } else {
                    this.dataTypeParser.setMissingBitOffsetError();
                }
                this.bitFieldSize = (int)NumericUtilities.parseNumber((String)bitSizeOffsetStr);
            }
            catch (NumberFormatException e) {
                Msg.error((Object)this, (Object)("Invalid PDB bitfield specification: " + name));
            }
        }
    }
}

