/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.FillOutStructureCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import java.awt.Component;

public abstract class CreateStructureVariableAction
extends DockingAction {
    protected final DecompilerController controller;
    private final PluginTool tool;

    public CreateStructureVariableAction(String owner, PluginTool tool, DecompilerController controller) {
        super("Recover Structure Variable", owner);
        this.tool = tool;
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Auto Create Structure"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(91, 64));
    }

    static boolean testForAutoParameterThis(HighVariable var, Function f) {
        int slot;
        Parameter parameter;
        return var instanceof HighParam && (parameter = f.getParameter(slot = ((HighParam)var).getSlot())) != null && parameter.getAutoParameterType() == AutoParameterType.THIS;
    }

    public static Structure getStructureForExtending(DataType dt) {
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (!(dt instanceof Pointer)) {
            return null;
        }
        dt = ((Pointer)dt).getDataType();
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (dt instanceof Structure) {
            return (Structure)dt;
        }
        return null;
    }

    public abstract boolean isEnabledForContext(ActionContext var1);

    protected void adjustCreateStructureMenuText(DataType dt, boolean isThisParam) {
        dt = CreateStructureVariableAction.getStructureForExtending(dt);
        String menuString = "Auto Create Structure";
        if (dt != null) {
            menuString = isThisParam ? "Auto Fill in Class Structure" : "Auto Fill in Structure";
        } else if (isThisParam) {
            menuString = "Auto Create Class Structure";
        }
        this.getPopupMenuData().setMenuItemName(menuString);
    }

    public void actionPerformed(ActionContext context) {
        ProgramLocation location = null;
        Program program = null;
        if (context instanceof DecompilerActionContext) {
            DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
            if (decompilerActionContext.isDecompiling()) {
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
                return;
            }
            location = decompilerActionContext.getLocation();
            program = decompilerActionContext.getProgram();
        } else if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            location = listingContext.getLocation();
            program = listingContext.getProgram();
        } else {
            return;
        }
        FillOutStructureCmd task = new FillOutStructureCmd(program, location, this.tool);
        task.applyTo((DomainObject)program);
    }
}

