/*
 * Decompiled with CFR 0.152.
 */
package mobiledevices.dmg.ghidra;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import mobiledevices.dmg.ghidra.GRandomAccessFile;

public class GByteProvider
implements Closeable {
    private File file;
    private GRandomAccessFile randomAccessFile;

    public GByteProvider(File file) throws IOException {
        this.file = file;
        this.randomAccessFile = new GRandomAccessFile(file, "r");
    }

    public GByteProvider(File file, String permissions) throws IOException {
        this.file = file;
        this.randomAccessFile = new GRandomAccessFile(file, permissions);
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public InputStream getInputStream(long index) throws IOException {
        FileInputStream is = new FileInputStream(this.file);
        is.skip(index);
        return is;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    public long length() throws IOException {
        return this.randomAccessFile.length();
    }

    public boolean isValidIndex(long index) {
        try {
            return index >= 0L && index < this.randomAccessFile.length();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public byte readByte(long index) throws IOException {
        this.randomAccessFile.seek(index);
        return this.randomAccessFile.readByte();
    }

    public byte[] readBytes(long index, long length) throws IOException {
        this.randomAccessFile.seek(index);
        byte[] b = new byte[(int)length];
        int nRead = this.randomAccessFile.read(b);
        if ((long)nRead != length) {
            throw new IOException("Unable to read " + length + " bytes");
        }
        return b;
    }

    public void writeByte(long index, byte value) throws IOException {
        this.randomAccessFile.seek(index);
        this.randomAccessFile.write(value);
    }

    public void writeBytes(long index, byte[] values) throws IOException {
        this.randomAccessFile.seek(index);
        this.randomAccessFile.write(values);
    }
}

