/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import java.util.HashSet;

public class PointerDataType
extends BuiltIn
implements Pointer {
    private static final long serialVersionUID = 1L;
    public static final PointerDataType dataType = new PointerDataType();
    public static final int MAX_POINTER_SIZE_BYTES = 8;
    public static final String POINTER_NAME = "pointer";
    public static final String POINTER_LABEL_PREFIX = "PTR";
    public static final String POINTER_LOOP_LABEL_PREFIX = "PTR_LOOP";
    protected DataType referencedDataType;
    protected int length;
    private boolean deleted = false;
    private String displayName;

    public PointerDataType() {
        this(null, -1, null);
    }

    public PointerDataType(DataTypeManager dtm) {
        this(null, -1, dtm);
    }

    public PointerDataType(DataType referencedDataType) {
        this(referencedDataType, -1, null);
    }

    public PointerDataType(DataType referencedDataType, int length) {
        this(referencedDataType, length, null);
    }

    public PointerDataType(DataType referencedDataType, DataTypeManager dtm) {
        this(referencedDataType, -1, dtm);
    }

    public PointerDataType(DataType referencedDataType, int length, DataTypeManager dtm) {
        super(referencedDataType != null ? referencedDataType.getCategoryPath() : null, PointerDataType.constructUniqueName(referencedDataType, length), dtm);
        if (referencedDataType instanceof BitFieldDataType) {
            throw new IllegalArgumentException("Pointer reference data-type may not be a bitfield: " + referencedDataType.getName());
        }
        this.length = length <= 0 ? -1 : length;
        this.referencedDataType = referencedDataType;
        if (referencedDataType != null) {
            referencedDataType.addParent(this);
        }
    }

    @Override
    public final DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new PointerDataType(this.referencedDataType, this.length, dtm);
    }

    @Override
    public DataType getDataType() {
        return this.referencedDataType;
    }

    @Override
    public boolean isDynamicallySized() {
        return this.length <= 0;
    }

    @Override
    public int getLength() {
        return this.length <= 0 ? this.getDataOrganization().getPointerSize() : this.length;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return POINTER_LABEL_PREFIX;
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return PointerDataType.getLabelString(buf, settings, this.getLength(), options);
    }

    public static String getLabelString(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        Program program = buf.getMemory().getProgram();
        if (program == null) {
            return POINTER_LABEL_PREFIX;
        }
        Address fromAddr = buf.getAddress();
        ReferenceManager refMgr = program.getReferenceManager();
        Reference ref = refMgr.getPrimaryReferenceFrom(fromAddr, 0);
        if (ref == null) {
            return POINTER_LABEL_PREFIX;
        }
        PointerReferenceClassification pointerClassification = PointerDataType.getPointerClassification(program, ref);
        if (pointerClassification == PointerReferenceClassification.DEEP) {
            return "PTR_PTR";
        }
        if (pointerClassification == PointerReferenceClassification.LOOP) {
            return POINTER_LOOP_LABEL_PREFIX;
        }
        Symbol symbol = program.getSymbolTable().getSymbol(ref);
        if (symbol == null) {
            return POINTER_LABEL_PREFIX;
        }
        String symName = symbol.getName();
        symName = SymbolUtilities.getCleanSymbolName(symName, ref.getToAddress());
        symName = symName.replace("::", "_");
        return "PTR_" + symName;
    }

    private static PointerReferenceClassification getPointerClassification(Program program, Reference ref) {
        Address fromAddr = ref.getFromAddress();
        HashSet<Address> refAddrs = new HashSet<Address>();
        refAddrs.add(fromAddr);
        int depth = 0;
        while (ref != null && ref.isMemoryReference()) {
            Address toAddr = ref.getToAddress();
            if (!refAddrs.add(toAddr)) {
                return PointerReferenceClassification.LOOP;
            }
            if (++depth > 2) {
                return PointerReferenceClassification.DEEP;
            }
            Data data = PointerDataType.getDataAt(program, toAddr);
            if (data == null) break;
            ref = data.getPrimaryReference(0);
        }
        return PointerReferenceClassification.NORMAL;
    }

    private static Data getDataAt(Program program, Address addr) {
        int offset;
        Listing listing = program.getListing();
        Data data = listing.getDataContaining(addr);
        if (data != null && (offset = (int)addr.subtract(data.getAddress())) != 0) {
            data = data.getPrimitiveAt(offset);
        }
        return data;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            DataType dt = this.getDataType();
            if (dt == null) {
                this.displayName = POINTER_NAME;
                if (this.length > 0) {
                    this.displayName = this.displayName + Integer.toString(8 * this.length);
                }
            } else {
                this.displayName = dt.getDisplayName() + " *";
            }
        }
        return this.displayName;
    }

    private static String constructUniqueName(DataType referencedDataType, int ptrLength) {
        if (referencedDataType == null) {
            Object s = POINTER_NAME;
            if (ptrLength > 0) {
                s = (String)s + Integer.toString(8 * ptrLength);
            }
            return s;
        }
        String s = referencedDataType.getName() + " *";
        if (ptrLength > 0) {
            s = s + Integer.toString(8 * ptrLength);
        }
        return s;
    }

    @Override
    public String getDescription() {
        StringBuffer sbuf = new StringBuffer();
        if (this.length > 0) {
            sbuf.append(Integer.toString(8 * this.length));
            sbuf.append("-bit ");
        }
        sbuf.append(POINTER_NAME);
        DataType dt = this.getDataType();
        if (dt != null) {
            sbuf.append(" to ");
            if (dt instanceof Pointer) {
                sbuf.append(this.getDataType().getDescription());
            } else {
                sbuf.append(this.getDataType().getDisplayName());
            }
        }
        return sbuf.toString();
    }

    @Override
    public String getMnemonic(Settings settings) {
        if (this.referencedDataType == null || this.referencedDataType == DataType.DEFAULT) {
            return "addr";
        }
        return this.referencedDataType.getMnemonic(settings) + " *";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int len) {
        return PointerDataType.getAddressValue(buf, this.getLength(), buf.getAddress().getAddressSpace());
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Address.class;
    }

    public static Address getAddressValue(MemBuffer buf, int size, AddressSpace targetSpace) {
        if (size <= 0 || size > 8) {
            return null;
        }
        if (buf.getAddress() instanceof SegmentedAddress) {
            try {
                return PointerDataType.getSegmentedAddressValue(buf, size);
            }
            catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return null;
        }
        byte[] bytes = new byte[size];
        if (buf.getBytes(bytes, 0) != size) {
            return null;
        }
        boolean isBigEndian = buf.isBigEndian();
        if (!isBigEndian) {
            byte[] flipped = new byte[size];
            for (int i = 0; i < size; ++i) {
                flipped[i] = bytes[size - i - 1];
            }
            bytes = flipped;
        }
        long val = 0L;
        for (byte b : bytes) {
            val = (val << 8) + ((long)b & 0xFFL);
        }
        try {
            return targetSpace.getAddress(val, true);
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            return null;
        }
    }

    private static Address getSegmentedAddressValue(MemBuffer buf, int dataLen) {
        SegmentedAddress a = (SegmentedAddress)buf.getAddress();
        int segment = a.getSegment();
        int offset = 0;
        try {
            switch (dataLen) {
                case 1: {
                    offset = buf.getByte(0) & 0xFF;
                    break;
                }
                case 2: {
                    offset = buf.getShort(0) & 0xFFFF;
                    break;
                }
                case 4: 
                case 8: {
                    segment = buf.getShort(0) & 0xFFFF;
                    offset = buf.getShort(2) & 0xFFFF;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (MemoryAccessException e) {
            return null;
        }
        SegmentedAddressSpace space = (SegmentedAddressSpace)a.getAddressSpace();
        SegmentedAddress addr = space.getAddress(segment, offset);
        return PointerDataType.normalize(addr, buf.getMemory());
    }

    private static SegmentedAddress normalize(SegmentedAddress addr, Memory memory) {
        if (memory == null) {
            return addr;
        }
        MemoryBlock block = memory.getBlock(addr);
        if (block == null) {
            return addr;
        }
        SegmentedAddress start = (SegmentedAddress)block.getStart();
        return addr.normalize(start.getSegment());
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int len) {
        Address addr = (Address)this.getValue(buf, settings, len);
        if (addr == null) {
            return "NaP";
        }
        return addr.toString();
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == null) {
            return false;
        }
        if (this == dt) {
            return true;
        }
        if (!(dt instanceof Pointer)) {
            return false;
        }
        Pointer p = (Pointer)dt;
        DataType otherDataType = p.getDataType();
        if (this.isDynamicallySized() != p.isDynamicallySized()) {
            return false;
        }
        if (!this.isDynamicallySized() && this.getLength() != p.getLength()) {
            return false;
        }
        if (this.referencedDataType == null) {
            return otherDataType == null;
        }
        if (otherDataType == null) {
            return false;
        }
        if (DataTypeUtilities.isSameDataType(this.referencedDataType, otherDataType)) {
            return true;
        }
        return DataTypeUtilities.equalsIgnoreConflict(this.referencedDataType.getPathName(), otherDataType.getPathName());
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        if (this.referencedDataType == dt) {
            this.notifyDeleted();
            this.deleted = true;
        }
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        if (this.referencedDataType == oldDt) {
            this.referencedDataType.removeParent(this);
            this.referencedDataType = newDt;
            this.referencedDataType.addParent(this);
            this.displayName = null;
            String oldName = this.name;
            this.name = PointerDataType.constructUniqueName(this.referencedDataType, this.length);
            this.notifyNameChanged(oldName);
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
        if (this.referencedDataType == dt) {
            this.displayName = null;
            this.name = PointerDataType.constructUniqueName(this.referencedDataType, this.length);
            this.notifyNameChanged(oldName);
        }
    }

    @Override
    public CategoryPath getCategoryPath() {
        DataType dt = this.getDataType();
        if (dt == null) {
            return CategoryPath.ROOT;
        }
        return dt.getCategoryPath();
    }

    @Override
    public boolean dependsOn(DataType dt) {
        if (this.referencedDataType == null) {
            return false;
        }
        return this.referencedDataType == dt || this.referencedDataType.dependsOn(dt);
    }

    public static Pointer getPointer(DataType dt, DataTypeManager dtm) {
        return new PointerDataType(dt, dtm);
    }

    public static Pointer getPointer(DataType dt, int pointerSize) {
        if (pointerSize < 1 || pointerSize > 8) {
            return new PointerDataType(dt);
        }
        return new PointerDataType(dt, pointerSize);
    }

    @Override
    public Pointer newPointer(DataType dt) {
        if (dt != null) {
            dt = dt.clone(this.getDataTypeManager());
        }
        return new PointerDataType(dt, this.length, this.getDataTypeManager());
    }

    @Override
    public String getName() {
        if (this.referencedDataType != null) {
            this.name = PointerDataType.constructUniqueName(this.referencedDataType, this.length);
        }
        return super.getName();
    }

    private static enum PointerReferenceClassification {
        NORMAL,
        LOOP,
        DEEP;

    }
}

