/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.scalar.Scalar;

abstract class AbstractImageBaseOffsetDataType
extends BuiltIn {
    AbstractImageBaseOffsetDataType(CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
    }

    abstract DataType getScalarDataType();

    static String generateName(DataType dt) {
        return "ImageBaseOffset" + dt.getLength() * 8;
    }

    static String generateMnemonic(DataType dt) {
        return "ibo" + dt.getLength() * 8;
    }

    static String generateDescription(DataType dt) {
        return dt.getLength() * 8 + "-bit Image Base Offset";
    }

    @Override
    public String getDescription() {
        DataType dt = this.getScalarDataType();
        return AbstractImageBaseOffsetDataType.generateDescription(dt);
    }

    @Override
    public String getMnemonic(Settings settings) {
        DataType dt = this.getScalarDataType();
        return AbstractImageBaseOffsetDataType.generateMnemonic(dt);
    }

    @Override
    public int getLength() {
        return this.getScalarDataType().getLength();
    }

    @Override
    public boolean isDynamicallySized() {
        return false;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        Address addr = (Address)this.getValue(buf, settings, length);
        if (addr == null) {
            return "NaP";
        }
        return addr.toString();
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        DataType dt = this.getScalarDataType();
        Address imageBase = buf.getMemory().getProgram().getImageBase();
        Scalar value = (Scalar)dt.getValue(buf, settings, length);
        if (value != null && value.getUnsignedValue() != 0L) {
            try {
                return imageBase.add(value.getUnsignedValue());
            }
            catch (AddressOutOfBoundsException addressOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Address.class;
    }
}

