/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.catacombae.io.InputStreamReadable;
import org.catacombae.io.Readable;
import org.jdesktop.layout.GroupLayout;

public class DisplayTextFilePanel
extends JPanel {
    private static final String[] sortingPrefixes = new String[]{"US-ASCII", "UTF-8", "ISO-8859", "UTF", "IBM4", "IBM8", "IBM"};
    private byte[] fileData = new byte[]{0};
    private final Frame parentFrame;
    private final String baseTitle;
    private JComboBox encodingBox;
    private JLabel encodingLabel;
    private JTextArea textPane;
    private JScrollPane textPaneScroller;

    public DisplayTextFilePanel() {
        this((Frame)null);
    }

    public DisplayTextFilePanel(Frame parentFrame) {
        this.parentFrame = parentFrame;
        this.baseTitle = parentFrame != null ? parentFrame.getTitle() : "";
        this.initComponents();
        this.textPaneScroller.getVerticalScrollBar().setMinimum(0);
        this.textPaneScroller.getVerticalScrollBar().setMaximum(Integer.MAX_VALUE);
        this.textPaneScroller.getHorizontalScrollBar().setMinimum(0);
        this.textPaneScroller.getHorizontalScrollBar().setMaximum(Integer.MAX_VALUE);
        Set<String> keySet = Charset.availableCharsets().keySet();
        ArrayList<String> charsets = new ArrayList<String>(keySet);
        LinkedList<String> listItems = new LinkedList<String>();
        for (String prefix : sortingPrefixes) {
            int i = 0;
            while (i < charsets.size()) {
                String curCharset = charsets.get(i);
                if (curCharset.startsWith(prefix)) {
                    listItems.add(curCharset);
                    charsets.remove(i);
                    continue;
                }
                ++i;
            }
        }
        for (String curCharset : charsets) {
            listItems.add(curCharset);
        }
        this.encodingBox.removeAllItems();
        for (String curItem : listItems) {
            this.encodingBox.addItem(curItem);
        }
        if (this.encodingBox.getItemCount() > 0) {
            this.encodingBox.setSelectedIndex(0);
        }
        this.encodingBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DisplayTextFilePanel.this.refreshView();
            }
        });
    }

    public void loadFile(File file) {
        if (file.length() < Integer.MAX_VALUE) {
            try {
                FileInputStream fis = new FileInputStream(file);
                this.loadStream(fis);
                fis.close();
                if (this.parentFrame != null) {
                    this.parentFrame.setTitle(this.baseTitle + " - [" + file.getName() + "]");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Exception while loading file:\n  " + e + "\"");
            }
        } else {
            JOptionPane.showMessageDialog(this, "File too large for memory address space! (" + file.length() + "bytes)");
        }
    }

    public void loadStream(InputStream is) {
        this.loadStream((Readable)new InputStreamReadable(is));
    }

    public void loadStream(Readable is) {
        try {
            int bytesRead;
            byte[] tmp = new byte[65536];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((bytesRead = is.read(tmp)) > 0) {
                baos.write(tmp, 0, bytesRead);
            }
            this.fileData = baos.toByteArray();
            baos = null;
            this.refreshView();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int vMin = DisplayTextFilePanel.this.textPaneScroller.getVerticalScrollBar().getMinimum();
                    int hMin = DisplayTextFilePanel.this.textPaneScroller.getHorizontalScrollBar().getMinimum();
                    DisplayTextFilePanel.this.textPaneScroller.getVerticalScrollBar().setValue(vMin);
                    DisplayTextFilePanel.this.textPaneScroller.getHorizontalScrollBar().setValue(hMin);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Exception while loading file:\n  " + e + "\"");
        }
    }

    private void refreshView() {
        try {
            final int vValue = this.textPaneScroller.getVerticalScrollBar().getValue();
            final int hValue = this.textPaneScroller.getHorizontalScrollBar().getValue();
            this.textPane.setText(new String(this.fileData, this.getSelectedEncoding()));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DisplayTextFilePanel.this.textPaneScroller.getVerticalScrollBar().setValue(vValue);
                    DisplayTextFilePanel.this.textPaneScroller.getHorizontalScrollBar().setValue(hValue);
                }
            });
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Exception while decoding file data:\n  " + e + "\"");
        }
    }

    private String getSelectedEncoding() {
        return this.encodingBox.getSelectedItem().toString();
    }

    private void initComponents() {
        this.textPaneScroller = new JScrollPane();
        this.textPane = new JTextArea();
        this.encodingLabel = new JLabel();
        this.encodingBox = new JComboBox();
        this.textPane.setColumns(20);
        this.textPane.setEditable(false);
        this.textPane.setRows(5);
        this.textPaneScroller.setViewportView(this.textPane);
        this.encodingLabel.setText("Encoding:");
        this.encodingBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.encodingLabel).addPreferredGap(0).add((Component)this.encodingBox, 0, 650, Short.MAX_VALUE).addContainerGap()).add((Component)this.textPaneScroller, -1, 721, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.encodingLabel).add((Component)this.encodingBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.textPaneScroller, -1, 445, Short.MAX_VALUE)));
    }
}

