/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import generic.util.WindowUtilities;
import ghidra.util.bean.GGlassPane;
import ghidra.util.bean.GGlassPanePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PopupWindow {
    private static final int X_PADDING = 20;
    private static final int Y_PADDING = 20;
    private static final List<WeakReference<PopupWindow>> VISIBLE_POPUPS = new ArrayList<WeakReference<PopupWindow>>();
    private JWindow popup;
    private Component sourceComponent;
    private Rectangle neutralMotionZone;
    private MouseMotionListener sourceMouseMotionListener;
    private MouseListener sourceMouseListener;
    private Timer closeTimer;
    private JComponent displayComponent;

    public static void hideAllWindows() {
        for (WeakReference<PopupWindow> weakReference : VISIBLE_POPUPS) {
            PopupWindow popupWindow = (PopupWindow)weakReference.get();
            if (popupWindow == null) continue;
            popupWindow.hide();
        }
    }

    public PopupWindow(JComponent displayComponent) {
        this(PopupWindow.getDefaultParentWindow(), displayComponent);
    }

    public PopupWindow(Component sourceComponent, JComponent displayComponent) {
        this(PopupWindow.getParentWindow(sourceComponent), displayComponent);
    }

    private static Window getParentWindow(Component sourceComponent) {
        if (sourceComponent == null) {
            return PopupWindow.getDefaultParentWindow();
        }
        Window window = WindowUtilities.windowForComponent((Component)sourceComponent);
        if (window != null) {
            return window;
        }
        return PopupWindow.getDefaultParentWindow();
    }

    private static Window getDefaultParentWindow() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = kfm.getActiveWindow();
        if (activeWindow == null) {
            activeWindow = JOptionPane.getRootFrame();
        }
        return activeWindow;
    }

    public PopupWindow(Window parentWindow, JComponent displayComponent) {
        this.displayComponent = displayComponent;
        this.popup = new JWindow(parentWindow);
        this.popup.setFocusableWindowState(false);
        this.popup.getContentPane().add(displayComponent);
        this.popup.pack();
        this.closeTimer = new Timer(750, event -> this.hide());
        this.closeTimer.setRepeats(false);
        MouseAdapter closeWindowListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PopupWindow.this.closeTimer.stop();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PopupWindow.this.closeTimer.start();
            }
        };
        this.addMouseListener(this.popup, closeWindowListener);
        this.sourceMouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point localPoint = e.getPoint();
                SwingUtilities.convertPointToScreen(localPoint, e.getComponent());
                if (!PopupWindow.this.neutralMotionZone.contains(localPoint)) {
                    PopupWindow.this.hide();
                } else {
                    PopupWindow.this.closeTimer.start();
                }
                e.consume();
            }
        };
        this.sourceMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PopupWindow.this.hide();
            }
        };
    }

    private void addMouseListener(Container c, MouseListener listener) {
        Component[] children;
        c.addMouseListener(listener);
        for (Component element : children = c.getComponents()) {
            if (element instanceof Container) {
                this.addMouseListener((Container)element, listener);
                continue;
            }
            element.addMouseListener(listener);
        }
    }

    public JComponent getDisplayComponent() {
        return this.displayComponent;
    }

    public void setWindowName(String name) {
        this.popup.setName(name);
    }

    public void addComponentListener(ComponentListener listener) {
        this.popup.addComponentListener(listener);
    }

    public boolean isShowing() {
        return this.popup.isShowing();
    }

    public void hide() {
        this.popup.setVisible(false);
        if (this.sourceComponent != null) {
            this.sourceComponent.removeMouseMotionListener(this.sourceMouseMotionListener);
            this.sourceComponent.removeMouseListener(this.sourceMouseListener);
        }
        this.sourceComponent = null;
    }

    public void dispose() {
        this.hide();
        this.popup.dispose();
        this.removeOldPopupReferences();
    }

    private void removeOldPopupReferences() {
        Iterator<WeakReference<PopupWindow>> iterator = VISIBLE_POPUPS.iterator();
        while (iterator.hasNext()) {
            WeakReference<PopupWindow> reference = iterator.next();
            PopupWindow window = (PopupWindow)reference.get();
            if (window != this) continue;
            reference.clear();
            iterator.remove();
            return;
        }
    }

    public void pack() {
        this.popup.pack();
    }

    public void setCloseWindowDelay(int delayInMillis) {
        this.closeTimer = new Timer(delayInMillis, event -> this.hide());
        this.closeTimer.setRepeats(false);
    }

    public void showOffsetPopup(MouseEvent e, Dimension keepVisibleArea) {
        this.doShowPopup(e, keepVisibleArea);
    }

    public void showPopup(MouseEvent e) {
        this.doShowPopup(e, null);
    }

    private void doShowPopup(MouseEvent e, Dimension keepVisibleArea) {
        PopupWindow.hideAllWindows();
        this.sourceComponent = e.getComponent();
        this.sourceComponent.addMouseListener(this.sourceMouseListener);
        this.sourceComponent.addMouseMotionListener(this.sourceMouseMotionListener);
        Point point = e.getPoint();
        SwingUtilities.convertPointToScreen(point, this.sourceComponent);
        if (keepVisibleArea == null) {
            keepVisibleArea = new Dimension(0, 0);
        }
        Rectangle popupBounds = this.popup.getBounds();
        int x = point.x + keepVisibleArea.width + 20;
        int y = point.y + keepVisibleArea.height + 20;
        popupBounds.setLocation(x, y);
        WindowUtilities.ensureOnScreen((Component)this.sourceComponent, (Rectangle)popupBounds);
        Rectangle hoverArea = new Rectangle(point, keepVisibleArea);
        this.adjustBoundsForCursorLocation(popupBounds, hoverArea);
        this.neutralMotionZone = this.createNeutralMotionZone(popupBounds, hoverArea);
        this.installDebugPainter(e);
        this.popup.setBounds(popupBounds);
        this.popup.setVisible(true);
        this.removeOldPopupReferences();
        VISIBLE_POPUPS.add(new WeakReference<PopupWindow>(this));
    }

    private void installDebugPainter(MouseEvent e) {
    }

    private Rectangle adjustBoundsForCursorLocation(Rectangle bounds, Rectangle hoverArea) {
        boolean canMoveLeft;
        boolean canMoveUp;
        if (!bounds.intersects(hoverArea)) {
            return bounds;
        }
        int movedY = hoverArea.y - bounds.height;
        boolean bl = canMoveUp = movedY >= 0;
        if (canMoveUp) {
            bounds.y = movedY;
            return bounds;
        }
        int movedX = hoverArea.x - bounds.width;
        boolean bl2 = canMoveLeft = movedX >= 0;
        if (canMoveLeft) {
            bounds.x = movedX;
        }
        return bounds;
    }

    private Rectangle createNeutralMotionZone(Rectangle popupBounds, Rectangle hoverRectangle) {
        int newX = Math.min(hoverRectangle.x, popupBounds.x);
        int newY = Math.min(hoverRectangle.y, popupBounds.y);
        double hoverLowestCornerX = (double)hoverRectangle.x + hoverRectangle.getWidth();
        double popupLowestCornerX = (double)popupBounds.x + popupBounds.getWidth();
        int lowestCornerX = (int)Math.max(hoverLowestCornerX, popupLowestCornerX);
        double hoverLowestCornerY = (double)hoverRectangle.y + hoverRectangle.getHeight();
        double popupLowestCornerY = (double)popupBounds.y + popupBounds.getHeight();
        int lowestCornerY = (int)Math.max(hoverLowestCornerY, popupLowestCornerY);
        int width = this.difference(newX, lowestCornerX);
        int height = this.difference(newY, lowestCornerY);
        int padding = 25;
        return new Rectangle(newX -= padding, newY -= padding, width += padding * 2, height += padding * 2);
    }

    private int difference(int value1, int value2) {
        int abs2;
        int abs1 = Math.abs(value1);
        if (abs1 > (abs2 = Math.abs(value2))) {
            return abs1 - abs2;
        }
        return abs2 - abs1;
    }

    private class ShapeDebugPainter
    implements GGlassPanePainter {
        private MouseEvent sourceEvent;
        private Rectangle bounds;

        ShapeDebugPainter(MouseEvent sourceEvent, Rectangle bounds) {
            this.sourceEvent = sourceEvent;
            this.bounds = bounds;
        }

        public void paint(GGlassPane glassPane, Graphics graphics) {
            Rectangle r = this.bounds;
            Point p = new Point(r.getLocation());
            SwingUtilities.convertPointFromScreen(p, (Component)glassPane);
            Color c = new Color(50, 50, 200, 125);
            graphics.setColor(c);
            graphics.fillRect(p.x, p.y, r.width, r.height);
            p = this.sourceEvent.getPoint();
            p = SwingUtilities.convertPoint(this.sourceEvent.getComponent(), p.x, p.y, (Component)glassPane);
            graphics.setColor(Color.RED);
            int offset = 10;
            graphics.fillRect(p.x - offset, p.y - offset, offset * 2, offset * 2);
        }
    }
}

