(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/text/csv#+line-endings+
    (cons std/misc/string#+cr+
          (cons std/misc/string#+lf+ (cons std/misc/string#+crlf+ '()))))
  (define std/text/csv#+strict-line-endings+
    (cons std/misc/string#+crlf+ (cons std/misc/string#+lf+ '())))
  (define std/text/csv#csv-separator (make-parameter '#\,))
  (define std/text/csv#csv-quote (make-parameter '#\"))
  (define std/text/csv#csv-unquoted-quotequote? (make-parameter '#f))
  (define std/text/csv#csv-loose-quote? (make-parameter '#f))
  (define std/text/csv#csv-skip-whitespace? (make-parameter '#t))
  (define std/text/csv#csv-allow-binary? (make-parameter '#t))
  (define std/text/csv#csv-eol (make-parameter std/misc/string#+crlf+))
  (define std/text/csv#csv-line-endings
    (make-parameter std/text/csv#+line-endings+))
  (define std/text/csv#call-with-creativyst-csv-syntax
    (lambda (_thunk709_)
      (call-with-parameters
       (lambda () (_thunk709_))
       std/text/csv#csv-separator
       '#\,
       std/text/csv#csv-quote
       '#\"
       std/text/csv#csv-unquoted-quotequote?
       '#f
       std/text/csv#csv-loose-quote?
       '#f
       std/text/csv#csv-allow-binary?
       '#t
       std/text/csv#csv-eol
       std/misc/string#+crlf+
       std/text/csv#csv-line-endings
       std/text/csv#+line-endings+
       std/text/csv#csv-skip-whitespace?
       '#t)))
  (define std/text/csv#call-with-rfc4180-csv-syntax
    (lambda (_thunk706_)
      (call-with-parameters
       (lambda () (_thunk706_))
       std/text/csv#csv-separator
       '#\,
       std/text/csv#csv-quote
       '#\"
       std/text/csv#csv-unquoted-quotequote?
       '#f
       std/text/csv#csv-loose-quote?
       '#f
       std/text/csv#csv-allow-binary?
       '#t
       std/text/csv#csv-eol
       std/misc/string#+lf+
       std/text/csv#csv-line-endings
       std/text/csv#+strict-line-endings+
       std/text/csv#csv-skip-whitespace?
       '#f)))
  (define std/text/csv#call-with-strict-rfc4180-csv-syntax
    (lambda (_thunk702_)
      (std/text/csv#call-with-rfc4180-csv-syntax
       (lambda ()
         (call-with-parameters
          (lambda () (_thunk702_))
          std/text/csv#csv-line-endings
          std/text/csv#+strict-line-endings+
          std/text/csv#csv-allow-binary?
          '#f)))))
  (define std/text/csv#valid-eol?
    (lambda (_x700_) (member _x700_ std/text/csv#+line-endings+)))
  (define std/text/csv#validate-csv-parameters
    (lambda ()
      (if (char? (std/text/csv#csv-separator))
          '#!void
          (error '"Assertion failed" '(char? (csv-separator))))
      (if (char? (std/text/csv#csv-quote))
          '#!void
          (error '"Assertion failed" '(char? (csv-quote))))
      (if (not (equal? (std/text/csv#csv-separator) (std/text/csv#csv-quote)))
          '#!void
          (error '"Assertion failed"
                 '(not (equal? (csv-separator) (csv-quote)))))
      (if (boolean? (std/text/csv#csv-unquoted-quotequote?))
          '#!void
          (error '"Assertion failed" '(boolean? (csv-unquoted-quotequote?))))
      (if (boolean? (std/text/csv#csv-loose-quote?))
          '#!void
          (error '"Assertion failed" '(boolean? (csv-loose-quote?))))
      (if (boolean? (std/text/csv#csv-skip-whitespace?))
          '#!void
          (error '"Assertion failed" '(boolean? (csv-skip-whitespace?))))
      (if (std/text/csv#valid-eol? (std/text/csv#csv-eol))
          '#!void
          (error '"Assertion failed" '(valid-eol? (csv-eol))))
      (if (not (member (string-ref (std/text/csv#csv-eol) '0)
                       (cons (std/text/csv#csv-separator)
                             (cons (std/text/csv#csv-quote) '()))))
          '#!void
          (error '"Assertion failed"
                 '(not (member (string-ref (csv-eol) 0)
                               [(csv-separator) (csv-quote)]))))
      (if (and (list? (std/text/csv#csv-line-endings))
               (std/srfi/1#every
                std/text/csv#valid-eol?
                (std/text/csv#csv-line-endings)))
          '#!void
          (error '"Assertion failed"
                 '(and (list? (csv-line-endings))
                       (every valid-eol? (csv-line-endings)))))))
  (define std/text/csv#csv-eol-matrix (make-parameter '#(#t #t #t)))
  (define std/text/csv#csv-eol-matrix<-line-endings
    (lambda (_line-endings693_)
      (letrec ((_?695_ (lambda (_x697_)
                         (if (member _x697_ _line-endings693_) '#t '#f))))
        (vector (_?695_ std/misc/string#+cr+)
                (_?695_ std/misc/string#+lf+)
                (_?695_ std/misc/string#+crlf+)))))
  (define std/text/csv#char-csv-space?
    (lambda (_c688_)
      (if (or (eqv? _c688_ '#\space) (eqv? _c688_ '#\tab))
          (not (eqv? _c688_ (std/text/csv#csv-separator)))
          '#f)))
  (define std/text/csv#char-ascii-text?
    (lambda (_c678_)
      (let* ((_i680_ (char->integer _c678_)) (_$e682_ (<= '32 _i680_ '126)))
        (if _$e682_
            _$e682_
            (let ((_$e685_ (= _i680_ '10)))
              (if _$e685_ _$e685_ (= _i680_ '13)))))))
  (define std/text/csv#accept
    (lambda (_pred675_ _port676_)
      (if (_pred675_ (peek-char _port676_)) (read-char _port676_) '#f)))
  (define std/text/csv#accept-char
    (lambda (_c668_ _port669_)
      (std/text/csv#accept
       (lambda (_g670672_) (eqv? _c668_ _g670672_))
       _port669_)))
  (define std/text/csv#accept-eof
    (lambda (_port666_) (std/text/csv#accept eof-object? _port666_)))
  (define std/text/csv#accept-eol
    (lambda (_port616_)
      (let* ((_g617625_ (std/text/csv#csv-eol-matrix))
             (_E619629_ (lambda () (error '"No clause matching" _g617625_)))
             (_K620648_
              (lambda (_crlf?632_ _cr?633_ _lf?634_)
                (let ((_$e636_ (if _lf?634_
                                   (if (std/text/csv#accept-char
                                        '#\newline
                                        _port616_)
                                       '#t
                                       '#f)
                                   '#f)))
                  (if _$e636_
                      _$e636_
                      (if (or _cr?633_ _crlf?632_)
                          (if (std/text/csv#accept-char '#\return _port616_)
                              (let ((_$e642_ (if _crlf?632_
                                                 (std/text/csv#accept-char
                                                  '#\newline
                                                  _port616_)
                                                 '#f)))
                                (if _$e642_
                                    _$e642_
                                    (let ((_$e645_ _cr?633_))
                                      (if _$e645_
                                          _$e645_
                                          (std/error#raise-io-error
                                           'accept-eol
                                           '"Carriage-Return without Linefeed!")))))
                              '#f)
                          '#f))))))
        (if (let () (declare (not safe)) (##vector? _g617625_))
            (if (let ((__tmp4364
                       (let ()
                         (declare (not safe))
                         (##vector-length _g617625_))))
                  (declare (not safe))
                  (##fx= __tmp4364 '3))
                (let* ((_e621651_
                        (let ()
                          (declare (not safe))
                          (##vector-ref _g617625_ '0)))
                       (_lf?654_ _e621651_)
                       (_e622656_
                        (let ()
                          (declare (not safe))
                          (##vector-ref _g617625_ '1)))
                       (_cr?659_ _e622656_)
                       (_e623661_
                        (let ()
                          (declare (not safe))
                          (##vector-ref _g617625_ '2)))
                       (_crlf?664_ _e623661_))
                  (_K620648_ _crlf?664_ _cr?659_ _lf?654_))
                (_E619629_))
            (_E619629_)))))
  (define std/text/csv#accept-space
    (lambda (_port614_)
      (std/text/csv#accept std/text/csv#char-csv-space? _port614_)))
  (define std/text/csv#accept-spaces
    (lambda (_port605_)
      (std/misc/list#call-with-list-builder
       (lambda (_c607_ _g4365_)
         (let _loop609_ ()
           (let ((_x612_ (std/text/csv#accept-space _port605_)))
             (if _x612_ (begin (_c607_ _x612_) (_loop609_)) '#!void)))))))
  (define std/text/csv#accept-quote
    (lambda (_port599_)
      (std/text/csv#accept
       (lambda (_g600602_) (eqv? _g600602_ (std/text/csv#csv-quote)))
       _port599_)))
  (define std/text/csv#accept-separator
    (lambda (_port593_)
      (std/text/csv#accept
       (lambda (_g594596_) (eqv? _g594596_ (std/text/csv#csv-separator)))
       _port593_)))
  (define std/text/csv#read-csv-line
    (lambda (_port544_)
      (letrec* ((_ss546_ (open-output-string))
                (_fields547_ '())
                (_had-quotes?548_ '#f)
                (_do-fields549_
                 (lambda ()
                   (set! _had-quotes?548_ '#f)
                   (if (std/text/csv#csv-skip-whitespace?)
                       (std/text/csv#accept-spaces _port544_)
                       '#!void)
                   (if (and (null? _fields547_)
                            (or (std/text/csv#accept-eol _port544_)
                                (std/text/csv#accept-eof _port544_)))
                       (_done559_)
                       (_do-field-start550_))))
                (_do-field-start550_
                 (lambda ()
                   (if (std/text/csv#accept-separator _port544_)
                       (begin (_add556_ '"") (_do-fields549_))
                       (if (std/text/csv#accept-quote _port544_)
                           (if (and (std/text/csv#csv-unquoted-quotequote?)
                                    (std/text/csv#accept-quote _port544_))
                               (begin
                                 (_add-char557_ (std/text/csv#csv-quote))
                                 (_do-field-unquoted553_))
                               (_do-field-quoted551_))
                           (_do-field-unquoted553_)))))
                (_do-field-quoted551_
                 (lambda ()
                   (set! _had-quotes?548_ '#t)
                   (if (std/text/csv#accept-eof _port544_)
                       (std/error#raise-io-error
                        'read-csv-line
                        '"unexpected eof in quotes")
                       (if (std/text/csv#accept-quote _port544_)
                           (if (std/text/csv#accept-quote _port544_)
                               (_quoted-field-char552_
                                (std/text/csv#csv-quote))
                               (if (std/text/csv#csv-loose-quote?)
                                   (_do-field-unquoted553_)
                                   (begin
                                     (_add556_ (_current-string558_))
                                     (_end-of-field555_))))
                           (_quoted-field-char552_ (read-char _port544_))))))
                (_quoted-field-char552_
                 (lambda (_c585_)
                   (_add-char557_ _c585_)
                   (_do-field-quoted551_)))
                (_do-field-unquoted553_
                 (lambda ()
                   (if (std/text/csv#csv-skip-whitespace?)
                       (let ((_spaces580_
                              (std/text/csv#accept-spaces _port544_)))
                         (if (std/text/csv#accept-separator _port544_)
                             (begin
                               (_add556_ (_current-string558_))
                               (_do-fields549_))
                             (if (or (std/text/csv#accept-eol _port544_)
                                     (std/text/csv#accept-eof _port544_))
                                 (begin
                                   (_add556_ (_current-string558_))
                                   (_done559_))
                                 (begin
                                   (for-each _add-char557_ _spaces580_)
                                   (_do-field-unquoted-no-skip554_)))))
                       (_do-field-unquoted-no-skip554_))))
                (_do-field-unquoted-no-skip554_
                 (lambda ()
                   (if (std/text/csv#accept-separator _port544_)
                       (begin
                         (_add556_ (_current-string558_))
                         (_do-fields549_))
                       (if (or (std/text/csv#accept-eol _port544_)
                               (std/text/csv#accept-eof _port544_))
                           (begin (_add556_ (_current-string558_)) (_done559_))
                           (if (std/text/csv#accept-quote _port544_)
                               (if (and (std/text/csv#csv-unquoted-quotequote?)
                                        (std/text/csv#accept-quote _port544_))
                                   (begin
                                     (_add-char557_ (std/text/csv#csv-quote))
                                     (_do-field-unquoted553_))
                                   (if (std/text/csv#csv-loose-quote?)
                                       (_do-field-quoted551_)
                                       (std/error#raise-io-error
                                        'read-csv-line
                                        '"unexpected quote in middle of field")))
                               (begin
                                 (_add-char557_ (read-char _port544_))
                                 (_do-field-unquoted553_)))))))
                (_end-of-field555_
                 (lambda ()
                   (if (std/text/csv#csv-skip-whitespace?)
                       (std/text/csv#accept-spaces _port544_)
                       '#!void)
                   (if (or (std/text/csv#accept-eol _port544_)
                           (std/text/csv#accept-eof _port544_))
                       (_done559_)
                       (if (std/text/csv#accept-separator _port544_)
                           (_do-fields549_)
                           (std/error#raise-io-error
                            'read-csv-line
                            '"end of field expected")))))
                (_add556_
                 (lambda (_x569_)
                   (set! _fields547_ (cons _x569_ _fields547_))))
                (_add-char557_
                 (lambda (_c564_)
                   (if (or (std/text/csv#csv-allow-binary?)
                           (std/text/csv#char-ascii-text? _c564_))
                       '#!void
                       (std/error#raise-io-error
                        'read-csv-line
                        '"binary data not allowed"
                        _c564_))
                   (write-char _c564_ _ss546_)))
                (_current-string558_ (lambda () (get-output-string _ss546_)))
                (_done559_ (lambda () (std/srfi/1#reverse! _fields547_))))
        (call-with-parameters
         (lambda () (_do-fields549_))
         std/text/csv#csv-eol-matrix
         (std/text/csv#csv-eol-matrix<-line-endings
          (std/text/csv#csv-line-endings))))))
  (define std/text/csv#read-csv-lines
    (lambda (_port536_)
      (std/text/csv#validate-csv-parameters)
      (std/misc/list#call-with-list-builder
       (lambda (_c538_ _g4366_)
         (let _lp540_ ()
           (if (std/text/csv#accept-eof _port536_)
               '#!void
               (begin
                 (_c538_ (std/text/csv#read-csv-line _port536_))
                 (_lp540_))))))))
  (define std/text/csv#read-csv-file
    (lambda (_path533_ . _settings534_)
      (call-with-input-file
       (cons 'path: (cons _path533_ _settings534_))
       std/text/csv#read-csv-lines)))
  (define std/text/csv#char-needs-quoting?
    (lambda (_x519_)
      (let ((_$e521_ (eqv? _x519_ (std/text/csv#csv-quote))))
        (if _$e521_
            _$e521_
            (let ((_$e524_ (eqv? _x519_ (std/text/csv#csv-separator))))
              (if _$e524_
                  _$e524_
                  (let ((_$e527_ (eqv? _x519_ '#\newline)))
                    (if _$e527_
                        _$e527_
                        (let ((_$e530_ (eqv? _x519_ '#\return)))
                          (if _$e530_
                              _$e530_
                              (not (std/text/csv#char-ascii-text?
                                    _x519_))))))))))))
  (define std/text/csv#string-needs-quoting?
    (lambda (_x511_)
      (if (not (std/srfi/13#string-null? _x511_))
          (if (or (std/text/csv#char-csv-space? (string-ref _x511_ '0))
                  (std/text/csv#char-csv-space?
                   (string-ref _x511_ (- (string-length _x511_) '1)))
                  (std/srfi/13#string-any__0
                   std/text/csv#char-needs-quoting?
                   _x511_))
              '#t
              '#f)
          '#f)))
  (define std/text/csv#write-csv-lines
    (lambda (_lines504_ _port505_)
      (for-each
       (lambda (_g506508_) (std/text/csv#write-csv-line _g506508_ _port505_))
       _lines504_)))
  (define std/text/csv#write-csv-line
    (lambda (_fields459_ _port460_)
      (let _loop462_ ((_fields464_ _fields459_))
        (let* ((_fields465474_ _fields464_)
               (_E468478_
                (lambda () (error '"No clause matching" _fields465474_))))
          (let ((_K470492_
                 (lambda (_rest489_ _first490_)
                   (std/text/csv#write-csv-field _first490_ _port460_)
                   (if (null? _rest489_)
                       '#!void
                       (write-char (std/text/csv#csv-separator) _port460_))
                   (_loop462_ _rest489_)))
                (_K469483_
                 (lambda () (display (std/text/csv#csv-eol) _port460_))))
            (let ((_try-match467486_
                   (lambda ()
                     (if (let () (declare (not safe)) (##null? _fields465474_))
                         (_K469483_)
                         (_E468478_)))))
              (if (let () (declare (not safe)) (##pair? _fields465474_))
                  (let ((_tl472497_
                         (let () (declare (not safe)) (##cdr _fields465474_)))
                        (_hd471495_
                         (let () (declare (not safe)) (##car _fields465474_))))
                    (let ((_first500_ _hd471495_) (_rest502_ _tl472497_))
                      (_K470492_ _rest502_ _first500_)))
                  (_try-match467486_))))))))
  (define std/text/csv#write-csv-field
    (lambda (_field406_ _port407_)
      (let* ((_field408420_ _field406_)
             (_else413428_
              (lambda () (error '"invalid CSV field" _field406_))))
        (let ((_K418456_ (lambda () '#!void))
              (_K417449_ (lambda () (display _field406_ _port407_)))
              (_K416441_
               (lambda ()
                 (std/text/csv#write-csv-string-safely _field406_ _port407_)))
              (_K415433_
               (lambda ()
                 (std/text/csv#write-csv-string-safely
                  (symbol->string _field406_)
                  _port407_))))
          (let* ((_try-match412436_
                  (lambda ()
                    (if (symbol? _field408420_) (_K415433_) (_else413428_))))
                 (_try-match411444_
                  (lambda ()
                    (if (string? _field408420_)
                        (_K416441_)
                        (_try-match412436_))))
                 (_try-match410452_
                  (lambda ()
                    (if (number? _field408420_)
                        (_K417449_)
                        (_try-match411444_)))))
            (if (not _field408420_) '#!void (_try-match410452_)))))))
  (define std/text/csv#write-csv-string-safely
    (lambda (_string403_ _port404_)
      (if (std/text/csv#string-needs-quoting? _string403_)
          (std/text/csv#write-quoted-string _string403_ _port404_)
          (display _string403_ _port404_))))
  (define std/text/csv#write-quoted-string
    (lambda (_string398_ _port399_)
      (write-char (std/text/csv#csv-quote) _port399_)
      (std/srfi/13#string-for-each__0
       (lambda (_c401_)
         (if (char=? _c401_ (std/text/csv#csv-quote))
             (write-char _c401_ _port399_)
             '#!void)
         (write-char _c401_ _port399_))
       _string398_)
      (write-char (std/text/csv#csv-quote) _port399_))))
