(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/crypto/hmac#hmac::t
    (make-struct-type 'std/crypto#hmac::t '#f '2 'hmac '() ':init! '(md ctx)))
  (define std/crypto/hmac#hmac?
    (make-struct-predicate std/crypto/hmac#hmac::t))
  (define std/crypto/hmac#make-hmac
    (lambda _$args883_
      (apply make-struct-instance std/crypto/hmac#hmac::t _$args883_)))
  (define std/crypto/hmac#hmac-md
    (make-struct-field-accessor std/crypto/hmac#hmac::t '0))
  (define std/crypto/hmac#hmac-ctx
    (make-struct-field-accessor std/crypto/hmac#hmac::t '1))
  (define std/crypto/hmac#hmac-md-set!
    (make-struct-field-mutator std/crypto/hmac#hmac::t '0))
  (define std/crypto/hmac#hmac-ctx-set!
    (make-struct-field-mutator std/crypto/hmac#hmac::t '1))
  (define std/crypto/hmac#hmac:::init!
    (lambda (_self878_ _md879_)
      (if (std/crypto/libcrypto#EVP_MD? _md879_)
          '#!void
          (error '"Invalid digest type" _md879_))
      (let ((_ctx881_ (std/crypto/libcrypto#HMAC_CTX_create)))
        (if _ctx881_ '#!void (error '"Failed to allocate hmac context"))
        (if (let ((__tmp4540
                   (let () (declare (not safe)) (##vector-length _self878_))))
              (declare (not safe))
              (##fx< '2 __tmp4540))
            (begin
              (let ()
                (declare (not safe))
                (##vector-set! _self878_ '1 _md879_))
              (let ()
                (declare (not safe))
                (##vector-set! _self878_ '2 _ctx881_)))
            (error '"struct-instance-init!: too many arguments for struct"
                   _self878_)))))
  (bind-method!
   std/crypto/hmac#hmac::t
   ':init!
   std/crypto/hmac#hmac:::init!
   '#f)
  (define std/crypto/hmac#hmac-init!
    (lambda (_hmac750_ _key751_)
      (let ((_res753_
             (std/crypto/libcrypto#HMAC_Init
              (##structure-ref _hmac750_ '2 std/crypto/hmac#hmac::t '#f)
              _key751_
              (##structure-ref _hmac750_ '1 std/crypto/hmac#hmac::t '#f))))
        (if (let () (declare (not safe)) (##fxzero? _res753_))
            (apply std/crypto/etc#raise-libcrypto-error '())
            '#!void))))
  (define std/crypto/hmac#hmac-update!__%
    (lambda (_hmac710_ _bytes711_ _start712_ _end713_)
      (let* ((_start718_ (let ((_$e715_ _start712_)) (if _$e715_ _$e715_ '0)))
             (_end723_
              (let ((_$e720_ _end713_))
                (if _$e720_ _$e720_ (u8vector-length _bytes711_)))))
        (let ((_res726_
               (std/crypto/libcrypto#HMAC_Update
                (##structure-ref _hmac710_ '2 std/crypto/hmac#hmac::t '#f)
                _bytes711_
                _start718_
                _end723_)))
          (if (let () (declare (not safe)) (##fxzero? _res726_))
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void)))))
  (define std/crypto/hmac#hmac-update!__0
    (lambda (_hmac732_ _bytes733_)
      (let* ((_start735_ '#f) (_end737_ '#f))
        (std/crypto/hmac#hmac-update!__%
         _hmac732_
         _bytes733_
         _start735_
         _end737_))))
  (define std/crypto/hmac#hmac-update!__1
    (lambda (_hmac739_ _bytes740_ _start741_)
      (let ((_end743_ '#f))
        (std/crypto/hmac#hmac-update!__%
         _hmac739_
         _bytes740_
         _start741_
         _end743_))))
  (define std/crypto/hmac#hmac-update!
    (lambda _g4542_
      (let ((_g4541_ (let () (declare (not safe)) (##length _g4542_))))
        (cond ((let () (declare (not safe)) (##fx= _g4541_ 2))
               (apply std/crypto/hmac#hmac-update!__0 _g4542_))
              ((let () (declare (not safe)) (##fx= _g4541_ 3))
               (apply std/crypto/hmac#hmac-update!__1 _g4542_))
              ((let () (declare (not safe)) (##fx= _g4541_ 4))
               (apply std/crypto/hmac#hmac-update!__% _g4542_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-update!
                _g4542_))))))
  (define std/crypto/hmac#hmac-final!__%
    (lambda (_hmac685_ _bytes686_)
      (let* ((_size688_
              (std/crypto/libcrypto#EVP_MD_size
               (##structure-ref _hmac685_ '1 std/crypto/hmac#hmac::t '#f)))
             (_bytes693_
              (let ((_$e690_ _bytes686_))
                (if _$e690_ _$e690_ (make-u8vector _size688_)))))
        (let ((_res696_
               (std/crypto/libcrypto#HMAC_Final
                (##structure-ref _hmac685_ '2 std/crypto/hmac#hmac::t '#f)
                _bytes693_)))
          (if (let () (declare (not safe)) (##fxzero? _res696_))
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void))
        _bytes693_)))
  (define std/crypto/hmac#hmac-final!__0
    (lambda (_hmac702_)
      (let ((_bytes704_ '#f))
        (std/crypto/hmac#hmac-final!__% _hmac702_ _bytes704_))))
  (define std/crypto/hmac#hmac-final!
    (lambda _g4544_
      (let ((_g4543_ (let () (declare (not safe)) (##length _g4544_))))
        (cond ((let () (declare (not safe)) (##fx= _g4543_ 1))
               (apply std/crypto/hmac#hmac-final!__0 _g4544_))
              ((let () (declare (not safe)) (##fx= _g4543_ 2))
               (apply std/crypto/hmac#hmac-final!__% _g4544_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-final!
                _g4544_))))))
  (define std/crypto/hmac#hmac-digest__%
    (lambda (_md639_ _key640_ _bytes641_ _start642_ _end643_)
      (if (std/crypto/libcrypto#EVP_MD? _md639_)
          '#!void
          (error '"Bad digest type" _md639_))
      (let* ((_start648_ (let ((_$e645_ _start642_)) (if _$e645_ _$e645_ '0)))
             (_end653_
              (let ((_$e650_ _end643_))
                (if _$e650_ _$e650_ (u8vector-length _bytes641_))))
             (_size655_ (std/crypto/libcrypto#EVP_MD_size _md639_))
             (_digest657_ (make-u8vector _size655_)))
        (std/crypto/libcrypto#HMAC
         _md639_
         _key640_
         _bytes641_
         _start648_
         _end653_
         _digest657_)
        _digest657_)))
  (define std/crypto/hmac#hmac-digest__0
    (lambda (_md663_ _key664_ _bytes665_)
      (let* ((_start667_ '#f) (_end669_ '#f))
        (std/crypto/hmac#hmac-digest__%
         _md663_
         _key664_
         _bytes665_
         _start667_
         _end669_))))
  (define std/crypto/hmac#hmac-digest__1
    (lambda (_md671_ _key672_ _bytes673_ _start674_)
      (let ((_end676_ '#f))
        (std/crypto/hmac#hmac-digest__%
         _md671_
         _key672_
         _bytes673_
         _start674_
         _end676_))))
  (define std/crypto/hmac#hmac-digest
    (lambda _g4546_
      (let ((_g4545_ (let () (declare (not safe)) (##length _g4546_))))
        (cond ((let () (declare (not safe)) (##fx= _g4545_ 3))
               (apply std/crypto/hmac#hmac-digest__0 _g4546_))
              ((let () (declare (not safe)) (##fx= _g4545_ 4))
               (apply std/crypto/hmac#hmac-digest__1 _g4546_))
              ((let () (declare (not safe)) (##fx= _g4545_ 5))
               (apply std/crypto/hmac#hmac-digest__% _g4546_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-digest
                _g4546_))))))
  (define std/crypto/hmac#hmac-md5__%
    (lambda (_key608_ _bytes610_ _start612_ _end614_)
      (std/crypto/hmac#hmac-digest__%
       std/crypto/digest#digest::md5
       _key608_
       _bytes610_
       _start612_
       _end614_)))
  (define std/crypto/hmac#hmac-md5__0
    (lambda (_key620_ _bytes621_)
      (let* ((_start623_ '#f) (_end625_ '#f))
        (std/crypto/hmac#hmac-md5__%
         _key620_
         _bytes621_
         _start623_
         _end625_))))
  (define std/crypto/hmac#hmac-md5__1
    (lambda (_key627_ _bytes628_ _start629_)
      (let ((_end631_ '#f))
        (std/crypto/hmac#hmac-md5__%
         _key627_
         _bytes628_
         _start629_
         _end631_))))
  (define std/crypto/hmac#hmac-md5
    (lambda _g4548_
      (let ((_g4547_ (let () (declare (not safe)) (##length _g4548_))))
        (cond ((let () (declare (not safe)) (##fx= _g4547_ 2))
               (apply std/crypto/hmac#hmac-md5__0 _g4548_))
              ((let () (declare (not safe)) (##fx= _g4547_ 3))
               (apply std/crypto/hmac#hmac-md5__1 _g4548_))
              ((let () (declare (not safe)) (##fx= _g4547_ 4))
               (apply std/crypto/hmac#hmac-md5__% _g4548_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-md5
                _g4548_))))))
  (define std/crypto/hmac#hmac-sha1__%
    (lambda (_key577_ _bytes579_ _start581_ _end583_)
      (std/crypto/hmac#hmac-digest__%
       std/crypto/digest#digest::sha1
       _key577_
       _bytes579_
       _start581_
       _end583_)))
  (define std/crypto/hmac#hmac-sha1__0
    (lambda (_key589_ _bytes590_)
      (let* ((_start592_ '#f) (_end594_ '#f))
        (std/crypto/hmac#hmac-sha1__%
         _key589_
         _bytes590_
         _start592_
         _end594_))))
  (define std/crypto/hmac#hmac-sha1__1
    (lambda (_key596_ _bytes597_ _start598_)
      (let ((_end600_ '#f))
        (std/crypto/hmac#hmac-sha1__%
         _key596_
         _bytes597_
         _start598_
         _end600_))))
  (define std/crypto/hmac#hmac-sha1
    (lambda _g4550_
      (let ((_g4549_ (let () (declare (not safe)) (##length _g4550_))))
        (cond ((let () (declare (not safe)) (##fx= _g4549_ 2))
               (apply std/crypto/hmac#hmac-sha1__0 _g4550_))
              ((let () (declare (not safe)) (##fx= _g4549_ 3))
               (apply std/crypto/hmac#hmac-sha1__1 _g4550_))
              ((let () (declare (not safe)) (##fx= _g4549_ 4))
               (apply std/crypto/hmac#hmac-sha1__% _g4550_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-sha1
                _g4550_))))))
  (define std/crypto/hmac#hmac-sha256__%
    (lambda (_key546_ _bytes548_ _start550_ _end552_)
      (std/crypto/hmac#hmac-digest__%
       std/crypto/digest#digest::sha256
       _key546_
       _bytes548_
       _start550_
       _end552_)))
  (define std/crypto/hmac#hmac-sha256__0
    (lambda (_key558_ _bytes559_)
      (let* ((_start561_ '#f) (_end563_ '#f))
        (std/crypto/hmac#hmac-sha256__%
         _key558_
         _bytes559_
         _start561_
         _end563_))))
  (define std/crypto/hmac#hmac-sha256__1
    (lambda (_key565_ _bytes566_ _start567_)
      (let ((_end569_ '#f))
        (std/crypto/hmac#hmac-sha256__%
         _key565_
         _bytes566_
         _start567_
         _end569_))))
  (define std/crypto/hmac#hmac-sha256
    (lambda _g4552_
      (let ((_g4551_ (let () (declare (not safe)) (##length _g4552_))))
        (cond ((let () (declare (not safe)) (##fx= _g4551_ 2))
               (apply std/crypto/hmac#hmac-sha256__0 _g4552_))
              ((let () (declare (not safe)) (##fx= _g4551_ 3))
               (apply std/crypto/hmac#hmac-sha256__1 _g4552_))
              ((let () (declare (not safe)) (##fx= _g4551_ 4))
               (apply std/crypto/hmac#hmac-sha256__% _g4552_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-sha256
                _g4552_))))))
  (define std/crypto/hmac#hmac-sha384__%
    (lambda (_key515_ _bytes517_ _start519_ _end521_)
      (std/crypto/hmac#hmac-digest__%
       std/crypto/digest#digest::sha384
       _key515_
       _bytes517_
       _start519_
       _end521_)))
  (define std/crypto/hmac#hmac-sha384__0
    (lambda (_key527_ _bytes528_)
      (let* ((_start530_ '#f) (_end532_ '#f))
        (std/crypto/hmac#hmac-sha384__%
         _key527_
         _bytes528_
         _start530_
         _end532_))))
  (define std/crypto/hmac#hmac-sha384__1
    (lambda (_key534_ _bytes535_ _start536_)
      (let ((_end538_ '#f))
        (std/crypto/hmac#hmac-sha384__%
         _key534_
         _bytes535_
         _start536_
         _end538_))))
  (define std/crypto/hmac#hmac-sha384
    (lambda _g4554_
      (let ((_g4553_ (let () (declare (not safe)) (##length _g4554_))))
        (cond ((let () (declare (not safe)) (##fx= _g4553_ 2))
               (apply std/crypto/hmac#hmac-sha384__0 _g4554_))
              ((let () (declare (not safe)) (##fx= _g4553_ 3))
               (apply std/crypto/hmac#hmac-sha384__1 _g4554_))
              ((let () (declare (not safe)) (##fx= _g4553_ 4))
               (apply std/crypto/hmac#hmac-sha384__% _g4554_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-sha384
                _g4554_))))))
  (define std/crypto/hmac#hmac-sha512__%
    (lambda (_key484_ _bytes486_ _start488_ _end490_)
      (std/crypto/hmac#hmac-digest__%
       std/crypto/digest#digest::sha512
       _key484_
       _bytes486_
       _start488_
       _end490_)))
  (define std/crypto/hmac#hmac-sha512__0
    (lambda (_key496_ _bytes497_)
      (let* ((_start499_ '#f) (_end501_ '#f))
        (std/crypto/hmac#hmac-sha512__%
         _key496_
         _bytes497_
         _start499_
         _end501_))))
  (define std/crypto/hmac#hmac-sha512__1
    (lambda (_key503_ _bytes504_ _start505_)
      (let ((_end507_ '#f))
        (std/crypto/hmac#hmac-sha512__%
         _key503_
         _bytes504_
         _start505_
         _end507_))))
  (define std/crypto/hmac#hmac-sha512
    (lambda _g4556_
      (let ((_g4555_ (let () (declare (not safe)) (##length _g4556_))))
        (cond ((let () (declare (not safe)) (##fx= _g4555_ 2))
               (apply std/crypto/hmac#hmac-sha512__0 _g4556_))
              ((let () (declare (not safe)) (##fx= _g4555_ 3))
               (apply std/crypto/hmac#hmac-sha512__1 _g4556_))
              ((let () (declare (not safe)) (##fx= _g4555_ 4))
               (apply std/crypto/hmac#hmac-sha512__% _g4556_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-sha512
                _g4556_)))))))
