(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/text/zlib#compress__%
    (lambda (_data710_ _level711_)
      (if (u8vector? _data710_)
          (std/text/zlib#compress-bytes _data710_ _level711_)
          (if (string? _data710_)
              (std/text/zlib#compress-bytes
               (std/text/utf8#string->utf8__0 _data710_)
               _level711_)
              (if (input-port? _data710_)
                  (std/text/zlib#compress-port _data710_ _level711_)
                  (error '"Bad input source" _data710_))))))
  (define std/text/zlib#compress__0
    (lambda (_data716_)
      (let ((_level718_ std/text/_zlib#Z_DEFAULT_COMPRESSION))
        (std/text/zlib#compress__% _data716_ _level718_))))
  (define std/text/zlib#compress
    (lambda _g4359_
      (let ((_g4358_ (let () (declare (not safe)) (##length _g4359_))))
        (cond ((let () (declare (not safe)) (##fx= _g4358_ 1))
               (apply std/text/zlib#compress__0 _g4359_))
              ((let () (declare (not safe)) (##fx= _g4358_ 2))
               (apply std/text/zlib#compress__% _g4359_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/zlib#compress
                _g4359_))))))
  (define std/text/zlib#compress-bytes
    (lambda (_data701_ _level702_)
      (let* ((_buf704_
              (make-u8vector
               (std/text/_zlib#compressBound (u8vector-length _data701_))))
             (_res706_
              (std/text/_zlib#compress2 _buf704_ _data701_ _level702_)))
        (if (let () (declare (not safe)) (##fxnegative? _res706_))
            (std/error#raise-io-error 'compress '"zlib error" _res706_)
            (begin (u8vector-shrink! _buf704_ _res706_) _buf704_)))))
  (define std/text/zlib#compress-port
    (lambda (_inp698_ _level699_)
      (std/text/zlib#deflate-port
       _inp698_
       _level699_
       std/text/_zlib#deflateInit)))
  (define std/text/zlib#compress-gz__%
    (lambda (_data685_ _level686_)
      (if (u8vector? _data685_)
          (std/text/zlib#compress-gz-bytes _data685_ _level686_)
          (if (string? _data685_)
              (std/text/zlib#compress-gz-bytes
               (std/text/utf8#string->utf8__0 _data685_)
               _level686_)
              (if (input-port? _data685_)
                  (std/text/zlib#compress-gz-port _data685_ _level686_)
                  (error '"Bad input source" _data685_))))))
  (define std/text/zlib#compress-gz__0
    (lambda (_data691_)
      (let ((_level693_ std/text/_zlib#Z_DEFAULT_COMPRESSION))
        (std/text/zlib#compress-gz__% _data691_ _level693_))))
  (define std/text/zlib#compress-gz
    (lambda _g4361_
      (let ((_g4360_ (let () (declare (not safe)) (##length _g4361_))))
        (cond ((let () (declare (not safe)) (##fx= _g4360_ 1))
               (apply std/text/zlib#compress-gz__0 _g4361_))
              ((let () (declare (not safe)) (##fx= _g4360_ 2))
               (apply std/text/zlib#compress-gz__% _g4361_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/zlib#compress-gz
                _g4361_))))))
  (define std/text/zlib#compress-gz-bytes
    (lambda (_data673_ _level674_)
      (let* ((_zs676_ (std/text/_zlib#make_z_stream))
             (_res678_ (std/text/_zlib#deflateInit_gz _zs676_ _level674_)))
        (if (eq? _res678_ std/text/_zlib#Z_OK)
            '#!void
            (std/error#raise-io-error
             'compress
             '"zlib stream initialization error"
             _res678_))
        (with-unwind-protect
         (lambda () (std/text/zlib#compress-gz-data _zs676_ _data673_))
         (lambda () (std/text/_zlib#deflateEnd _zs676_))))))
  (define std/text/zlib#compress-gz-data
    (lambda (_zs665_ _data666_)
      (let* ((_buf668_
              (make-u8vector
               (std/text/_zlib#deflateBound
                _zs665_
                (u8vector-length _data666_))))
             (_res670_
              (std/text/_zlib#deflate
               _zs665_
               _buf668_
               _data666_
               '0
               std/text/_zlib#Z_FINISH)))
        (if (eq? _res670_ std/text/_zlib#Z_STREAM_END)
            '#!void
            (std/error#raise-io-error
             'compress-gz
             '"incomplete deflate"
             (std/text/_zlib#z_stream_msg _zs665_)
             _res670_))
        (u8vector-shrink! _buf668_ (std/text/_zlib#z_stream_total_out _zs665_))
        _buf668_)))
  (define std/text/zlib#compress-gz-port
    (lambda (_inp662_ _level663_)
      (std/text/zlib#deflate-port
       _inp662_
       _level663_
       std/text/_zlib#deflateInit_gz)))
  (define std/text/zlib#deflate-port
    (lambda (_inp650_ _level651_ _init-e652_)
      (let* ((_zs654_ (std/text/_zlib#make_z_stream))
             (_res656_ (_init-e652_ _zs654_ _level651_)))
        (if (eq? _res656_ std/text/_zlib#Z_OK)
            '#!void
            (std/error#raise-io-error
             'compress
             '"zlib stream initialization error"
             _res656_))
        (with-unwind-protect
         (lambda () (std/text/zlib#do-deflate-port _zs654_ _inp650_))
         (lambda () (std/text/_zlib#deflateEnd _zs654_))))))
  (define std/text/zlib#do-deflate-port
    (lambda (_zs608_ _inp609_)
      (letrec* ((_buflen611_ '1024)
                (_fini612_
                 (lambda (_r648_) (append-u8vectors (reverse _r648_))))
                (_deflate-next613_
                 (lambda (_ibuf625_ _r626_ _flush627_)
                   (let _lp629_ ((_obuf631_ (make-u8vector _buflen611_))
                                 (_start632_ '0)
                                 (_r633_ _r626_))
                     (let* ((_icount635_
                             (std/text/_zlib#z_stream_total_in _zs608_))
                            (_ocount637_
                             (std/text/_zlib#z_stream_total_out _zs608_))
                            (_res639_
                             (std/text/_zlib#deflate
                              _zs608_
                              _obuf631_
                              _ibuf625_
                              _start632_
                              _flush627_))
                            (_ocount641_
                             (let ((__tmp4362
                                    (std/text/_zlib#z_stream_total_out
                                     _zs608_)))
                               (declare (not safe))
                               (##fx- __tmp4362 _ocount637_))))
                       (if (eq? _res639_ std/text/_zlib#Z_OK)
                           (let ((_acount644_
                                  (std/text/_zlib#z_stream_avail_out _zs608_)))
                             (if (let ()
                                   (declare (not safe))
                                   (##fxzero? _acount644_))
                                 (let ((_icount646_
                                        (let ((__tmp4363
                                               (std/text/_zlib#z_stream_total_in
                                                _zs608_)))
                                          (declare (not safe))
                                          (##fx- __tmp4363 _icount635_))))
                                   (u8vector-shrink! _obuf631_ _ocount641_)
                                   (_lp629_ (make-u8vector _buflen611_)
                                            (let ()
                                              (declare (not safe))
                                              (##fx+ _start632_ _icount646_))
                                            (cons _obuf631_ _r633_)))
                                 (if (let ()
                                       (declare (not safe))
                                       (##fx> _ocount641_ '0))
                                     (begin
                                       (u8vector-shrink! _obuf631_ _ocount641_)
                                       (cons _obuf631_ _r633_))
                                     _r633_)))
                           (if (eq? _res639_ std/text/_zlib#Z_STREAM_END)
                               (if (let ()
                                     (declare (not safe))
                                     (##fx> _ocount641_ '0))
                                   (begin
                                     (u8vector-shrink! _obuf631_ _ocount641_)
                                     (cons _obuf631_ _r633_))
                                   _r633_)
                               (std/error#raise-io-error
                                'deflate-port
                                '"deflate: zlib error"
                                (std/text/_zlib#z_stream_msg _zs608_)
                                _res639_))))))))
        (let ((_ibuf615_ (make-u8vector _buflen611_)))
          (let _lp617_ ((_r619_ '()))
            (let ((_rd621_ (read-subu8vector
                            _ibuf615_
                            '0
                            _buflen611_
                            _inp609_)))
              (if (let () (declare (not safe)) (##fxzero? _rd621_))
                  (_fini612_
                   (_deflate-next613_ '#f _r619_ std/text/_zlib#Z_FINISH))
                  (if (let () (declare (not safe)) (##fx< _rd621_ _buflen611_))
                      (begin
                        (u8vector-shrink! _ibuf615_ _rd621_)
                        (_fini612_
                         (_deflate-next613_
                          _ibuf615_
                          _r619_
                          std/text/_zlib#Z_FINISH)))
                      (let ((_r623_ (_deflate-next613_
                                     _ibuf615_
                                     _r619_
                                     std/text/_zlib#Z_NO_FLUSH)))
                        (_lp617_ _r623_))))))))))
  (define std/text/zlib#uncompress
    (lambda (_data606_)
      (if (u8vector? _data606_)
          (std/text/zlib#uncompress-bytes _data606_)
          (if (input-port? _data606_)
              (std/text/zlib#uncompress-port _data606_)
              (error '"Bad input source" _data606_)))))
  (define std/text/zlib#uncompress-bytes
    (lambda (_data604_)
      (std/text/zlib#do-inflate _data604_ std/text/zlib#uncompress-data)))
  (define std/text/zlib#do-inflate
    (lambda (_data593_ _inflate-e594_)
      (let* ((_zs596_ (std/text/_zlib#make_z_stream))
             (_res598_ (std/text/_zlib#inflateInit _zs596_)))
        (if (eq? _res598_ std/text/_zlib#Z_OK)
            '#!void
            (std/error#raise-io-error
             'uncompress
             '"zlib stream initialization error"
             _res598_))
        (with-unwind-protect
         (lambda () (_inflate-e594_ _zs596_ _data593_))
         (lambda () (std/text/_zlib#inflateEnd _zs596_))))))
  (define std/text/zlib#uncompress-data
    (lambda (_zs570_ _data571_)
      (letrec* ((_buflen573_ '1024))
        (let _lp575_ ((_start577_ '0) (_r578_ '()))
          (let* ((_buf580_ (make-u8vector _buflen573_))
                 (_icount582_ (std/text/_zlib#z_stream_total_in _zs570_))
                 (_ocount584_ (std/text/_zlib#z_stream_total_out _zs570_))
                 (_res586_
                  (std/text/_zlib#inflate
                   _zs570_
                   _buf580_
                   _data571_
                   _start577_))
                 (_ocount588_
                  (let ((__tmp4364
                         (std/text/_zlib#z_stream_total_out _zs570_)))
                    (declare (not safe))
                    (##fx- __tmp4364 _ocount584_))))
            (if (eq? _res586_ std/text/_zlib#Z_OK)
                (let ((_icount591_
                       (let ((__tmp4365
                              (std/text/_zlib#z_stream_total_in _zs570_)))
                         (declare (not safe))
                         (##fx- __tmp4365 _icount582_))))
                  (u8vector-shrink! _buf580_ _ocount588_)
                  (_lp575_ (let ()
                             (declare (not safe))
                             (##fx+ _start577_ _icount591_))
                           (cons _buf580_ _r578_)))
                (if (eq? _res586_ std/text/_zlib#Z_STREAM_END)
                    (begin
                      (u8vector-shrink! _buf580_ _ocount588_)
                      (append-u8vectors (reverse (cons _buf580_ _r578_))))
                    (std/error#raise-io-error
                     'uncompress
                     '"zlib error"
                     (std/text/_zlib#z_stream_msg _zs570_)
                     _res586_))))))))
  (define std/text/zlib#uncompress-port
    (lambda (_inp568_)
      (std/text/zlib#do-inflate _inp568_ std/text/zlib#do-inflate-port)))
  (define std/text/zlib#do-inflate-port
    (lambda (_zs528_ _inp529_)
      (letrec* ((_buflen531_ '1024)
                (_fini532_
                 (lambda (_r566_) (append-u8vectors (reverse _r566_))))
                (_inflate-next533_
                 (lambda (_ibuf543_ _r544_)
                   (let _lp546_ ((_obuf548_ (make-u8vector _buflen531_))
                                 (_start549_ '0)
                                 (_r550_ _r544_))
                     (let* ((_icount552_
                             (std/text/_zlib#z_stream_total_in _zs528_))
                            (_ocount554_
                             (std/text/_zlib#z_stream_total_out _zs528_))
                            (_res556_
                             (std/text/_zlib#inflate
                              _zs528_
                              _obuf548_
                              _ibuf543_
                              _start549_))
                            (_ocount558_
                             (let ((__tmp4366
                                    (std/text/_zlib#z_stream_total_out
                                     _zs528_)))
                               (declare (not safe))
                               (##fx- __tmp4366 _ocount554_))))
                       (if (eq? _res556_ std/text/_zlib#Z_OK)
                           (let* ((_icount561_
                                   (let ((__tmp4367
                                          (std/text/_zlib#z_stream_total_in
                                           _zs528_)))
                                     (declare (not safe))
                                     (##fx- __tmp4367 _icount552_)))
                                  (_start563_
                                   (let ()
                                     (declare (not safe))
                                     (##fx+ _start549_ _icount561_))))
                             (u8vector-shrink! _obuf548_ _ocount558_)
                             (if (let ()
                                   (declare (not safe))
                                   (##fx< _start563_ _buflen531_))
                                 (_lp546_ (make-u8vector _buflen531_)
                                          _start563_
                                          (cons _obuf548_ _r550_))
                                 (cons _obuf548_ _r550_)))
                           (if (eq? _res556_ std/text/_zlib#Z_STREAM_END)
                               (begin
                                 (u8vector-shrink! _obuf548_ _ocount558_)
                                 (cons _obuf548_ _r550_))
                               (std/error#raise-io-error
                                'inflate-port
                                '"zlib error"
                                (std/text/_zlib#z_stream_msg _zs528_)
                                _res556_))))))))
        (let ((_ibuf535_ (make-u8vector _buflen531_)))
          (let _lp537_ ((_r539_ '()))
            (let ((_rd541_ (read-subu8vector
                            _ibuf535_
                            '0
                            _buflen531_
                            _inp529_)))
              (if (let () (declare (not safe)) (##fxzero? _rd541_))
                  (_fini532_ _r539_)
                  (if (let () (declare (not safe)) (##fx< _rd541_ _buflen531_))
                      (begin
                        (u8vector-shrink! _ibuf535_ _rd541_)
                        (_fini532_ (_inflate-next533_ _ibuf535_ _r539_)))
                      (_lp537_ (_inflate-next533_ _ibuf535_ _r539_)))))))))))
