(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/uri#uri-unreserved-chars
    '"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~")
  (define std/net/uri#uri-gendelim-chars '":/?#[]@")
  (define std/net/uri#uri-subdelim-chars '"!$&'()*+,;=")
  (define std/net/uri#make-uri-encoding-table__%
    (lambda (_self-chars631_ _sub-chars632_)
      (let ((_vt634_ (make-vector '256 '#f))
            (_len635_ (string-length _self-chars631_)))
        (let _lp637_ ((_n639_ '0))
          (if (let () (declare (not safe)) (##fx< _n639_ _len635_))
              (let ((_char641_
                     (let ()
                       (declare (not safe))
                       (##string-ref _self-chars631_ _n639_))))
                (vector-set! _vt634_ (char->integer _char641_) _char641_)
                (_lp637_ (let () (declare (not safe)) (##fx+ _n639_ '1))))
              '#!void))
        (for-each
         (lambda (_e642644_)
           (let* ((_g646653_ _e642644_)
                  (_E648657_
                   (lambda () (error '"No clause matching" _g646653_)))
                  (_K649663_
                   (lambda (_sub660_ _char661_)
                     (vector-set!
                      _vt634_
                      (char->integer _char661_)
                      _sub660_))))
             (if (let () (declare (not safe)) (##pair? _g646653_))
                 (let ((_hd650666_
                        (let () (declare (not safe)) (##car _g646653_)))
                       (_tl651668_
                        (let () (declare (not safe)) (##cdr _g646653_))))
                   (let* ((_char671_ _hd650666_) (_sub673_ _tl651668_))
                     (_K649663_ _sub673_ _char671_)))
                 (_E648657_))))
         _sub-chars632_)
        _vt634_)))
  (define std/net/uri#make-uri-encoding-table__0
    (lambda (_self-chars678_)
      (let ((_sub-chars680_ '()))
        (std/net/uri#make-uri-encoding-table__%
         _self-chars678_
         _sub-chars680_))))
  (define std/net/uri#make-uri-encoding-table
    (lambda _g4346_
      (let ((_g4345_ (let () (declare (not safe)) (##length _g4346_))))
        (cond ((let () (declare (not safe)) (##fx= _g4345_ 1))
               (apply std/net/uri#make-uri-encoding-table__0 _g4346_))
              ((let () (declare (not safe)) (##fx= _g4345_ 2))
               (apply std/net/uri#make-uri-encoding-table__% _g4346_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/uri#make-uri-encoding-table
                _g4346_))))))
  (define std/net/uri#uri-encoding
    (std/net/uri#make-uri-encoding-table__0 std/net/uri#uri-unreserved-chars))
  (define std/net/uri#uri-space-encoding
    (std/net/uri#make-uri-encoding-table__%
     std/net/uri#uri-unreserved-chars
     '((#\space . #\+))))
  (define std/net/uri#uri-encode__%
    (lambda (_str616_ _vt617_)
      (if (and (vector? _vt617_)
               (let ((__tmp4347 (vector-length _vt617_)))
                 (declare (not safe))
                 (##fx= __tmp4347 '256)))
          '#!void
          (error '"Bad encoding table" _vt617_))
      (with-output-to-string
       '()
       (lambda () (std/net/uri#write-uri-encoded _str616_ _vt617_)))))
  (define std/net/uri#uri-encode__0
    (lambda (_str623_)
      (let ((_vt625_ std/net/uri#uri-encoding))
        (std/net/uri#uri-encode__% _str623_ _vt625_))))
  (define std/net/uri#uri-encode
    (lambda _g4349_
      (let ((_g4348_ (let () (declare (not safe)) (##length _g4349_))))
        (cond ((let () (declare (not safe)) (##fx= _g4348_ 1))
               (apply std/net/uri#uri-encode__0 _g4349_))
              ((let () (declare (not safe)) (##fx= _g4348_ 2))
               (apply std/net/uri#uri-encode__% _g4349_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/uri#uri-encode
                _g4349_))))))
  (define std/net/uri#form-url-encode__%
    (lambda (_fields528_ _+space?529_)
      (letrec* ((_encoding531_
                 (if _+space?529_
                     std/net/uri#uri-space-encoding
                     std/net/uri#uri-encoding))
                (_encode-field532_
                 (lambda (_field575_)
                   (let* ((_field576583_ _field575_)
                          (_E578587_
                           (lambda ()
                             (error '"No clause matching" _field576583_)))
                          (_K579593_
                           (lambda (_val590_ _key591_)
                             (std/net/uri#write-uri-encoded
                              _key591_
                              _encoding531_)
                             (if _val590_
                                 (begin
                                   (write-char '#\=)
                                   (std/net/uri#write-uri-encoded
                                    _val590_
                                    _encoding531_))
                                 '#!void))))
                     (if (let () (declare (not safe)) (##pair? _field576583_))
                         (let ((_hd580596_
                                (let ()
                                  (declare (not safe))
                                  (##car _field576583_)))
                               (_tl581598_
                                (let ()
                                  (declare (not safe))
                                  (##cdr _field576583_))))
                           (let* ((_key601_ _hd580596_) (_val603_ _tl581598_))
                             (_K579593_ _val603_ _key601_)))
                         (_E578587_))))))
        (let* ((_fields533542_ _fields528_)
               (_E536546_
                (lambda () (error '"No clause matching" _fields533542_))))
          (let ((_K538563_
                 (lambda (_rest557_ _first558_)
                   (with-output-to-string
                    '()
                    (lambda ()
                      (_encode-field532_ _first558_)
                      (for-each
                       (lambda (_field561_)
                         (write-char '#\&)
                         (_encode-field532_ _field561_))
                       _rest557_)))))
                (_K537551_ (lambda () '"")))
            (let ((_try-match535554_
                   (lambda ()
                     (if (let () (declare (not safe)) (##null? _fields533542_))
                         (_K537551_)
                         (_E536546_)))))
              (if (let () (declare (not safe)) (##pair? _fields533542_))
                  (let ((_tl540568_
                         (let () (declare (not safe)) (##cdr _fields533542_)))
                        (_hd539566_
                         (let () (declare (not safe)) (##car _fields533542_))))
                    (let ((_first571_ _hd539566_) (_rest573_ _tl540568_))
                      (_K538563_ _rest573_ _first571_)))
                  (_try-match535554_))))))))
  (define std/net/uri#form-url-encode__0
    (lambda (_fields608_)
      (let ((_+space?610_ '#t))
        (std/net/uri#form-url-encode__% _fields608_ _+space?610_))))
  (define std/net/uri#form-url-encode
    (lambda _g4351_
      (let ((_g4350_ (let () (declare (not safe)) (##length _g4351_))))
        (cond ((let () (declare (not safe)) (##fx= _g4350_ 1))
               (apply std/net/uri#form-url-encode__0 _g4351_))
              ((let () (declare (not safe)) (##fx= _g4350_ 2))
               (apply std/net/uri#form-url-encode__% _g4351_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/uri#form-url-encode
                _g4351_))))))
  (define std/net/uri#write-uri-encoded
    (lambda (_str506_ _encoding507_)
      (letrec ((_write-hex509_
                (lambda (_n525_)
                  (write-char
                   (let ()
                     (declare (not safe))
                     (##string-ref '"0123456789ABCDEF" _n525_))))))
        (let* ((_utf8511_ (std/text/utf8#string->utf8__0 _str506_))
               (_len513_ (u8vector-length _utf8511_)))
          (let _lp516_ ((_n518_ '0))
            (if (let () (declare (not safe)) (##fx< _n518_ _len513_))
                (let ((_byte520_
                       (let ()
                         (declare (not safe))
                         (##u8vector-ref _utf8511_ _n518_))))
                  (let ((_$e522_ (let ()
                                   (declare (not safe))
                                   (##vector-ref _encoding507_ _byte520_))))
                    (if _$e522_
                        (write-char _$e522_)
                        (begin
                          (write-char '#\%)
                          (_write-hex509_
                           (let ((__tmp4352
                                  (let ()
                                    (declare (not safe))
                                    (##fxarithmetic-shift _byte520_ '-4))))
                             (declare (not safe))
                             (##fxand __tmp4352 '15)))
                          (_write-hex509_
                           (let ()
                             (declare (not safe))
                             (##fxand _byte520_ '15))))))
                  (_lp516_ (let () (declare (not safe)) (##fx+ _n518_ '1))))
                '#!void))))))
  (define std/net/uri#hex-bytes
    (let ((_ht500_ (make-table 'test: eq?)))
      (for-each
       (lambda (_n502_)
         (let ((_char504_
                (let ()
                  (declare (not safe))
                  (##string-ref '"0123456789ABCDEF" _n502_))))
           (table-set! _ht500_ _char504_ _n502_)
           (table-set! _ht500_ (char-downcase _char504_) _n502_)))
       (iota '16))
      _ht500_))
  (define std/net/uri#uri-decode__%
    (lambda (_str454_ _encoding455_)
      (letrec ((_hex-byte457_
                (lambda (_byte483_)
                  (let* ((_char485_ (integer->char _byte483_))
                         (_$e487_ (table-ref
                                   std/net/uri#hex-bytes
                                   _char485_
                                   '#f)))
                    (if _$e487_
                        (values _$e487_)
                        (error '"Malformed uri encoding" _char485_))))))
        (if _encoding455_
            (if (and (vector? _encoding455_)
                     (let ((__tmp4353 (vector-length _encoding455_)))
                       (declare (not safe))
                       (##fx= __tmp4353 '256)))
                '#!void
                (error '"Bad encoding table" _encoding455_))
            '#!void)
        (let* ((_utf8459_ (std/text/utf8#string->utf8__0 _str454_))
               (_len461_ (u8vector-length _utf8459_))
               (_pct463_ (char->integer '#\%)))
          (std/text/utf8#utf8->string__0
           (with-output-to-u8vector
            '()
            (lambda ()
              (let _lp467_ ((_n469_ '0))
                (if (let () (declare (not safe)) (##fx< _n469_ _len461_))
                    (let* ((_next471_
                            (let ()
                              (declare (not safe))
                              (##u8vector-ref _utf8459_ _n469_)))
                           (_$e473_ (if _encoding455_
                                        (let ()
                                          (declare (not safe))
                                          (##vector-ref
                                           _encoding455_
                                           _next471_))
                                        '#f)))
                      (if _$e473_
                          ((lambda (_char476_)
                             (write-char _char476_)
                             (_lp467_ (let ()
                                        (declare (not safe))
                                        (##fx+ _n469_ '1))))
                           _$e473_)
                          (if (eq? _next471_ _pct463_)
                              (let ((_n478_ (let ()
                                              (declare (not safe))
                                              (##fx+ _n469_ '1))))
                                (if (let ((__tmp4354
                                           (let ()
                                             (declare (not safe))
                                             (##fx+ _n478_ '1))))
                                      (declare (not safe))
                                      (##fx< __tmp4354 _len461_))
                                    (let ((_hi480_ (let ()
                                                     (declare (not safe))
                                                     (##u8vector-ref
                                                      _utf8459_
                                                      _n478_)))
                                          (_lo481_ (let ((__tmp4355
                                                          (let ()
                                                            (declare
                                                              (not safe))
                                                            (##fx+ _n478_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           '1))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (declare (not safe))
                                                     (##u8vector-ref
                                                      _utf8459_
                                                      __tmp4355))))
                                      (write-u8
                                       (let ((__tmp4357
                                              (let ((__tmp4358
                                                     (_hex-byte457_ _hi480_)))
                                                (declare (not safe))
                                                (##fxarithmetic-shift
                                                 __tmp4358
                                                 '4)))
                                             (__tmp4356
                                              (_hex-byte457_ _lo481_)))
                                         (declare (not safe))
                                         (##fxior __tmp4357 __tmp4356)))
                                      (_lp467_ (let ()
                                                 (declare (not safe))
                                                 (##fx+ _n478_ '2))))
                                    (error '"Malformed uri component")))
                              (begin
                                (write-u8 _next471_)
                                (_lp467_ (let ()
                                           (declare (not safe))
                                           (##fx+ _n469_ '1)))))))
                    '#!void)))))))))
  (define std/net/uri#uri-decode__0
    (lambda (_str493_)
      (let ((_encoding495_ '#f))
        (std/net/uri#uri-decode__% _str493_ _encoding495_))))
  (define std/net/uri#uri-decode
    (lambda _g4360_
      (let ((_g4359_ (let () (declare (not safe)) (##length _g4360_))))
        (cond ((let () (declare (not safe)) (##fx= _g4359_ 1))
               (apply std/net/uri#uri-decode__0 _g4360_))
              ((let () (declare (not safe)) (##fx= _g4359_ 2))
               (apply std/net/uri#uri-decode__% _g4360_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/uri#uri-decode
                _g4360_))))))
  (define std/net/uri#uri-space-decoding
    (std/net/uri#make-uri-encoding-table__% '"" '((#\+ . #\space))))
  (define std/net/uri#form-url-decode
    (lambda (_str389_)
      (filter-map1
       (lambda (_part391_)
         (if (not (string-empty? _part391_))
             (let* ((_g392406_ (string-split _part391_ '#\=))
                    (_else395414_
                     (lambda ()
                       (error '"Malformed form component" _part391_))))
               (let ((_K400436_
                      (lambda (_val433_ _key434_)
                        (cons (std/net/uri#uri-decode__%
                               _key434_
                               std/net/uri#uri-space-decoding)
                              (std/net/uri#uri-decode__%
                               _val433_
                               std/net/uri#uri-space-decoding))))
                     (_K397420_
                      (lambda (_key418_)
                        (cons (std/net/uri#uri-decode__%
                               _key418_
                               std/net/uri#uri-space-decoding)
                              '#f))))
                 (if (let () (declare (not safe)) (##pair? _g392406_))
                     (let ((_tl402441_
                            (let () (declare (not safe)) (##cdr _g392406_)))
                           (_hd401439_
                            (let () (declare (not safe)) (##car _g392406_))))
                       (if (let () (declare (not safe)) (##pair? _tl402441_))
                           (let ((_tl404448_
                                  (let ()
                                    (declare (not safe))
                                    (##cdr _tl402441_)))
                                 (_hd403446_
                                  (let ()
                                    (declare (not safe))
                                    (##car _tl402441_))))
                             (if (let ()
                                   (declare (not safe))
                                   (##null? _tl404448_))
                                 (let ((_key444_ _hd401439_)
                                       (_val451_ _hd403446_))
                                   (_K400436_ _val451_ _key444_))
                                 (_else395414_)))
                           (if (let ()
                                 (declare (not safe))
                                 (##null? _tl402441_))
                               (let ((_key428_ _hd401439_))
                                 (_K397420_ _key428_))
                               (_else395414_))))
                     (_else395414_))))
             '#f))
       (string-split _str389_ '#\&)))))
