/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.common.FileHelper;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.fasttrack.ActBarField;
import net.sf.mpxj.fasttrack.ActivityField;
import net.sf.mpxj.fasttrack.FastTrackData;
import net.sf.mpxj.fasttrack.FastTrackTable;
import net.sf.mpxj.fasttrack.FastTrackTableType;
import net.sf.mpxj.fasttrack.MapRow;
import net.sf.mpxj.fasttrack.ResourceField;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.ProjectReader;

public class FastTrackReader
implements ProjectReader {
    private FastTrackData m_data;
    private ProjectFile m_project;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private static final Pattern WBS_SPLIT_REGEX = Pattern.compile("(\\.|\\-|\\+|\\/|\\,|\\:|\\;|\\~|\\\\|\\| )");
    private static final Pattern RELATION_REGEX = Pattern.compile("(\\d+)(:\\d+)?(FS|SF|SS|FF)*(\\-|\\+)*(\\d+\\.\\d+)*");
    private static final Pattern ASSIGNMENT_REGEX = Pattern.compile("([^\\[]+)(?:(?:\\[(-?\\d+)\\%\\])|(?:\\[.+\\]))?");
    private static final Map<String, RelationType> RELATION_TYPE_MAP = new HashMap<String, RelationType>();

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(String string) throws MPXJException {
        return this.read(new File(string));
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        File file = null;
        try {
            file = InputStreamHelper.writeStreamToTempFile(inputStream, ".fts");
            ProjectFile projectFile = this.read(file);
            return projectFile;
        }
        catch (IOException iOException) {
            throw new MPXJException("Invalid file format", iOException);
        }
        finally {
            FileHelper.deleteQuietly(file);
        }
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        try {
            this.m_data = new FastTrackData();
            this.m_data.process(file);
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        catch (Exception exception) {
            throw new MPXJException("Invalid file format", exception);
        }
        finally {
            this.m_data = null;
        }
    }

    private ProjectFile read() throws Exception {
        this.m_project = new ProjectFile();
        this.m_eventManager = this.m_project.getEventManager();
        ProjectConfig projectConfig = this.m_project.getProjectConfig();
        projectConfig.setAutoCalendarUniqueID(false);
        projectConfig.setAutoTaskID(false);
        projectConfig.setAutoTaskUniqueID(false);
        projectConfig.setAutoResourceUniqueID(false);
        projectConfig.setAutoWBS(false);
        projectConfig.setAutoOutlineNumber(false);
        this.m_project.getProjectProperties().setFileApplication("FastTrack");
        this.m_project.getProjectProperties().setFileType("FTS");
        this.m_eventManager.addProjectListeners(this.m_projectListeners);
        this.processResources();
        this.processTasks();
        this.processDependencies();
        this.processAssignments();
        return this.m_project;
    }

    private void processResources() {
        FastTrackTable fastTrackTable = this.m_data.getTable(FastTrackTableType.RESOURCES);
        for (MapRow mapRow : fastTrackTable) {
            int n = mapRow.getInt(ResourceField.RESOURCE_ID);
            if (n <= 0) continue;
            Resource resource = this.m_project.addResource();
            resource.setCode(mapRow.getString(ResourceField.CODE));
            resource.setCostPerUse(mapRow.getCurrency(ResourceField.PER_USE_COST));
            resource.setEmailAddress(mapRow.getString(ResourceField.EMAIL_ADDRESS));
            resource.setFlag(1, mapRow.getBoolean(ResourceField.FLAG_1));
            resource.setFlag(2, mapRow.getBoolean(ResourceField.FLAG_2));
            resource.setFlag(3, mapRow.getBoolean(ResourceField.FLAG_3));
            resource.setFlag(4, mapRow.getBoolean(ResourceField.FLAG_4));
            resource.setFlag(5, mapRow.getBoolean(ResourceField.FLAG_5));
            resource.setFlag(6, mapRow.getBoolean(ResourceField.FLAG_6));
            resource.setFlag(7, mapRow.getBoolean(ResourceField.FLAG_7));
            resource.setFlag(8, mapRow.getBoolean(ResourceField.FLAG_8));
            resource.setFlag(9, mapRow.getBoolean(ResourceField.FLAG_9));
            resource.setFlag(10, mapRow.getBoolean(ResourceField.FLAG_10));
            resource.setFlag(11, mapRow.getBoolean(ResourceField.FLAG_11));
            resource.setFlag(12, mapRow.getBoolean(ResourceField.FLAG_12));
            resource.setFlag(13, mapRow.getBoolean(ResourceField.FLAG_13));
            resource.setFlag(14, mapRow.getBoolean(ResourceField.FLAG_14));
            resource.setFlag(15, mapRow.getBoolean(ResourceField.FLAG_15));
            resource.setFlag(16, mapRow.getBoolean(ResourceField.FLAG_16));
            resource.setFlag(17, mapRow.getBoolean(ResourceField.FLAG_17));
            resource.setFlag(18, mapRow.getBoolean(ResourceField.FLAG_18));
            resource.setFlag(19, mapRow.getBoolean(ResourceField.FLAG_19));
            resource.setFlag(20, mapRow.getBoolean(ResourceField.FLAG_20));
            resource.setGroup(mapRow.getString(ResourceField.GROUP));
            resource.setGUID(mapRow.getUUID(ResourceField._RESOURCE_GUID));
            resource.setInitials(mapRow.getString(ResourceField.INITIALS));
            resource.setMaterialLabel(mapRow.getString(ResourceField.MATERIAL_LABEL));
            resource.setName(mapRow.getString(ResourceField.RESOURCE_NAME));
            resource.setNotes(mapRow.getString(ResourceField.RESOURCE_NOTES));
            resource.setNumber(1, mapRow.getDouble(ResourceField.NUMBER_1));
            resource.setNumber(2, mapRow.getDouble(ResourceField.NUMBER_2));
            resource.setNumber(3, mapRow.getDouble(ResourceField.NUMBER_3));
            resource.setNumber(4, mapRow.getDouble(ResourceField.NUMBER_4));
            resource.setNumber(5, mapRow.getDouble(ResourceField.NUMBER_5));
            resource.setNumber(6, mapRow.getDouble(ResourceField.NUMBER_6));
            resource.setNumber(7, mapRow.getDouble(ResourceField.NUMBER_7));
            resource.setNumber(8, mapRow.getDouble(ResourceField.NUMBER_8));
            resource.setNumber(9, mapRow.getDouble(ResourceField.NUMBER_9));
            resource.setNumber(10, mapRow.getDouble(ResourceField.NUMBER_10));
            resource.setNumber(11, mapRow.getDouble(ResourceField.NUMBER_11));
            resource.setNumber(12, mapRow.getDouble(ResourceField.NUMBER_12));
            resource.setNumber(13, mapRow.getDouble(ResourceField.NUMBER_13));
            resource.setNumber(14, mapRow.getDouble(ResourceField.NUMBER_14));
            resource.setNumber(15, mapRow.getDouble(ResourceField.NUMBER_15));
            resource.setNumber(16, mapRow.getDouble(ResourceField.NUMBER_16));
            resource.setNumber(17, mapRow.getDouble(ResourceField.NUMBER_17));
            resource.setNumber(18, mapRow.getDouble(ResourceField.NUMBER_18));
            resource.setNumber(19, mapRow.getDouble(ResourceField.NUMBER_19));
            resource.setNumber(20, mapRow.getDouble(ResourceField.NUMBER_20));
            resource.setText(1, mapRow.getString(ResourceField.TEXT_1));
            resource.setText(2, mapRow.getString(ResourceField.TEXT_2));
            resource.setText(3, mapRow.getString(ResourceField.TEXT_3));
            resource.setText(4, mapRow.getString(ResourceField.TEXT_4));
            resource.setText(5, mapRow.getString(ResourceField.TEXT_5));
            resource.setText(6, mapRow.getString(ResourceField.TEXT_6));
            resource.setText(7, mapRow.getString(ResourceField.TEXT_7));
            resource.setText(8, mapRow.getString(ResourceField.TEXT_8));
            resource.setText(9, mapRow.getString(ResourceField.TEXT_9));
            resource.setText(10, mapRow.getString(ResourceField.TEXT_10));
            resource.setText(11, mapRow.getString(ResourceField.TEXT_11));
            resource.setText(12, mapRow.getString(ResourceField.TEXT_12));
            resource.setText(13, mapRow.getString(ResourceField.TEXT_13));
            resource.setText(14, mapRow.getString(ResourceField.TEXT_14));
            resource.setText(15, mapRow.getString(ResourceField.TEXT_15));
            resource.setText(16, mapRow.getString(ResourceField.TEXT_16));
            resource.setText(17, mapRow.getString(ResourceField.TEXT_17));
            resource.setText(18, mapRow.getString(ResourceField.TEXT_18));
            resource.setText(19, mapRow.getString(ResourceField.TEXT_19));
            resource.setText(20, mapRow.getString(ResourceField.TEXT_20));
            resource.setText(21, mapRow.getString(ResourceField.TEXT_21));
            resource.setText(22, mapRow.getString(ResourceField.TEXT_22));
            resource.setText(23, mapRow.getString(ResourceField.TEXT_23));
            resource.setText(24, mapRow.getString(ResourceField.TEXT_24));
            resource.setText(25, mapRow.getString(ResourceField.TEXT_25));
            resource.setText(26, mapRow.getString(ResourceField.TEXT_26));
            resource.setText(27, mapRow.getString(ResourceField.TEXT_27));
            resource.setText(28, mapRow.getString(ResourceField.TEXT_28));
            resource.setText(29, mapRow.getString(ResourceField.TEXT_29));
            resource.setText(30, mapRow.getString(ResourceField.TEXT_30));
            resource.setUniqueID(n);
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processTasks() {
        Object object;
        Object object2;
        Object object32;
        int n = 0;
        FastTrackTable fastTrackTable = this.m_data.getTable(FastTrackTableType.ACTIVITIES);
        for (Object object32 : fastTrackTable) {
            ++n;
            object2 = ((MapRow)object32).getInteger(ActivityField.ACTIVITY_ROW_ID);
            if (object2 == null || (Integer)object2 < 1) continue;
            object = this.m_project.addTask();
            ((Task)object).setName(((MapRow)object32).getString(ActivityField.ACTIVITY_NAME));
            ((Task)object).setID((Integer)object2);
            ((Task)object).setUniqueID(n);
            ((Task)object).setFlag(1, ((MapRow)object32).getBoolean(ActivityField.FLAG_1));
            ((Task)object).setFlag(2, ((MapRow)object32).getBoolean(ActivityField.FLAG_2));
            ((Task)object).setFlag(3, ((MapRow)object32).getBoolean(ActivityField.FLAG_3));
            ((Task)object).setFlag(4, ((MapRow)object32).getBoolean(ActivityField.FLAG_4));
            ((Task)object).setFlag(5, ((MapRow)object32).getBoolean(ActivityField.FLAG_5));
            ((Task)object).setFlag(6, ((MapRow)object32).getBoolean(ActivityField.FLAG_6));
            ((Task)object).setFlag(7, ((MapRow)object32).getBoolean(ActivityField.FLAG_7));
            ((Task)object).setFlag(8, ((MapRow)object32).getBoolean(ActivityField.FLAG_8));
            ((Task)object).setFlag(9, ((MapRow)object32).getBoolean(ActivityField.FLAG_9));
            ((Task)object).setFlag(10, ((MapRow)object32).getBoolean(ActivityField.FLAG_10));
            ((Task)object).setFlag(11, ((MapRow)object32).getBoolean(ActivityField.FLAG_11));
            ((Task)object).setFlag(12, ((MapRow)object32).getBoolean(ActivityField.FLAG_12));
            ((Task)object).setFlag(13, ((MapRow)object32).getBoolean(ActivityField.FLAG_13));
            ((Task)object).setFlag(14, ((MapRow)object32).getBoolean(ActivityField.FLAG_14));
            ((Task)object).setFlag(15, ((MapRow)object32).getBoolean(ActivityField.FLAG_15));
            ((Task)object).setFlag(16, ((MapRow)object32).getBoolean(ActivityField.FLAG_16));
            ((Task)object).setFlag(17, ((MapRow)object32).getBoolean(ActivityField.FLAG_17));
            ((Task)object).setFlag(18, ((MapRow)object32).getBoolean(ActivityField.FLAG_18));
            ((Task)object).setFlag(19, ((MapRow)object32).getBoolean(ActivityField.FLAG_19));
            ((Task)object).setFlag(20, ((MapRow)object32).getBoolean(ActivityField.FLAG_20));
            ((Task)object).setText(1, ((MapRow)object32).getString(ActivityField.TEXT_1));
            ((Task)object).setText(2, ((MapRow)object32).getString(ActivityField.TEXT_2));
            ((Task)object).setText(3, ((MapRow)object32).getString(ActivityField.TEXT_3));
            ((Task)object).setText(4, ((MapRow)object32).getString(ActivityField.TEXT_4));
            ((Task)object).setText(5, ((MapRow)object32).getString(ActivityField.TEXT_5));
            ((Task)object).setText(6, ((MapRow)object32).getString(ActivityField.TEXT_6));
            ((Task)object).setText(7, ((MapRow)object32).getString(ActivityField.TEXT_7));
            ((Task)object).setText(8, ((MapRow)object32).getString(ActivityField.TEXT_8));
            ((Task)object).setText(9, ((MapRow)object32).getString(ActivityField.TEXT_9));
            ((Task)object).setText(10, ((MapRow)object32).getString(ActivityField.TEXT_10));
            ((Task)object).setText(11, ((MapRow)object32).getString(ActivityField.TEXT_11));
            ((Task)object).setText(12, ((MapRow)object32).getString(ActivityField.TEXT_12));
            ((Task)object).setText(13, ((MapRow)object32).getString(ActivityField.TEXT_13));
            ((Task)object).setText(14, ((MapRow)object32).getString(ActivityField.TEXT_14));
            ((Task)object).setText(15, ((MapRow)object32).getString(ActivityField.TEXT_15));
            ((Task)object).setText(16, ((MapRow)object32).getString(ActivityField.TEXT_16));
            ((Task)object).setText(17, ((MapRow)object32).getString(ActivityField.TEXT_17));
            ((Task)object).setText(18, ((MapRow)object32).getString(ActivityField.TEXT_18));
            ((Task)object).setText(19, ((MapRow)object32).getString(ActivityField.TEXT_19));
            ((Task)object).setText(20, ((MapRow)object32).getString(ActivityField.TEXT_20));
            ((Task)object).setText(21, ((MapRow)object32).getString(ActivityField.TEXT_21));
            ((Task)object).setText(22, ((MapRow)object32).getString(ActivityField.TEXT_22));
            ((Task)object).setText(23, ((MapRow)object32).getString(ActivityField.TEXT_23));
            ((Task)object).setText(24, ((MapRow)object32).getString(ActivityField.TEXT_24));
            ((Task)object).setText(25, ((MapRow)object32).getString(ActivityField.TEXT_25));
            ((Task)object).setText(26, ((MapRow)object32).getString(ActivityField.TEXT_26));
            ((Task)object).setText(27, ((MapRow)object32).getString(ActivityField.TEXT_27));
            ((Task)object).setText(28, ((MapRow)object32).getString(ActivityField.TEXT_28));
            ((Task)object).setText(29, ((MapRow)object32).getString(ActivityField.TEXT_29));
            ((Task)object).setText(30, ((MapRow)object32).getString(ActivityField.TEXT_30));
            ((Task)object).setWBS(((MapRow)object32).getString(ActivityField.WBS));
            ((Task)object).setGUID(((MapRow)object32).getUUID(ActivityField._ACTIVITY_GUID));
            ((Task)object).setOutlineLevel(this.getOutlineLevel((Task)object));
            this.m_eventManager.fireTaskReadEvent((Task)object);
        }
        FastTrackTable fastTrackTable2 = this.m_data.getTable(FastTrackTableType.ACTBARS);
        object32 = new HashSet();
        object2 = fastTrackTable2.iterator();
        while (object2.hasNext()) {
            Task task;
            object = (MapRow)object2.next();
            if (((MapRow)object).getInt(ActBarField.BAR_ID) < 1 || (task = this.m_project.getTaskByUniqueID(((MapRow)object).getInteger(ActBarField._ACTIVITY))) == null || object32.contains(task)) continue;
            object32.add(task);
            task.setActualDuration(((MapRow)object).getDuration(ActBarField.ACTUAL_DURATION));
            task.setActualFinish(((MapRow)object).getTimestamp(ActBarField.ACTUAL_FINISH_DATE, ActBarField.ACTUAL_FINISH_TIME));
            task.setActualStart(((MapRow)object).getTimestamp(ActBarField.ACTUAL_START_DATE, ActBarField.ACTUAL_START_TIME));
            task.setBaselineCost(1, ((MapRow)object).getCurrency(ActBarField.BASELINE_COST_1));
            task.setBaselineCost(2, ((MapRow)object).getCurrency(ActBarField.BASELINE_COST_2));
            task.setBaselineCost(3, ((MapRow)object).getCurrency(ActBarField.BASELINE_COST_3));
            task.setBaselineCost(4, ((MapRow)object).getCurrency(ActBarField.BASELINE_COST_4));
            task.setBaselineCost(5, ((MapRow)object).getCurrency(ActBarField.BASELINE_COST_5));
            task.setBaselineCost(6, ((MapRow)object).getCurrency(ActBarField.BASELINE_COST_6));
            task.setBaselineCost(7, ((MapRow)object).getCurrency(ActBarField.BASELINE_COST_7));
            task.setBaselineCost(8, ((MapRow)object).getCurrency(ActBarField.BASELINE_COST_8));
            task.setBaselineCost(9, ((MapRow)object).getCurrency(ActBarField.BASELINE_COST_9));
            task.setBaselineCost(10, ((MapRow)object).getCurrency(ActBarField.BASELINE_COST_10));
            task.setBaselineDuration(1, ((MapRow)object).getDuration(ActBarField.BASELINE_DURATION_1));
            task.setBaselineDuration(2, ((MapRow)object).getDuration(ActBarField.BASELINE_DURATION_2));
            task.setBaselineDuration(3, ((MapRow)object).getDuration(ActBarField.BASELINE_DURATION_3));
            task.setBaselineDuration(4, ((MapRow)object).getDuration(ActBarField.BASELINE_DURATION_4));
            task.setBaselineDuration(5, ((MapRow)object).getDuration(ActBarField.BASELINE_DURATION_5));
            task.setBaselineDuration(6, ((MapRow)object).getDuration(ActBarField.BASELINE_DURATION_6));
            task.setBaselineDuration(7, ((MapRow)object).getDuration(ActBarField.BASELINE_DURATION_7));
            task.setBaselineDuration(8, ((MapRow)object).getDuration(ActBarField.BASELINE_DURATION_8));
            task.setBaselineDuration(9, ((MapRow)object).getDuration(ActBarField.BASELINE_DURATION_9));
            task.setBaselineDuration(10, ((MapRow)object).getDuration(ActBarField.BASELINE_DURATION_10));
            task.setBaselineFinish(1, ((MapRow)object).getTimestamp(ActBarField.BASELINE_FINISH_DATE_1, ActBarField.BASELINE_FINISH_TIME_1));
            task.setBaselineFinish(2, ((MapRow)object).getTimestamp(ActBarField.BASELINE_FINISH_DATE_2, ActBarField.BASELINE_FINISH_TIME_2));
            task.setBaselineFinish(3, ((MapRow)object).getTimestamp(ActBarField.BASELINE_FINISH_DATE_3, ActBarField.BASELINE_FINISH_TIME_3));
            task.setBaselineFinish(4, ((MapRow)object).getTimestamp(ActBarField.BASELINE_FINISH_DATE_4, ActBarField.BASELINE_FINISH_TIME_4));
            task.setBaselineFinish(5, ((MapRow)object).getTimestamp(ActBarField.BASELINE_FINISH_DATE_5, ActBarField.BASELINE_FINISH_TIME_5));
            task.setBaselineFinish(6, ((MapRow)object).getTimestamp(ActBarField.BASELINE_FINISH_DATE_6, ActBarField.BASELINE_FINISH_TIME_6));
            task.setBaselineFinish(7, ((MapRow)object).getTimestamp(ActBarField.BASELINE_FINISH_DATE_7, ActBarField.BASELINE_FINISH_TIME_7));
            task.setBaselineFinish(8, ((MapRow)object).getTimestamp(ActBarField.BASELINE_FINISH_DATE_8, ActBarField.BASELINE_FINISH_TIME_8));
            task.setBaselineFinish(9, ((MapRow)object).getTimestamp(ActBarField.BASELINE_FINISH_DATE_9, ActBarField.BASELINE_FINISH_TIME_9));
            task.setBaselineFinish(10, ((MapRow)object).getTimestamp(ActBarField.BASELINE_FINISH_DATE_10, ActBarField.BASELINE_FINISH_TIME_10));
            task.setBaselineFinish(1, ((MapRow)object).getTimestamp(ActBarField.BASELINE_START_DATE_1, ActBarField.BASELINE_START_TIME_1));
            task.setBaselineFinish(2, ((MapRow)object).getTimestamp(ActBarField.BASELINE_START_DATE_2, ActBarField.BASELINE_START_TIME_2));
            task.setBaselineFinish(3, ((MapRow)object).getTimestamp(ActBarField.BASELINE_START_DATE_3, ActBarField.BASELINE_START_TIME_3));
            task.setBaselineFinish(4, ((MapRow)object).getTimestamp(ActBarField.BASELINE_START_DATE_4, ActBarField.BASELINE_START_TIME_4));
            task.setBaselineFinish(5, ((MapRow)object).getTimestamp(ActBarField.BASELINE_START_DATE_5, ActBarField.BASELINE_START_TIME_5));
            task.setBaselineFinish(6, ((MapRow)object).getTimestamp(ActBarField.BASELINE_START_DATE_6, ActBarField.BASELINE_START_TIME_6));
            task.setBaselineFinish(7, ((MapRow)object).getTimestamp(ActBarField.BASELINE_START_DATE_7, ActBarField.BASELINE_START_TIME_7));
            task.setBaselineFinish(8, ((MapRow)object).getTimestamp(ActBarField.BASELINE_START_DATE_8, ActBarField.BASELINE_START_TIME_8));
            task.setBaselineFinish(9, ((MapRow)object).getTimestamp(ActBarField.BASELINE_START_DATE_9, ActBarField.BASELINE_START_TIME_9));
            task.setBaselineFinish(10, ((MapRow)object).getTimestamp(ActBarField.BASELINE_START_DATE_10, ActBarField.BASELINE_START_TIME_10));
            task.setBaselineWork(1, ((MapRow)object).getWork(ActBarField.BASELINE_WORK_1));
            task.setBaselineWork(2, ((MapRow)object).getWork(ActBarField.BASELINE_WORK_2));
            task.setBaselineWork(3, ((MapRow)object).getWork(ActBarField.BASELINE_WORK_3));
            task.setBaselineWork(4, ((MapRow)object).getWork(ActBarField.BASELINE_WORK_4));
            task.setBaselineWork(5, ((MapRow)object).getWork(ActBarField.BASELINE_WORK_5));
            task.setBaselineWork(6, ((MapRow)object).getWork(ActBarField.BASELINE_WORK_6));
            task.setBaselineWork(7, ((MapRow)object).getWork(ActBarField.BASELINE_WORK_7));
            task.setBaselineWork(8, ((MapRow)object).getWork(ActBarField.BASELINE_WORK_8));
            task.setBaselineWork(9, ((MapRow)object).getWork(ActBarField.BASELINE_WORK_9));
            task.setBaselineWork(10, ((MapRow)object).getWork(ActBarField.BASELINE_WORK_10));
            task.setConstraintDate(((MapRow)object).getTimestamp(ActBarField.CONSTRAINT_DATE, ActBarField.CONSTRAINT_TIME));
            task.setCost(1, ((MapRow)object).getCurrency(ActBarField.COST_1));
            task.setCost(2, ((MapRow)object).getCurrency(ActBarField.COST_2));
            task.setCost(3, ((MapRow)object).getCurrency(ActBarField.COST_3));
            task.setCost(4, ((MapRow)object).getCurrency(ActBarField.COST_4));
            task.setCost(5, ((MapRow)object).getCurrency(ActBarField.COST_5));
            task.setCost(6, ((MapRow)object).getCurrency(ActBarField.COST_6));
            task.setCost(7, ((MapRow)object).getCurrency(ActBarField.COST_7));
            task.setCost(8, ((MapRow)object).getCurrency(ActBarField.COST_8));
            task.setCost(9, ((MapRow)object).getCurrency(ActBarField.COST_9));
            task.setCost(10, ((MapRow)object).getCurrency(ActBarField.COST_10));
            task.setCritical(((MapRow)object).getBoolean(ActBarField.CRITICAL));
            task.setDate(1, ((MapRow)object).getDate(ActBarField.DATE_1));
            task.setDate(2, ((MapRow)object).getDate(ActBarField.DATE_2));
            task.setDate(3, ((MapRow)object).getDate(ActBarField.DATE_3));
            task.setDate(4, ((MapRow)object).getDate(ActBarField.DATE_4));
            task.setDate(5, ((MapRow)object).getDate(ActBarField.DATE_5));
            task.setDate(6, ((MapRow)object).getDate(ActBarField.DATE_6));
            task.setDate(7, ((MapRow)object).getDate(ActBarField.DATE_7));
            task.setDate(8, ((MapRow)object).getDate(ActBarField.DATE_8));
            task.setDate(9, ((MapRow)object).getDate(ActBarField.DATE_9));
            task.setDate(10, ((MapRow)object).getDate(ActBarField.DATE_10));
            task.setDuration(((MapRow)object).getDuration(ActBarField.DURATION));
            task.setDuration(1, ((MapRow)object).getDuration(ActBarField.DURATION_1));
            task.setDuration(2, ((MapRow)object).getDuration(ActBarField.DURATION_2));
            task.setDuration(3, ((MapRow)object).getDuration(ActBarField.DURATION_3));
            task.setDuration(4, ((MapRow)object).getDuration(ActBarField.DURATION_4));
            task.setDuration(5, ((MapRow)object).getDuration(ActBarField.DURATION_5));
            task.setDuration(6, ((MapRow)object).getDuration(ActBarField.DURATION_6));
            task.setDuration(7, ((MapRow)object).getDuration(ActBarField.DURATION_7));
            task.setDuration(8, ((MapRow)object).getDuration(ActBarField.DURATION_8));
            task.setDuration(9, ((MapRow)object).getDuration(ActBarField.DURATION_9));
            task.setDuration(10, ((MapRow)object).getDuration(ActBarField.DURATION_10));
            task.setEarlyFinish(((MapRow)object).getTimestamp(ActBarField.EARLY_FINISH_DATE, ActBarField.EARLY_FINISH_TIME));
            task.setEarlyStart(((MapRow)object).getTimestamp(ActBarField.EARLY_START_DATE, ActBarField.EARLY_START_TIME));
            task.setEffortDriven(((MapRow)object).getBoolean(ActBarField.EFFORT_DRIVEN));
            task.setFinish(((MapRow)object).getTimestamp(ActBarField.FINISH_DATE, ActBarField.FINISH_TIME));
            task.setFinish(1, ((MapRow)object).getTimestamp(ActBarField.FINISH_DATE_1, ActBarField.FINISH_TIME_1));
            task.setFinish(2, ((MapRow)object).getTimestamp(ActBarField.FINISH_DATE_2, ActBarField.FINISH_TIME_2));
            task.setFinish(3, ((MapRow)object).getTimestamp(ActBarField.FINISH_DATE_3, ActBarField.FINISH_TIME_3));
            task.setFinish(4, ((MapRow)object).getTimestamp(ActBarField.FINISH_DATE_4, ActBarField.FINISH_TIME_4));
            task.setFinish(5, ((MapRow)object).getTimestamp(ActBarField.FINISH_DATE_5, ActBarField.FINISH_TIME_5));
            task.setFinish(6, ((MapRow)object).getTimestamp(ActBarField.FINISH_DATE_6, ActBarField.FINISH_TIME_6));
            task.setFinish(7, ((MapRow)object).getTimestamp(ActBarField.FINISH_DATE_7, ActBarField.FINISH_TIME_7));
            task.setFinish(8, ((MapRow)object).getTimestamp(ActBarField.FINISH_DATE_8, ActBarField.FINISH_TIME_8));
            task.setFinish(9, ((MapRow)object).getTimestamp(ActBarField.FINISH_DATE_9, ActBarField.FINISH_TIME_9));
            task.setFinish(10, ((MapRow)object).getTimestamp(ActBarField.FINISH_DATE_10, ActBarField.FINISH_TIME_10));
            task.setIgnoreResourceCalendar(((MapRow)object).getBoolean(ActBarField.IGNORE_RESOURCE_CALENDARS));
            task.setLateFinish(((MapRow)object).getTimestamp(ActBarField.LATE_FINISH_DATE, ActBarField.LATE_FINISH_TIME));
            task.setLateStart(((MapRow)object).getTimestamp(ActBarField.LATE_START_DATE, ActBarField.LATE_START_TIME));
            task.setNumber(1, ((MapRow)object).getDouble(ActBarField.NUMBER_1));
            task.setNumber(2, ((MapRow)object).getDouble(ActBarField.NUMBER_2));
            task.setNumber(3, ((MapRow)object).getDouble(ActBarField.NUMBER_3));
            task.setNumber(4, ((MapRow)object).getDouble(ActBarField.NUMBER_4));
            task.setNumber(5, ((MapRow)object).getDouble(ActBarField.NUMBER_5));
            task.setNumber(6, ((MapRow)object).getDouble(ActBarField.NUMBER_6));
            task.setNumber(7, ((MapRow)object).getDouble(ActBarField.NUMBER_7));
            task.setNumber(8, ((MapRow)object).getDouble(ActBarField.NUMBER_8));
            task.setNumber(9, ((MapRow)object).getDouble(ActBarField.NUMBER_9));
            task.setNumber(10, ((MapRow)object).getDouble(ActBarField.NUMBER_10));
            task.setNumber(11, ((MapRow)object).getDouble(ActBarField.NUMBER_11));
            task.setNumber(12, ((MapRow)object).getDouble(ActBarField.NUMBER_12));
            task.setNumber(13, ((MapRow)object).getDouble(ActBarField.NUMBER_13));
            task.setNumber(14, ((MapRow)object).getDouble(ActBarField.NUMBER_14));
            task.setNumber(15, ((MapRow)object).getDouble(ActBarField.NUMBER_15));
            task.setNumber(16, ((MapRow)object).getDouble(ActBarField.NUMBER_16));
            task.setNumber(17, ((MapRow)object).getDouble(ActBarField.NUMBER_17));
            task.setNumber(18, ((MapRow)object).getDouble(ActBarField.NUMBER_18));
            task.setNumber(19, ((MapRow)object).getDouble(ActBarField.NUMBER_19));
            task.setNumber(20, ((MapRow)object).getDouble(ActBarField.NUMBER_20));
            task.setPercentageComplete(((MapRow)object).getDouble(ActBarField.PERCENT_COMPLETE));
            task.setResourceNames(((MapRow)object).getString(ActBarField.RESOURCES_ASSIGNED));
            task.setStart(((MapRow)object).getTimestamp(ActBarField.START_DATE, ActBarField.START_TIME));
            task.setStart(1, ((MapRow)object).getTimestamp(ActBarField.START_DATE_1, ActBarField.START_TIME_1));
            task.setStart(2, ((MapRow)object).getTimestamp(ActBarField.START_DATE_2, ActBarField.START_TIME_2));
            task.setStart(3, ((MapRow)object).getTimestamp(ActBarField.START_DATE_3, ActBarField.START_TIME_3));
            task.setStart(4, ((MapRow)object).getTimestamp(ActBarField.START_DATE_4, ActBarField.START_TIME_4));
            task.setStart(5, ((MapRow)object).getTimestamp(ActBarField.START_DATE_5, ActBarField.START_TIME_5));
            task.setStart(6, ((MapRow)object).getTimestamp(ActBarField.START_DATE_6, ActBarField.START_TIME_6));
            task.setStart(7, ((MapRow)object).getTimestamp(ActBarField.START_DATE_7, ActBarField.START_TIME_7));
            task.setStart(8, ((MapRow)object).getTimestamp(ActBarField.START_DATE_8, ActBarField.START_TIME_8));
            task.setStart(9, ((MapRow)object).getTimestamp(ActBarField.START_DATE_9, ActBarField.START_TIME_9));
            task.setStart(10, ((MapRow)object).getTimestamp(ActBarField.START_DATE_10, ActBarField.START_TIME_10));
            task.setWork(((MapRow)object).getWork(ActBarField.WORK));
        }
        this.m_project.updateStructure();
    }

    private void processDependencies() {
        HashSet<Task> hashSet = new HashSet<Task>();
        FastTrackTable fastTrackTable = this.m_data.getTable(FastTrackTableType.ACTBARS);
        for (MapRow mapRow : fastTrackTable) {
            Task task = this.m_project.getTaskByUniqueID(mapRow.getInteger(ActBarField._ACTIVITY));
            if (task == null || hashSet.contains(task)) continue;
            hashSet.add(task);
            String string = mapRow.getString(ActBarField.PREDECESSORS);
            if (string == null || string.isEmpty()) continue;
            for (String string2 : string.split(", ")) {
                Task task2;
                Matcher matcher = RELATION_REGEX.matcher(string2);
                matcher.matches();
                Integer n = Integer.valueOf(matcher.group(1));
                RelationType relationType = RELATION_TYPE_MAP.get(matcher.group(3));
                if (relationType == null) {
                    relationType = RelationType.FINISH_START;
                }
                String string3 = matcher.group(4);
                double d = NumberHelper.getDouble(matcher.group(5));
                if ("-".equals(string3)) {
                    d = -d;
                }
                if ((task2 = this.m_project.getTaskByID(n)) == null) continue;
                Duration duration = Duration.getInstance(d, this.m_data.getDurationTimeUnit());
                Relation relation = task.addPredecessor(task2, relationType, duration);
                this.m_eventManager.fireRelationReadEvent(relation);
            }
        }
    }

    private void processAssignments() {
        HashSet<Task> hashSet = new HashSet<Task>();
        FastTrackTable fastTrackTable = this.m_data.getTable(FastTrackTableType.ACTBARS);
        HashMap<String, Resource> hashMap = new HashMap<String, Resource>();
        for (Object object : this.m_project.getResources()) {
            hashMap.put(((Resource)object).getName(), (Resource)object);
        }
        for (Object object : fastTrackTable) {
            Task task = this.m_project.getTaskByUniqueID(((MapRow)object).getInteger(ActBarField._ACTIVITY));
            if (task == null || hashSet.contains(task)) continue;
            hashSet.add(task);
            String string = ((MapRow)object).getString(ActBarField.RESOURCES_ASSIGNED);
            if (string == null || string.isEmpty()) continue;
            for (String string2 : string.split(", ")) {
                if (string2.isEmpty()) continue;
                Matcher matcher = ASSIGNMENT_REGEX.matcher(string2);
                matcher.matches();
                Resource resource = (Resource)hashMap.get(matcher.group(1));
                if (resource == null) continue;
                ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
                String string3 = matcher.group(2);
                if (string3 != null) {
                    resourceAssignment.setUnits(Integer.valueOf(string3));
                }
                this.m_eventManager.fireAssignmentReadEvent(resourceAssignment);
            }
        }
    }

    private Integer getOutlineLevel(Task task) {
        String string = task.getWBS();
        Integer n = 1;
        if (string != null && string.length() > 0) {
            String[] stringArray = WBS_SPLIT_REGEX.split(string);
            n = stringArray.length;
        }
        return n;
    }

    static {
        RELATION_TYPE_MAP.put("FS", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("FF", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("SS", RelationType.START_START);
        RELATION_TYPE_MAP.put("SF", RelationType.START_FINISH);
    }
}

