/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.WriteScope;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class MapInitializationNode
extends ExpressionNode {
    private final List<ExpressionNode> keyNodes = new ArrayList<ExpressionNode>();
    private final List<ExpressionNode> valueNodes = new ArrayList<ExpressionNode>();
    private PainlessConstructor constructor;
    private PainlessMethod method;

    public void addArgumentNode(ExpressionNode keyNode, ExpressionNode valueNode) {
        this.keyNodes.add(keyNode);
        this.valueNodes.add(valueNode);
    }

    public ExpressionNode getKeyNode(int index) {
        return this.keyNodes.get(index);
    }

    public ExpressionNode getValueNode(int index) {
        return this.valueNodes.get(index);
    }

    public int getArgumentsSize() {
        return this.keyNodes.size();
    }

    public List<ExpressionNode> getKeyNodes() {
        return this.keyNodes;
    }

    public List<ExpressionNode> getValueNodes() {
        return this.valueNodes;
    }

    public void setConstructor(PainlessConstructor constructor) {
        this.constructor = constructor;
    }

    public PainlessConstructor getConstructor() {
        return this.constructor;
    }

    public void setMethod(PainlessMethod method) {
        this.method = method;
    }

    public PainlessMethod getMethod() {
        return this.method;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitMapInitialization(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        for (ExpressionNode keyNode : this.keyNodes) {
            keyNode.visit(irTreeVisitor, scope);
        }
        for (ExpressionNode valueNode : this.valueNodes) {
            valueNode.visit(irTreeVisitor, scope);
        }
    }

    public MapInitializationNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeDebugInfo(this.getLocation());
        methodWriter.newInstance(MethodWriter.getType(this.getExpressionType()));
        methodWriter.dup();
        methodWriter.invokeConstructor(Type.getType(this.constructor.javaConstructor.getDeclaringClass()), Method.getMethod(this.constructor.javaConstructor));
        for (int index = 0; index < this.getArgumentsSize(); ++index) {
            methodWriter.dup();
            this.getKeyNode(index).write(classWriter, methodWriter, writeScope);
            this.getValueNode(index).write(classWriter, methodWriter, writeScope);
            methodWriter.invokeMethodCall(this.method);
            methodWriter.pop();
        }
    }
}

