/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.DataContext;
import org.apache.calcite.DataContexts;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.Path;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.RelRunner;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Schemas {
    private Schemas() {
        throw new AssertionError((Object)"no instances!");
    }

    public static @Nullable CalciteSchema.FunctionEntry resolve(RelDataTypeFactory typeFactory, String name, Collection<CalciteSchema.FunctionEntry> functionEntries, List<RelDataType> argumentTypes) {
        ArrayList<CalciteSchema.FunctionEntry> matches = new ArrayList<CalciteSchema.FunctionEntry>();
        for (CalciteSchema.FunctionEntry entry : functionEntries) {
            if (!Schemas.matches(typeFactory, entry.getFunction(), argumentTypes)) continue;
            matches.add(entry);
        }
        switch (matches.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (CalciteSchema.FunctionEntry)matches.get(0);
            }
        }
        throw new RuntimeException("More than one match for " + name + " with arguments " + argumentTypes);
    }

    private static boolean matches(RelDataTypeFactory typeFactory, Function member, List<RelDataType> argumentTypes) {
        List<FunctionParameter> parameters = member.getParameters();
        if (parameters.size() != argumentTypes.size()) {
            return false;
        }
        for (int i = 0; i < argumentTypes.size(); ++i) {
            FunctionParameter parameter;
            RelDataType argumentType = argumentTypes.get(i);
            if (Schemas.canConvert(argumentType, (parameter = parameters.get(i)).getType(typeFactory))) continue;
            return false;
        }
        return true;
    }

    private static boolean canConvert(RelDataType fromType, RelDataType toType) {
        return SqlTypeUtil.canAssignFrom(toType, fromType);
    }

    public static Expression expression(SchemaPlus schema) {
        return schema.getExpression(schema.getParentSchema(), schema.getName());
    }

    public static Expression subSchemaExpression(SchemaPlus schema, String name, Class type) {
        Expression schemaExpression = Schemas.expression(schema);
        MethodCallExpression call = Expressions.call((Expression)schemaExpression, (Method)BuiltInMethod.SCHEMA_GET_SUB_SCHEMA.method, (Expression[])new Expression[]{Expressions.constant((Object)name)});
        return call;
    }

    public static Expression unwrap(Expression call, Class type) {
        return Expressions.convert_((Expression)Expressions.call((Expression)call, (Method)BuiltInMethod.SCHEMA_PLUS_UNWRAP.method, (Expression[])new Expression[]{Expressions.constant((Object)type)}), (Type)type);
    }

    public static Expression tableExpression(SchemaPlus schema, Type elementType, String tableName, Class clazz) {
        MethodCallExpression expression;
        if (Table.class.isAssignableFrom(clazz)) {
            expression = Expressions.call((Expression)Schemas.expression(schema), (Method)BuiltInMethod.SCHEMA_GET_TABLE.method, (Expression[])new Expression[]{Expressions.constant((Object)tableName)});
            if (ScannableTable.class.isAssignableFrom(clazz)) {
                return Expressions.call((Method)BuiltInMethod.SCHEMAS_ENUMERABLE_SCANNABLE.method, (Expression[])new Expression[]{Expressions.convert_((Expression)expression, ScannableTable.class), DataContext.ROOT});
            }
            if (FilterableTable.class.isAssignableFrom(clazz)) {
                return Expressions.call((Method)BuiltInMethod.SCHEMAS_ENUMERABLE_FILTERABLE.method, (Expression[])new Expression[]{Expressions.convert_((Expression)expression, FilterableTable.class), DataContext.ROOT});
            }
            if (ProjectableFilterableTable.class.isAssignableFrom(clazz)) {
                return Expressions.call((Method)BuiltInMethod.SCHEMAS_ENUMERABLE_PROJECTABLE_FILTERABLE.method, (Expression[])new Expression[]{Expressions.convert_((Expression)expression, ProjectableFilterableTable.class), DataContext.ROOT});
            }
        } else {
            expression = Expressions.call((Method)BuiltInMethod.SCHEMAS_QUERYABLE.method, (Expression[])new Expression[]{DataContext.ROOT, Schemas.expression(schema), Expressions.constant((Object)elementType), Expressions.constant((Object)tableName)});
        }
        return EnumUtils.convert((Expression)expression, clazz);
    }

    public static DataContext createDataContext(Connection connection, @Nullable SchemaPlus rootSchema) {
        return DataContexts.of((CalciteConnection)connection, rootSchema);
    }

    public static <E> Queryable<E> queryable(DataContext root, Class<E> clazz, String ... names) {
        return Schemas.queryable(root, clazz, Arrays.asList(names));
    }

    public static <E> Queryable<E> queryable(DataContext root, Class<E> clazz, Iterable<? extends String> names) {
        String name;
        SchemaPlus schema = root.getRootSchema();
        Iterator<? extends String> iterator = names.iterator();
        while (true) {
            name = iterator.next();
            Objects.requireNonNull(schema, "schema");
            if (!iterator.hasNext()) break;
            SchemaPlus next = schema.getSubSchema(name);
            if (next == null) {
                throw new IllegalArgumentException("schema " + name + " is not found in " + schema);
            }
            schema = next;
        }
        return Schemas.queryable(root, schema, clazz, name);
    }

    public static <E> Queryable<E> queryable(DataContext root, SchemaPlus schema, Class<E> clazz, String tableName) {
        QueryableTable table = (QueryableTable)Objects.requireNonNull(schema.getTable(tableName), () -> "table " + tableName + " is not found in " + schema);
        QueryProvider queryProvider = root.getQueryProvider();
        return table.asQueryable(queryProvider, schema, tableName);
    }

    public static Enumerable<@Nullable Object[]> enumerable(ScannableTable table, DataContext root) {
        return table.scan(root);
    }

    public static Enumerable<@Nullable Object[]> enumerable(FilterableTable table, DataContext root) {
        return table.scan(root, new ArrayList<RexNode>());
    }

    public static Enumerable<@Nullable Object[]> enumerable(ProjectableFilterableTable table, DataContext root) {
        JavaTypeFactory typeFactory = root.getTypeFactory();
        return table.scan(root, new ArrayList<RexNode>(), Schemas.identity(table.getRowType(typeFactory).getFieldCount()));
    }

    private static int[] identity(int count) {
        int[] integers = new int[count];
        for (int i = 0; i < integers.length; ++i) {
            integers[i] = i;
        }
        return integers;
    }

    public static @Nullable Table table(DataContext root, String ... names) {
        String name;
        SchemaPlus schema = root.getRootSchema();
        List<String> nameList = Arrays.asList(names);
        Iterator<String> iterator = nameList.iterator();
        while (true) {
            name = iterator.next();
            Objects.requireNonNull(schema, "schema");
            if (!iterator.hasNext()) break;
            SchemaPlus next = schema.getSubSchema(name);
            if (next == null) {
                throw new IllegalArgumentException("schema " + name + " is not found in " + schema);
            }
            schema = next;
        }
        return schema.getTable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalcitePrepare.ParseResult parse(CalciteConnection connection, CalciteSchema schema, @Nullable List<String> schemaPath, String sql) {
        CalcitePrepare prepare = (CalcitePrepare)CalcitePrepare.DEFAULT_FACTORY.apply();
        ImmutableMap propValues = ImmutableMap.of();
        CalcitePrepare.Context context = Schemas.makeContext(connection, schema, schemaPath, null, (ImmutableMap<CalciteConnectionProperty, String>)propValues);
        CalcitePrepare.Dummy.push(context);
        try {
            CalcitePrepare.ParseResult parseResult = prepare.parse(context, sql);
            return parseResult;
        }
        finally {
            CalcitePrepare.Dummy.pop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalcitePrepare.ConvertResult convert(CalciteConnection connection, CalciteSchema schema, List<String> schemaPath, String sql) {
        CalcitePrepare prepare = (CalcitePrepare)CalcitePrepare.DEFAULT_FACTORY.apply();
        ImmutableMap propValues = ImmutableMap.of();
        CalcitePrepare.Context context = Schemas.makeContext(connection, schema, schemaPath, null, (ImmutableMap<CalciteConnectionProperty, String>)propValues);
        CalcitePrepare.Dummy.push(context);
        try {
            CalcitePrepare.ConvertResult convertResult = prepare.convert(context, sql);
            return convertResult;
        }
        finally {
            CalcitePrepare.Dummy.pop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalcitePrepare.AnalyzeViewResult analyzeView(CalciteConnection connection, CalciteSchema schema, @Nullable List<String> schemaPath, String viewSql, @Nullable List<String> viewPath, boolean fail) {
        CalcitePrepare prepare = (CalcitePrepare)CalcitePrepare.DEFAULT_FACTORY.apply();
        ImmutableMap propValues = ImmutableMap.of();
        CalcitePrepare.Context context = Schemas.makeContext(connection, schema, schemaPath, viewPath, (ImmutableMap<CalciteConnectionProperty, String>)propValues);
        CalcitePrepare.Dummy.push(context);
        try {
            CalcitePrepare.AnalyzeViewResult analyzeViewResult = prepare.analyzeView(context, viewSql, fail);
            return analyzeViewResult;
        }
        finally {
            CalcitePrepare.Dummy.pop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalcitePrepare.CalciteSignature<Object> prepare(CalciteConnection connection, CalciteSchema schema, @Nullable List<String> schemaPath, String sql, ImmutableMap<CalciteConnectionProperty, String> map) {
        CalcitePrepare prepare = (CalcitePrepare)CalcitePrepare.DEFAULT_FACTORY.apply();
        CalcitePrepare.Context context = Schemas.makeContext(connection, schema, schemaPath, null, map);
        CalcitePrepare.Dummy.push(context);
        try {
            CalcitePrepare.CalciteSignature<Object> calciteSignature = prepare.prepareSql(context, CalcitePrepare.Query.of(sql), (Type)((Object)Object[].class), -1L);
            return calciteSignature;
        }
        finally {
            CalcitePrepare.Dummy.pop(context);
        }
    }

    private static CalcitePrepare.Context makeContext(CalciteConnection connection, CalciteSchema schema, @Nullable List<String> schemaPath, @Nullable List<String> objectPath, ImmutableMap<CalciteConnectionProperty, String> propValues) {
        if (connection == null) {
            CalcitePrepare.Context context0 = CalcitePrepare.Dummy.peek();
            CalciteConnectionConfig config = Schemas.mutate(context0.config(), propValues);
            return Schemas.makeContext(config, context0.getTypeFactory(), context0.getDataContext(), schema, schemaPath, objectPath);
        }
        CalciteConnectionConfig config = Schemas.mutate(connection.config(), propValues);
        return Schemas.makeContext(config, connection.getTypeFactory(), DataContexts.of(connection, schema.root().plus()), schema, schemaPath, objectPath);
    }

    private static CalciteConnectionConfig mutate(CalciteConnectionConfig config, ImmutableMap<CalciteConnectionProperty, String> propValues) {
        for (Map.Entry e : propValues.entrySet()) {
            config = ((CalciteConnectionConfigImpl)config).set((CalciteConnectionProperty)((Object)e.getKey()), (String)e.getValue());
        }
        return config;
    }

    private static CalcitePrepare.Context makeContext(final CalciteConnectionConfig connectionConfig, final JavaTypeFactory typeFactory, final DataContext dataContext, final CalciteSchema schema, final @Nullable List<String> schemaPath, @Nullable List<String> objectPath_) {
        final @Nullable ImmutableList objectPath = objectPath_ == null ? null : ImmutableList.copyOf(objectPath_);
        return new CalcitePrepare.Context(){

            @Override
            public JavaTypeFactory getTypeFactory() {
                return typeFactory;
            }

            @Override
            public CalciteSchema getRootSchema() {
                return schema.root();
            }

            @Override
            public CalciteSchema getMutableRootSchema() {
                return this.getRootSchema();
            }

            @Override
            public List<String> getDefaultSchemaPath() {
                if (schemaPath == null) {
                    return schema.path(null);
                }
                return schemaPath;
            }

            @Override
            public @Nullable List<String> getObjectPath() {
                return objectPath;
            }

            @Override
            public CalciteConnectionConfig config() {
                return connectionConfig;
            }

            @Override
            public DataContext getDataContext() {
                return dataContext;
            }

            @Override
            public RelRunner getRelRunner() {
                throw new UnsupportedOperationException();
            }

            @Override
            public CalcitePrepare.SparkHandler spark() {
                boolean enable = this.config().spark();
                return CalcitePrepare.Dummy.getSparkHandler(enable);
            }
        };
    }

    public static RelProtoDataType proto(Table table) {
        return table::getRowType;
    }

    public static RelProtoDataType proto(ScalarFunction function) {
        return function::getReturnType;
    }

    public static List<CalciteSchema.TableEntry> getStarTables(CalciteSchema schema) {
        List<CalciteSchema.LatticeEntry> list = Schemas.getLatticeEntries(schema);
        return Util.transform(list, entry -> {
            CalciteSchema.TableEntry starTable = Objects.requireNonNull(entry, "entry").getStarTable();
            assert (starTable.getTable().getJdbcTableType() == Schema.TableType.STAR);
            return entry.getStarTable();
        });
    }

    public static List<Lattice> getLattices(CalciteSchema schema) {
        List<CalciteSchema.LatticeEntry> list = Schemas.getLatticeEntries(schema);
        return Util.transform(list, CalciteSchema.LatticeEntry::getLattice);
    }

    public static List<CalciteSchema.LatticeEntry> getLatticeEntries(CalciteSchema schema) {
        ArrayList<CalciteSchema.LatticeEntry> list = new ArrayList<CalciteSchema.LatticeEntry>();
        Schemas.gatherLattices(schema, list);
        return list;
    }

    private static void gatherLattices(CalciteSchema schema, List<CalciteSchema.LatticeEntry> list) {
        list.addAll(schema.getLatticeMap().values());
        for (CalciteSchema subSchema : schema.getSubSchemaMap().values()) {
            Schemas.gatherLattices(subSchema, list);
        }
    }

    public static @Nullable CalciteSchema subSchema(CalciteSchema schema, Iterable<String> names) {
        @Nullable CalciteSchema current = schema;
        for (String string : names) {
            if (current == null) {
                return null;
            }
            current = current.getSubSchema(string, false);
        }
        return current;
    }

    public static String uniqueTableName(CalciteSchema schema, String base) {
        String t = Objects.requireNonNull(base, "base");
        int x = 0;
        while (schema.getTable(t, true) != null) {
            t = base + x;
            ++x;
        }
        return t;
    }

    public static Path path(CalciteSchema rootSchema, Iterable<String> names) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Schema schema = rootSchema.plus();
        Iterator<String> iterator = names.iterator();
        if (!iterator.hasNext()) {
            return PathImpl.EMPTY;
        }
        if (!rootSchema.name.isEmpty()) {
            Preconditions.checkState((boolean)rootSchema.name.equals(iterator.next()));
        }
        while (true) {
            String name = iterator.next();
            builder.add(Pair.of(name, schema));
            if (!iterator.hasNext()) {
                return Schemas.path((ImmutableList<Pair<String, Schema>>)builder.build());
            }
            Schema next = schema.getSubSchema(name);
            if (next == null) {
                throw new IllegalArgumentException("schema " + name + " is not found in " + schema);
            }
            schema = next;
        }
    }

    public static PathImpl path(ImmutableList<Pair<String, Schema>> build) {
        return new PathImpl(build);
    }

    public static Path path(SchemaPlus schema) {
        ArrayList<Pair<String, SchemaPlus>> list = new ArrayList<Pair<String, SchemaPlus>>();
        for (SchemaPlus s = schema; s != null; s = s.getParentSchema()) {
            list.add(Pair.of(s.getName(), s));
        }
        return new PathImpl((ImmutableList<Pair<String, Schema>>)ImmutableList.copyOf((Collection)Lists.reverse(list)));
    }

    private static class PathImpl
    extends AbstractList<Pair<String, Schema>>
    implements Path {
        private final ImmutableList<Pair<String, Schema>> pairs;
        private static final PathImpl EMPTY = new PathImpl((ImmutableList<Pair<String, Schema>>)ImmutableList.of());

        PathImpl(ImmutableList<Pair<String, Schema>> pairs) {
            this.pairs = pairs;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            return this == o || o instanceof PathImpl && this.pairs.equals(((PathImpl)o).pairs);
        }

        @Override
        public int hashCode() {
            return this.pairs.hashCode();
        }

        @Override
        public Pair<String, Schema> get(int index) {
            return (Pair)this.pairs.get(index);
        }

        @Override
        public int size() {
            return this.pairs.size();
        }

        @Override
        public Path parent() {
            if (this.pairs.isEmpty()) {
                throw new IllegalArgumentException("at root");
            }
            return new PathImpl((ImmutableList<Pair<String, Schema>>)this.pairs.subList(0, this.pairs.size() - 1));
        }

        @Override
        public List<String> names() {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return (String)((Pair)((PathImpl)this).pairs.get((int)(index + 1))).left;
                }

                @Override
                public int size() {
                    return pairs.size() - 1;
                }
            };
        }

        @Override
        public List<Schema> schemas() {
            return Pair.right(this.pairs);
        }
    }
}

