/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.solr.cloud.SolrZkServer;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.core.CoreContainer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.xml.sax.SAXException;

public class ZkCLI {
    private static final String MAKEPATH = "makepath";
    private static final String PUT = "put";
    private static final String PUT_FILE = "putfile";
    private static final String GET = "get";
    private static final String GET_FILE = "getfile";
    private static final String DOWNCONFIG = "downconfig";
    private static final String ZK_CLI_NAME = "ZkCLI";
    private static final String HELP = "help";
    private static final String LINKCONFIG = "linkconfig";
    private static final String CONFDIR = "confdir";
    private static final String CONFNAME = "confname";
    private static final String ZKHOST = "zkhost";
    private static final String RUNZK = "runzk";
    private static final String SOLRHOME = "solrhome";
    private static final String BOOTSTRAP = "bootstrap";
    static final String UPCONFIG = "upconfig";
    static final String EXCLUDE_REGEX_SHORT = "x";
    static final String EXCLUDE_REGEX = "excluderegex";
    static final String EXCLUDE_REGEX_DEFAULT = "^\\..*$";
    private static final String COLLECTION = "collection";
    private static final String CLEAR = "clear";
    private static final String LIST = "list";
    private static final String LS = "ls";
    private static final String CMD = "cmd";
    private static final String CLUSTERPROP = "clusterprop";
    private static final String UPDATEACLS = "updateacls";
    private static PrintStream stdout = System.out;

    @VisibleForTesting
    public static void setStdout(PrintStream stdout) {
        ZkCLI.stdout = stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, TimeoutException, IOException, ParserConfigurationException, SAXException, KeeperException {
        block53: {
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption(Option.builder((String)CMD).hasArg(true).desc("cmd to run: bootstrap, upconfig, downconfig, linkconfig, makepath, put, putfile,get,getfile, list, clear, updateacls, ls").build());
            Option zkHostOption = new Option("z", ZKHOST, true, "ZooKeeper host address");
            options.addOption(zkHostOption);
            Option solrHomeOption = new Option("s", SOLRHOME, true, "for bootstrap, runzk: solrhome location");
            options.addOption(solrHomeOption);
            options.addOption("d", CONFDIR, true, "for upconfig: a directory of configuration files");
            options.addOption("n", CONFNAME, true, "for upconfig, linkconfig: name of the config set");
            options.addOption("c", COLLECTION, true, "for linkconfig: name of the collection");
            options.addOption(EXCLUDE_REGEX_SHORT, EXCLUDE_REGEX, true, "for upconfig: files matching this regular expression won't be uploaded");
            options.addOption("r", RUNZK, true, "run zk internally by passing the solr run port - only for clusters on one machine (tests, dev)");
            options.addOption("h", HELP, false, "bring up this help page");
            options.addOption("name", true, "name of the cluster property to set");
            options.addOption("val", true, "value of the cluster to set");
            try {
                CommandLine line = parser.parse(options, args);
                if (line.hasOption(HELP) || !line.hasOption(ZKHOST) || !line.hasOption(CMD)) {
                    HelpFormatter formatter = new HelpFormatter();
                    formatter.printHelp(ZK_CLI_NAME, options);
                    stdout.println("Examples:");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd bootstrap -solrhome /opt/solr");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd upconfig -confdir /opt/solr/collection1/conf -confname myconf");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd downconfig -confdir /opt/solr/collection1/conf -confname myconf");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd linkconfig -collection collection1 -confname myconf");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd makepath /apache/solr");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd put /solr.conf 'conf data'");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd putfile /solr.xml /User/myuser/solr/solr.xml");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd get /solr.xml");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd getfile /solr.xml solr.xml.file");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd clear /solr");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd list");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd ls /solr/live_nodes");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd clusterprop -name urlScheme -val https");
                    stdout.println("zkcli.sh -zkhost localhost:9983 -cmd updateacls /solr");
                    return;
                }
                String zkServerAddress = line.getOptionValue(ZKHOST);
                String solrHome = line.getOptionValue(SOLRHOME);
                String solrPort = null;
                if (line.hasOption(RUNZK)) {
                    if (!line.hasOption(SOLRHOME)) {
                        stdout.println("-solrhome is required for runzk");
                        System.exit(1);
                    }
                    solrPort = line.getOptionValue(RUNZK);
                }
                SolrZkServer zkServer = null;
                if (solrPort != null) {
                    zkServer = new SolrZkServer("true", null, new File(solrHome, "/zoo_data"), solrHome, Integer.parseInt(solrPort));
                    zkServer.parseConfig();
                    zkServer.start();
                }
                SolrZkClient zkClient = null;
                try {
                    zkClient = new SolrZkClient(zkServerAddress, 30000, 30000, () -> {});
                    if (line.getOptionValue(CMD).equalsIgnoreCase(BOOTSTRAP)) {
                        if (!line.hasOption(SOLRHOME)) {
                            stdout.println("-solrhome is required for bootstrap");
                            System.exit(1);
                        }
                        CoreContainer cc = new CoreContainer(Paths.get(solrHome, new String[0]), new Properties());
                        if (!ZkController.checkChrootPath(zkServerAddress, true)) {
                            stdout.println("A chroot was specified in zkHost but the znode doesn't exist. ");
                            System.exit(1);
                        }
                        ZkController.bootstrapConf(zkClient, cc);
                        break block53;
                    }
                    if (line.getOptionValue(CMD).equalsIgnoreCase(UPCONFIG)) {
                        if (!line.hasOption(CONFDIR) || !line.hasOption(CONFNAME)) {
                            stdout.println("-confdir and -confname are required for upconfig");
                            System.exit(1);
                        }
                        String confDir = line.getOptionValue(CONFDIR);
                        String confName = line.getOptionValue(CONFNAME);
                        String excludeExpr = line.getOptionValue(EXCLUDE_REGEX, EXCLUDE_REGEX_DEFAULT);
                        if (!ZkController.checkChrootPath(zkServerAddress, true)) {
                            stdout.println("A chroot was specified in zkHost but the znode doesn't exist. ");
                            System.exit(1);
                        }
                        ZkConfigManager configManager = new ZkConfigManager(zkClient);
                        Pattern excludePattern = Pattern.compile(excludeExpr);
                        configManager.uploadConfigDir(Paths.get(confDir, new String[0]), confName, excludePattern);
                        break block53;
                    }
                    if (line.getOptionValue(CMD).equalsIgnoreCase(DOWNCONFIG)) {
                        if (!line.hasOption(CONFDIR) || !line.hasOption(CONFNAME)) {
                            stdout.println("-confdir and -confname are required for downconfig");
                            System.exit(1);
                        }
                        String confDir = line.getOptionValue(CONFDIR);
                        String confName = line.getOptionValue(CONFNAME);
                        ZkConfigManager configManager = new ZkConfigManager(zkClient);
                        configManager.downloadConfigDir(confName, Paths.get(confDir, new String[0]));
                        break block53;
                    }
                    if (line.getOptionValue(CMD).equalsIgnoreCase(LINKCONFIG)) {
                        if (!line.hasOption(COLLECTION) || !line.hasOption(CONFNAME)) {
                            stdout.println("-collection and -confname are required for linkconfig");
                            System.exit(1);
                        }
                        String collection = line.getOptionValue(COLLECTION);
                        String confName = line.getOptionValue(CONFNAME);
                        ZkController.linkConfSet(zkClient, collection, confName);
                        break block53;
                    }
                    if (line.getOptionValue(CMD).equalsIgnoreCase(LIST)) {
                        zkClient.printLayoutToStream(stdout);
                        break block53;
                    }
                    if (line.getOptionValue(CMD).equals(LS)) {
                        List argList = line.getArgList();
                        if (argList.size() != 1) {
                            stdout.println("-ls requires one arg - the path to list");
                            System.exit(1);
                        }
                        StringBuilder sb = new StringBuilder();
                        String path = argList.get(0).toString();
                        zkClient.printLayout(path == null ? "/" : path, 0, sb);
                        stdout.println(sb.toString());
                        break block53;
                    }
                    if (line.getOptionValue(CMD).equalsIgnoreCase(CLEAR)) {
                        List arglist = line.getArgList();
                        if (arglist.size() != 1) {
                            stdout.println("-clear requires one arg - the path to clear");
                            System.exit(1);
                        }
                        zkClient.clean(arglist.get(0).toString());
                        break block53;
                    }
                    if (line.getOptionValue(CMD).equalsIgnoreCase(MAKEPATH)) {
                        List arglist = line.getArgList();
                        if (arglist.size() != 1) {
                            stdout.println("-makepath requires one arg - the path to make");
                            System.exit(1);
                        }
                        zkClient.makePath(arglist.get(0).toString(), true);
                        break block53;
                    }
                    if (line.getOptionValue(CMD).equalsIgnoreCase(PUT)) {
                        String path;
                        List arglist = line.getArgList();
                        if (arglist.size() != 2) {
                            stdout.println("-put requires two args - the path to create and the data string");
                            System.exit(1);
                        }
                        if (zkClient.exists(path = arglist.get(0).toString(), true).booleanValue()) {
                            zkClient.setData(path, arglist.get(1).toString().getBytes(StandardCharsets.UTF_8), true);
                        } else {
                            zkClient.create(path, arglist.get(1).toString().getBytes(StandardCharsets.UTF_8), CreateMode.PERSISTENT, true);
                        }
                        break block53;
                    }
                    if (line.getOptionValue(CMD).equalsIgnoreCase(PUT_FILE)) {
                        List arglist = line.getArgList();
                        if (arglist.size() != 2) {
                            stdout.println("-putfile requires two args - the path to create in ZK and the path to the local file");
                            System.exit(1);
                        }
                        String path = arglist.get(0).toString();
                        FileInputStream is = new FileInputStream(arglist.get(1).toString());
                        try {
                            if (zkClient.exists(path, true).booleanValue()) {
                                zkClient.setData(path, IOUtils.toByteArray((InputStream)is), true);
                            } else {
                                zkClient.create(path, IOUtils.toByteArray((InputStream)is), CreateMode.PERSISTENT, true);
                            }
                            break block53;
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)is);
                        }
                    }
                    if (line.getOptionValue(CMD).equalsIgnoreCase(GET)) {
                        List arglist = line.getArgList();
                        if (arglist.size() != 1) {
                            stdout.println("-get requires one arg - the path to get");
                            System.exit(1);
                        }
                        byte[] data = zkClient.getData(arglist.get(0).toString(), null, null, true);
                        stdout.println(new String(data, StandardCharsets.UTF_8));
                    } else if (line.getOptionValue(CMD).equalsIgnoreCase(GET_FILE)) {
                        List arglist = line.getArgList();
                        if (arglist.size() != 2) {
                            stdout.println("-getfilerequires two args - the path to get and the file to save it to");
                            System.exit(1);
                        }
                        byte[] data = zkClient.getData(arglist.get(0).toString(), null, null, true);
                        FileUtils.writeByteArrayToFile((File)new File(arglist.get(1).toString()), (byte[])data);
                    } else if (line.getOptionValue(CMD).equals(UPDATEACLS)) {
                        List arglist = line.getArgList();
                        if (arglist.size() != 1) {
                            stdout.println("-updateacls requires one arg - the path to update");
                            System.exit(1);
                        }
                        zkClient.updateACLs(arglist.get(0).toString());
                    } else if (line.getOptionValue(CMD).equalsIgnoreCase(CLUSTERPROP)) {
                        if (!line.hasOption("name")) {
                            stdout.println("-name is required for clusterprop");
                        }
                        String propertyName = line.getOptionValue("name");
                        String propertyValue = line.getOptionValue("val");
                        ClusterProperties props = new ClusterProperties(zkClient);
                        try {
                            props.setClusterProperty(propertyName, (Object)propertyValue);
                        }
                        catch (IOException ex) {
                            stdout.println("Unable to set the cluster property due to following error : " + ex.getLocalizedMessage());
                            System.exit(1);
                        }
                    } else {
                        stdout.println("Unknown command " + line.getOptionValue(CMD) + ". Use -h to get help.");
                        System.exit(1);
                    }
                }
                finally {
                    if (solrPort != null) {
                        zkServer.stop();
                    }
                    if (zkClient != null) {
                        zkClient.close();
                    }
                }
            }
            catch (ParseException exp) {
                stdout.println("Unexpected exception:" + exp.getMessage());
            }
        }
    }
}

