/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import opennlp.tools.formats.brat.AnnotationConfiguration;
import opennlp.tools.formats.brat.BratDocument;
import opennlp.tools.util.ObjectStream;

public class BratDocumentStream
implements ObjectStream<BratDocument> {
    private AnnotationConfiguration config;
    private List<String> documentIds = new LinkedList<String>();
    private Iterator<String> documentIdIterator;

    public BratDocumentStream(AnnotationConfiguration config, File bratCorpusDirectory, boolean searchRecursive, FileFilter fileFilter) throws IOException {
        if (!bratCorpusDirectory.isDirectory()) {
            throw new IOException("Input corpus directory must be a directory according to File.isDirectory()!");
        }
        this.config = config;
        Stack<File> directoryStack = new Stack<File>();
        directoryStack.add(bratCorpusDirectory);
        while (!directoryStack.isEmpty()) {
            for (File file : ((File)directoryStack.pop()).listFiles(fileFilter)) {
                if (file.isFile()) {
                    String documentId;
                    File txtFile;
                    String annFilePath = file.getAbsolutePath();
                    if (!annFilePath.endsWith(".ann") || !(txtFile = new File((documentId = annFilePath.substring(0, annFilePath.length() - 4)) + ".txt")).exists() || !txtFile.isFile()) continue;
                    this.documentIds.add(documentId);
                    continue;
                }
                if (!searchRecursive || !file.isDirectory()) continue;
                directoryStack.push(file);
            }
        }
        this.reset();
    }

    @Override
    public BratDocument read() throws IOException {
        BratDocument doc = null;
        if (this.documentIdIterator.hasNext()) {
            String id = this.documentIdIterator.next();
            try (BufferedInputStream txtIn = new BufferedInputStream(new FileInputStream(id + ".txt"));
                 BufferedInputStream annIn = new BufferedInputStream(new FileInputStream(id + ".ann"));){
                doc = BratDocument.parseDocument(this.config, id, txtIn, annIn);
            }
        }
        return doc;
    }

    @Override
    public void reset() {
        this.documentIdIterator = this.documentIds.iterator();
    }

    @Override
    public void close() {
        this.documentIds = null;
        this.documentIdIterator = null;
    }
}

