/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemDestinationAddressEditStatus;
import ghidra.feature.vt.gui.editors.AddressEditorPanel;
import ghidra.feature.vt.gui.editors.AddressEditorPanelListener;
import ghidra.feature.vt.gui.editors.EditableAddress;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.markuptable.EditableListingAddress;
import ghidra.feature.vt.gui.task.SetMarkupItemDestinationAddressTask;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import resources.ResourceManager;

public class EditMarkupAddressAction
extends DockingAction {
    private static final String MENU_GROUP = "A_VT_X_AddressEdit";
    private static final Icon EDIT_ADDRESS_ICON = ResourceManager.loadImage((String)"images/edit-rename.png");
    private static final String ACTION_NAME = "Edit Markup Destination Address";
    final VTController controller;

    public EditMarkupAddressAction(VTController controller, boolean addToToolbar) {
        super(ACTION_NAME, VTPlugin.OWNER);
        this.controller = controller;
        this.setDescription(ACTION_NAME);
        if (addToToolbar) {
            this.setToolBarData(new ToolBarData(EDIT_ADDRESS_ICON, MENU_GROUP));
        }
        MenuData menuData = new MenuData(new String[]{"Edit Destination Address"}, EDIT_ADDRESS_ICON, MENU_GROUP);
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Edit_Markup_Item_Destination_Address"));
    }

    public void actionPerformed(ActionContext context) {
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        for (VTMarkupItem markupItem : markupItems) {
            JComponent component = context.getComponentProvider().getComponent();
            this.editDestinationAddress(markupItem, component);
        }
    }

    public boolean isEnabledForContext(ActionContext context) {
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        if (markupItems.size() != 1) {
            return false;
        }
        VTMarkupItem item = markupItems.get(0);
        VTMarkupItemDestinationAddressEditStatus status = item.getDestinationAddressEditStatus();
        return status == VTMarkupItemDestinationAddressEditStatus.EDITABLE;
    }

    public boolean isAddToPopup(ActionContext context) {
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        return markupItems.size() == 1;
    }

    private void editDestinationAddress(final VTMarkupItem markupItem, final JComponent component) {
        VTMarkupItemDestinationAddressEditStatus status = markupItem.getDestinationAddressEditStatus();
        if (status != VTMarkupItemDestinationAddressEditStatus.EDITABLE) {
            final String description = status.getDescription();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Msg.showInfo(this.getClass(), (Component)component, (String)"Cannot Edit Destination Address", (Object)description);
                }
            });
            return;
        }
        final Address destinationAddress = markupItem.getDestinationAddress();
        Program destinationProgram = this.controller.getDestinationProgram();
        EditableListingAddress editableAddress = new EditableListingAddress(destinationProgram, destinationAddress, markupItem);
        final DialogProvider dialog = new DialogProvider(editableAddress);
        dialog.setRememberSize(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditMarkupAddressAction.this.controller.getTool().showDialog((DialogComponentProvider)dialog, (Component)component);
                Address newDestinationAddress = dialog.getAddress();
                if (SystemUtilities.isEqual((Object)destinationAddress, (Object)newDestinationAddress)) {
                    return;
                }
                ArrayList<VTMarkupItem> arrayList = new ArrayList<VTMarkupItem>();
                arrayList.add(markupItem);
                SetMarkupItemDestinationAddressTask task = new SetMarkupItemDestinationAddressTask(EditMarkupAddressAction.this.controller.getSession(), arrayList, newDestinationAddress);
                EditMarkupAddressAction.this.controller.runVTTask(task);
            }
        });
    }

    private class DialogProvider
    extends DialogComponentProvider
    implements AddressEditorPanelListener {
        private EditableAddress editableAddress;
        private Address editedAddress;
        private AddressEditorPanel editorPanel;

        protected DialogProvider(EditableAddress address) {
            super(address.getEditorTitle(), true, true, true, false);
            this.editableAddress = address;
            this.editorPanel = this.editableAddress.getEditorPanel();
            this.editorPanel.setAddressPanelListener(this);
            this.addWorkPanel(this.editorPanel);
            this.addOKButton();
            this.addCancelButton();
        }

        protected void cancelCallback() {
            super.cancelCallback();
        }

        protected void okCallback() {
            try {
                Address newAddress;
                this.editedAddress = newAddress = this.editorPanel.getAddress();
                this.close();
            }
            catch (InvalidInputException e) {
                this.setStatusText(e.getMessage());
            }
        }

        Address getAddress() {
            return this.editedAddress;
        }

        @Override
        public void addressEdited() {
            this.okCallback();
        }
    }
}

