/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.gui.actions.AbstractMarkupItemAction;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.provider.markuptable.MarkupStatusIcons;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.framework.options.ToolOptions;
import ghidra.util.HelpLocation;

public class ApplyAndReplaceMarkupItemAction
extends AbstractMarkupItemAction {
    private static final String MENU_GROUP = "A_VT_Apply_Edit";

    public ApplyAndReplaceMarkupItemAction(VTController controller, boolean addToToolbar) {
        super(controller, "Apply (Replace)");
        if (addToToolbar) {
            this.setToolBarData(new ToolBarData(MarkupStatusIcons.APPLY_REPLACE_MENU_ICON, MENU_GROUP));
        }
        MenuData menuData = new MenuData(new String[]{"Apply (Replace)"}, MarkupStatusIcons.APPLY_REPLACE_MENU_ICON, MENU_GROUP);
        menuData.setMenuSubGroup("2");
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Replace_Markup_Item"));
    }

    @Override
    public ToolOptions getApplyOptions() {
        VTMatchApplyChoices.FunctionNameChoices functionNameChoice;
        ToolOptions options = this.controller.getOptions();
        ToolOptions vtOptions = options.copy();
        vtOptions.setEnum("Apply Markup Options.Data Match Data Type", (Enum)VTMatchApplyChoices.ReplaceDataChoices.REPLACE_ALL_DATA);
        VTMatchApplyChoices.LabelChoices labelChoice = (VTMatchApplyChoices.LabelChoices)vtOptions.getEnum("Apply Markup Options.Labels", (Enum)VTMatchApplyChoices.LabelChoices.REPLACE_ALL);
        if (labelChoice != VTMatchApplyChoices.LabelChoices.REPLACE_DEFAULT_ONLY) {
            vtOptions.setEnum("Apply Markup Options.Labels", (Enum)VTMatchApplyChoices.LabelChoices.REPLACE_ALL);
        }
        if ((functionNameChoice = (VTMatchApplyChoices.FunctionNameChoices)vtOptions.getEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.REPLACE_ALWAYS)) != VTMatchApplyChoices.FunctionNameChoices.REPLACE_DEFAULT_ONLY) {
            vtOptions.setEnum("Apply Markup Options.Function Name", (Enum)VTMatchApplyChoices.FunctionNameChoices.REPLACE_ALWAYS);
        }
        vtOptions.setEnum("Apply Markup Options.Function Signature", (Enum)VTMatchApplyChoices.FunctionSignatureChoices.REPLACE);
        vtOptions.setEnum("Apply Markup Options.Function Calling Convention", (Enum)VTMatchApplyChoices.CallingConventionChoices.NAME_MATCH);
        vtOptions.setEnum("Apply Markup Options.Function Inline", (Enum)VTMatchApplyChoices.ReplaceChoices.REPLACE);
        vtOptions.setEnum("Apply Markup Options.Function No Return", (Enum)VTMatchApplyChoices.ReplaceChoices.REPLACE);
        vtOptions.setEnum("Apply Markup Options.Function Var Args", (Enum)VTMatchApplyChoices.ReplaceChoices.REPLACE);
        vtOptions.setEnum("Apply Markup Options.Function Call Fixup", (Enum)VTMatchApplyChoices.ReplaceChoices.REPLACE);
        vtOptions.setEnum("Apply Markup Options.Function Return Type", (Enum)VTMatchApplyChoices.ParameterDataTypeChoices.REPLACE_UNDEFINED_DATA_TYPES_ONLY);
        vtOptions.setEnum("Apply Markup Options.Function Parameter Data Types", (Enum)VTMatchApplyChoices.ParameterDataTypeChoices.REPLACE_UNDEFINED_DATA_TYPES_ONLY);
        vtOptions.setEnum("Apply Markup Options.Function Parameter Names", (Enum)VTMatchApplyChoices.SourcePriorityChoices.REPLACE);
        vtOptions.setEnum("Apply Markup Options.Function Parameter Comments", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
        vtOptions.setEnum("Apply Markup Options.Plate Comment", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
        vtOptions.setEnum("Apply Markup Options.Pre Comment", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
        vtOptions.setEnum("Apply Markup Options.End of Line Comment", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
        vtOptions.setEnum("Apply Markup Options.Repeatable Comment", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
        vtOptions.setEnum("Apply Markup Options.Post Comment", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
        return vtOptions;
    }

    @Override
    public VTMarkupItemApplyActionType getActionType() {
        return VTMarkupItemApplyActionType.REPLACE;
    }
}

