/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.task.ApplyMarkupItemTask;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import java.util.List;

public abstract class AbstractMarkupItemAction
extends DockingAction {
    final VTController controller;

    AbstractMarkupItemAction(VTController controller, String actionName) {
        super(actionName, VTPlugin.OWNER);
        this.controller = controller;
    }

    abstract VTMarkupItemApplyActionType getActionType();

    abstract ToolOptions getApplyOptions();

    public void actionPerformed(ActionContext context) {
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        ApplyMarkupItemTask task = this.createApplyTask(this.controller.getSession(), markupItems, this.getApplyOptions());
        task.addTaskListener(new TaskListener(){

            public void taskCompleted(Task t) {
                AbstractMarkupItemAction.this.controller.refresh();
            }

            public void taskCancelled(Task t) {
            }
        });
        this.controller.runVTTask(task);
    }

    protected ApplyMarkupItemTask createApplyTask(VTSession session, List<VTMarkupItem> markupItems, ToolOptions options) {
        return new ApplyMarkupItemTask(session, markupItems, options);
    }

    public boolean isEnabledForContext(ActionContext context) {
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        if (markupItems.size() == 0) {
            return false;
        }
        for (VTMarkupItem markupItem : markupItems) {
            if (!markupItem.canApply()) {
                return false;
            }
            if (!markupItem.supportsApplyAction(this.getActionType())) {
                return false;
            }
            Address address = markupItem.getDestinationAddress();
            if (address != null && address != Address.NO_ADDRESS) continue;
            return false;
        }
        return true;
    }

    public boolean isAddToPopup(ActionContext context) {
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        if (markupItems.size() == 0) {
            return false;
        }
        for (VTMarkupItem markupItem : markupItems) {
            if (!markupItem.canApply()) {
                return false;
            }
            if (markupItem.supportsApplyAction(this.getActionType())) continue;
            return false;
        }
        return true;
    }
}

