/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import docking.DialogComponentProvider;
import docking.widgets.table.RowObjectTableModel;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.ReferencesFromTableModel;
import ghidra.util.table.field.ReferenceEndpoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class XRefChooserDialog
extends DialogComponentProvider {
    private GhidraTable table;
    private GhidraTableFilterPanel<ReferenceEndpoint> filterPanel;
    private final Program program;
    private ServiceProvider serviceProvider;
    private List<Reference> references;

    public XRefChooserDialog(List<Reference> references, Program program, ServiceProvider serviceProvider) {
        super("Jump to XRef");
        this.references = references;
        this.program = program;
        this.serviceProvider = serviceProvider;
        this.setPreferredSize(400, 400);
        this.addOKButton();
        this.addCancelButton();
        this.addWorkPanel(this.createWorkPanel());
        this.setOkEnabled(false);
    }

    private JComponent createWorkPanel() {
        JPanel workPanel = new JPanel(new BorderLayout());
        ReferencesFromTableModel model = new ReferencesFromTableModel(this.references, this.serviceProvider, this.program);
        this.table = new GhidraTable((TableModel)model);
        this.table.setSelectionMode(0);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                int row = XRefChooserDialog.this.table.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                XRefChooserDialog.this.okCallback();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.setOkEnabled(this.table.getSelectedRow() != -1);
        });
        this.filterPanel = new GhidraTableFilterPanel((JTable)this.table, (RowObjectTableModel)model);
        workPanel.add((Component)new JScrollPane((Component)this.table), "Center");
        workPanel.add((Component)this.filterPanel, "South");
        return workPanel;
    }

    protected void okCallback() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            this.setStatusText("You must make a selection or press Cancel");
            return;
        }
        this.close();
    }

    public void close() {
        super.close();
        this.filterPanel.dispose();
    }

    protected void cancelCallback() {
        this.table.clearSelection();
        this.close();
    }

    public Reference getSelectedReference() {
        int selectedRow = this.table.getSelectedRow();
        int modelRow = this.filterPanel.getModelRow(selectedRow);
        if (modelRow == -1) {
            return null;
        }
        return this.references.get(modelRow);
    }
}

