/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img3.tag;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.ios.img3.AbstractImg3Tag;
import java.io.IOException;

public class KBagTag
extends AbstractImg3Tag {
    public static final String MAGIC = "KBAG";
    public static final int AES_128 = 128;
    public static final int AES_192 = 192;
    public static final int AES_256 = 256;
    private int iv_key_crypt_state;
    private int aes_type;
    private byte[] enc_iv;
    private byte[] enc_key;

    KBagTag(BinaryReader reader) throws IOException {
        super(reader);
        this.iv_key_crypt_state = reader.readNextInt();
        this.aes_type = reader.readNextInt();
        this.enc_iv = reader.readNextByteArray(16);
        switch (this.aes_type) {
            case 128: {
                this.enc_key = reader.readNextByteArray(16);
                break;
            }
            case 192: {
                this.enc_key = reader.readNextByteArray(24);
                break;
            }
            case 256: {
                this.enc_key = reader.readNextByteArray(32);
                break;
            }
            default: {
                throw new RuntimeException("unrecognized AES size: " + this.aes_type);
            }
        }
    }

    public int getIVKeyCryptState() {
        return this.iv_key_crypt_state;
    }

    public int getAesType() {
        return this.aes_type;
    }

    public byte[] getEncryptionIV() {
        return this.enc_iv;
    }

    public byte[] getEncryptionKey() {
        return this.enc_key;
    }
}

