/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.apple8900;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.Structure;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import utilities.util.ArrayUtilities;

public class Apple8900Header
implements StructConverter {
    private byte[] magic;
    private byte[] version;
    private byte encrypted;
    private byte[] unknown0;
    private int sizeOfData;
    private int footerSignatureOffset;
    private int footerCertOffset;
    private int footerCertLength;
    private byte[] key1;
    private byte[] unknown1;
    private byte[] key2;
    private byte[] unknown2;

    public Apple8900Header(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Apple8900Header(BinaryReader reader) throws IOException {
        this.magic = reader.readNextByteArray(4);
        this.version = reader.readNextByteArray(3);
        this.encrypted = reader.readNextByte();
        this.unknown0 = reader.readNextByteArray(4);
        this.sizeOfData = reader.readNextInt();
        this.footerSignatureOffset = reader.readNextInt();
        this.footerCertOffset = reader.readNextInt();
        this.footerCertLength = reader.readNextInt();
        this.key1 = reader.readNextByteArray(32);
        this.unknown1 = reader.readNextByteArray(4);
        this.key2 = reader.readNextByteArray(16);
        this.unknown2 = reader.readNextByteArray(1968);
    }

    public String getMagic() {
        return new String(this.magic);
    }

    public String getVersion() {
        return new String(ArrayUtilities.reverse((byte[])this.version));
    }

    public boolean isEncrypted() {
        return this.encrypted == 3;
    }

    public int getSizeOfData() {
        return this.sizeOfData;
    }

    public int getFooterSignatureOffset() {
        return this.footerSignatureOffset;
    }

    public int getFooterCertificateOffset() {
        return this.footerCertOffset;
    }

    public int getFooterCertificateLength() {
        return this.footerCertLength;
    }

    public byte[] getKey1() {
        return this.key1;
    }

    public byte[] getKey2() {
        return this.key2;
    }

    public byte[] getUnknown(int index) {
        switch (index) {
            case 0: {
                return this.unknown0;
            }
            case 1: {
                return this.unknown1;
            }
            case 2: {
                return this.unknown2;
            }
        }
        throw new RuntimeException("invalid unknown index");
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        Structure structure = (Structure)StructConverterUtil.toDataType((Object)this);
        DataTypeComponent component0 = structure.getComponent(0);
        structure.replace(0, (DataType)new StringDataType(), 4, component0.getFieldName(), component0.getComment());
        DataTypeComponent component1 = structure.getComponent(1);
        structure.replace(1, (DataType)new StringDataType(), 3, component1.getFieldName(), component1.getComment());
        return structure;
    }

    public static byte[] reverse(byte[] array) {
        byte[] reversed = new byte[array.length];
        for (int i = 0; i < reversed.length; ++i) {
            reversed[i] = array[array.length - 1 - i];
        }
        return reversed;
    }
}

