/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GDHtmlLabel;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.EnumColumnConstraint;
import docking.widgets.table.constrainteditor.AbstractColumnConstraintEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EnumConstraintEditor<T extends Enum<T>>
extends AbstractColumnConstraintEditor<T> {
    private Set<T> allValues;
    private Set<T> selectedValues;
    private Map<T, JCheckBox> enumCheckboxMap = new HashMap<T, JCheckBox>();
    public static final String CHECKBOX_NAME_PREFIX = "enumCheckbox_";
    private JLabel infoLabel;

    public EnumConstraintEditor(EnumColumnConstraint<T> constraint) {
        super(constraint);
        this.allValues = EnumSet.allOf(constraint.getEnumClass());
        this.selectedValues = new HashSet<T>();
    }

    @Override
    protected Component buildInlineEditorComponent() {
        JPanel panel = new JPanel(new GridLayout(0, 2, 5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 10));
        for (Enum t : this.allValues) {
            GCheckBox jCheckBox = new GCheckBox(this.getElementDisplayName(t));
            this.enumCheckboxMap.put(t, jCheckBox);
            jCheckBox.setName(String.format("%s%03d", CHECKBOX_NAME_PREFIX, t.ordinal()));
            jCheckBox.addItemListener(e -> {
                if (jCheckBox.isSelected()) {
                    this.selectedValues.add(t);
                } else {
                    this.selectedValues.remove(t);
                }
                this.valueChanged();
            });
            panel.add(jCheckBox);
        }
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.add((Component)panel, "Center");
        this.infoLabel = new GDHtmlLabel("");
        this.infoLabel.setForeground(Color.GRAY);
        this.infoLabel.setHorizontalAlignment(0);
        outerPanel.add((Component)this.infoLabel, "South");
        return outerPanel;
    }

    public String getElementDisplayName(T value) {
        String displayName = this.getDisplayNameUsingMethodNamed("getName", value);
        if (displayName != null) {
            return displayName;
        }
        displayName = this.getDisplayNameUsingMethodNamed("getDisplayName", value);
        if (displayName != null) {
            return displayName;
        }
        displayName = this.getDisplayNameUsingMethodNamed("getDisplayString", value);
        if (displayName != null) {
            return displayName;
        }
        return ((Enum)value).toString();
    }

    private String getDisplayNameUsingMethodNamed(String methodName, T value) {
        try {
            Method method = this.getConstraint().getEnumClass().getMethod(methodName, new Class[0]);
            if (method.getReturnType() != String.class) {
                return null;
            }
            if (method.getParameterCount() != 0) {
                return null;
            }
            return (String)method.invoke(value, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected ColumnConstraint<T> getValueFromComponent() {
        HashSet<T> values = new HashSet<T>(this.selectedValues);
        return new EnumColumnConstraint<T>(this.getConstraint().getEnumClass(), values);
    }

    private EnumColumnConstraint<T> getConstraint() {
        return (EnumColumnConstraint)this.currentConstraint;
    }

    @Override
    protected void updateEditorComponent() {
        this.selectedValues = new HashSet<T>(this.getConstraint().getSelectedValues());
        for (Map.Entry<T, JCheckBox> entry : this.enumCheckboxMap.entrySet()) {
            boolean selected = this.selectedValues.contains(entry.getKey());
            entry.getValue().setSelected(selected);
        }
    }

    @Override
    public void reset() {
        this.setValue(new EnumColumnConstraint<T>(this.getConstraint().getEnumClass(), Collections.emptySet()));
    }

    @Override
    protected boolean checkEditorValueValidity() {
        return !this.selectedValues.isEmpty();
    }

    @Override
    protected void updateInfoMessage(boolean isValid) {
        String status = EnumConstraintEditor.formatStatus(isValid ? "&nbsp;" : "Please select at least one value", true);
        this.infoLabel.setText(status);
    }

    @Override
    public String getErrorMessage() {
        return "Please select one or more elements";
    }
}

