/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.FieldPanelOverLayoutEvent;
import docking.widgets.fieldpanel.FieldPanelOverLayoutListener;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.listener.LayoutListener;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import docking.widgets.fieldpanel.support.FieldLocation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FieldPanelOverLayoutManager
implements LayoutManager2 {
    private final Map<FieldLocation, Component> componentsByLocation = new HashMap<FieldLocation, Component>();
    private final Map<Component, FieldLocation> locationsByComponent = new HashMap<Component, FieldLocation>();
    private final FieldPanel fieldpane;
    private final MyListener listener = new MyListener();
    private final List<FieldPanelOverLayoutListener> layoutListeners = new ArrayList<FieldPanelOverLayoutListener>();

    public FieldPanelOverLayoutManager(FieldPanel fieldpane) {
        this.fieldpane = fieldpane;
        fieldpane.addLayoutListener(this.listener);
    }

    public void unregister() {
        this.fieldpane.removeLayoutListener(this.listener);
    }

    protected void addComponent(FieldLocation loc, Component comp) {
        loc = new FieldLocation(loc.getIndex(), loc.getFieldNum());
        this.componentsByLocation.put(loc, comp);
        this.locationsByComponent.put(comp, loc);
    }

    protected boolean removeComponent(FieldLocation loc) {
        Component comp = this.componentsByLocation.remove(loc);
        if (comp == null) {
            return false;
        }
        this.locationsByComponent.remove(comp);
        return true;
    }

    protected boolean removeComponent(Component comp) {
        FieldLocation loc = this.locationsByComponent.remove(comp);
        if (loc == null) {
            return false;
        }
        this.componentsByLocation.remove(loc);
        return true;
    }

    protected void trickMapComponents() {
        this.fieldpane.scrollView(0);
    }

    public void addLayoutListener(FieldPanelOverLayoutListener listener) {
        this.layoutListeners.add(listener);
    }

    public void removeLayoutListener(FieldPanelOverLayoutListener listener) {
        this.layoutListeners.remove(listener);
    }

    public FieldPanelOverLayoutListener[] getLayoutListeners() {
        return this.layoutListeners.toArray(new FieldPanelOverLayoutListener[0]);
    }

    public <T> T[] getListeners(Class<T> listenerType) {
        if (listenerType == FieldPanelOverLayoutListener.class) {
            return this.getLayoutListeners();
        }
        return null;
    }

    protected void fireLayoutListeners(FieldPanelOverLayoutEvent ev) {
        for (FieldPanelOverLayoutListener l : this.layoutListeners) {
            if (ev.isConsumed()) {
                return;
            }
            l.fieldLayout(ev);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addComponent(new FieldLocation(0, 0), comp);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.addComponent((FieldLocation)constraints, comp);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.removeComponent(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return null;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return null;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return null;
    }

    @Override
    public void layoutContainer(Container parent) {
        if (!parent.equals(this.fieldpane)) {
            throw new IllegalArgumentException("" + parent);
        }
        this.trickMapComponents();
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.trickMapComponents();
        this.fieldpane.repaint();
    }

    private class MyListener
    implements LayoutListener {
        private MyListener() {
        }

        @Override
        public void layoutsChanged(List<AnchoredLayout> layouts) {
            HashSet<Component> invisible = new HashSet<Component>(FieldPanelOverLayoutManager.this.componentsByLocation.values());
            for (AnchoredLayout layout : layouts) {
                if (layout.getNumFields() == 0) continue;
                BigInteger index = layout.getIndex();
                for (int i = 0; i < layout.getNumFields(); ++i) {
                    FieldLocation loc = new FieldLocation(index, i);
                    Field field = layout.getField(i);
                    Component comp = FieldPanelOverLayoutManager.this.componentsByLocation.get(loc);
                    if (comp == null) continue;
                    Rectangle r = layout.getFieldBounds(i);
                    comp.setBounds(r);
                    FieldPanelOverLayoutEvent ev = new FieldPanelOverLayoutEvent(field, loc, comp);
                    FieldPanelOverLayoutManager.this.fireLayoutListeners(ev);
                    if (ev.isCancelled()) continue;
                    comp.setVisible(true);
                    invisible.remove(comp);
                }
            }
            for (Component comp : invisible) {
                comp.setVisible(false);
            }
        }
    }
}

