/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.generators.random.BarabasiAlbertGenerator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.Map;
import java.util.Set;

public class MixedRandomGraphGenerator {
    public static <V, E> Graph<V, E> generateMixedRandomGraph(Supplier<Graph<V, E>> graphFactory, Supplier<V> vertexFactory, Supplier<E> edgeFactory, Map<E, Number> edge_weights, int num_vertices, Set<V> seedVertices) {
        int seed = (int)(Math.random() * 10000.0);
        BarabasiAlbertGenerator<V, E> bag = new BarabasiAlbertGenerator<V, E>(graphFactory, vertexFactory, edgeFactory, 4, 3, seed, seedVertices);
        bag.evolveGraph(num_vertices - 4);
        Object ug = bag.get();
        Graph g = (Graph)graphFactory.get();
        for (Object v : ug.getVertices()) {
            g.addVertex(v);
        }
        for (Object e : ug.getEdges()) {
            Object v1 = ug.getEndpoints(e).getFirst();
            Object v2 = ug.getEndpoints(e).getSecond();
            Object me = edgeFactory.get();
            g.addEdge(me, v1, v2, Math.random() < 0.5 ? EdgeType.DIRECTED : EdgeType.UNDIRECTED);
            edge_weights.put(me, Math.random());
        }
        return g;
    }
}

