/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.database.function.FunctionDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramDiff;
import ghidra.program.util.SimpleDiffUtility;
import java.util.Set;

class FunctionTagComparator
extends ProgramDiff.ProgramDiffComparatorImpl {
    FunctionTagComparator(Program program1, Program program2) {
        super(program1, program2);
    }

    @Override
    public int compare(Object o1, Object o2) {
        FunctionDB f1 = (FunctionDB)o1;
        FunctionDB f2 = (FunctionDB)o2;
        Address a1 = f1.getEntryPoint();
        Address a2 = f2.getEntryPoint();
        Address address2CompatibleWith1 = SimpleDiffUtility.getCompatibleAddress((Program)this.program2, (Address)a2, (Program)this.program1);
        return a1.compareTo((Object)address2CompatibleWith1);
    }

    @Override
    public boolean isSame(Object obj1, Object obj2) {
        FunctionDB f1 = (FunctionDB)obj1;
        FunctionDB f2 = (FunctionDB)obj2;
        if (f1 == null && f2 == null) {
            return true;
        }
        if (f1 == null || f2 == null) {
            return false;
        }
        Set f1Tags = f1.getTags();
        Set f2Tags = f2.getTags();
        return f1Tags.equals(f2Tags);
    }

    @Override
    public AddressSet getAddressSet(Object obj, Program program) {
        AddressSet addrs = new AddressSet();
        if (obj == null) {
            return addrs;
        }
        FunctionDB function = (FunctionDB)obj;
        addrs.add(function.getEntryPoint());
        return addrs;
    }
}

