/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.app.services.QueryData;
import ghidra.app.util.viewer.field.FieldMouseHandlerExtension;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.util.AutomaticCommentFieldLocation;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.EolCommentFieldLocation;
import ghidra.program.util.PlateFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.StringUtilities;
import java.awt.event.MouseEvent;

public class CommentFieldMouseHandler
implements FieldMouseHandlerExtension {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{CommentFieldLocation.class, EolCommentFieldLocation.class, PlateFieldLocation.class, AutomaticCommentFieldLocation.class};

    @Override
    public Class<?>[] getSupportedProgramLocations() {
        return SUPPORTED_CLASSES;
    }

    @Override
    public boolean fieldElementClicked(Object clickedObject, Navigatable sourceNavigatable, ProgramLocation location, MouseEvent mouseEvent, ServiceProvider serviceProvider) {
        if (mouseEvent.getClickCount() != 2 || mouseEvent.getButton() != 1) {
            return false;
        }
        String[] comments = this.getComment(location);
        int commentRow = this.getCommentRow(location);
        int column = this.getCommentColumn(location);
        if (comments.length == 0) {
            return false;
        }
        if (commentRow < 0) {
            return false;
        }
        String clickedWord = StringUtilities.findWord((String)comments[commentRow], (int)column, (char[])GoToService.VALID_GOTO_CHARS);
        return this.checkWord(clickedWord, serviceProvider, sourceNavigatable);
    }

    protected int getCommentRow(ProgramLocation programLocation) {
        if (programLocation instanceof PlateFieldLocation) {
            return ((PlateFieldLocation)programLocation).getCommentRow();
        }
        return ((CommentFieldLocation)programLocation).getRow();
    }

    protected int getCommentColumn(ProgramLocation programLocation) {
        return ((CommentFieldLocation)programLocation).getCharOffset();
    }

    protected String[] getComment(ProgramLocation programLocation) {
        return ((CommentFieldLocation)programLocation).getComment();
    }

    protected boolean checkWord(String wordString, ServiceProvider serviceProvider, Navigatable sourceNavigatable) {
        if (wordString == null) {
            return false;
        }
        ProgramLocation location = sourceNavigatable.getLocation();
        GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
        if (goToService == null) {
            return false;
        }
        QueryData queryData = new QueryData(wordString, false);
        return goToService.goToQuery(sourceNavigatable, location.getAddress(), queryData, null, null);
    }
}

