/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.xcoff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.xcoff.XCoffOptionalHeader;
import java.io.IOException;

public class XCoffSymbol {
    private static final char NL = '\n';
    public static final int SYMSZ = 18;
    public static final int SYMNMLEN = 8;
    public static final int N_DEBUG = -2;
    public static final int N_ABS = -1;
    public static final int N_UNDEF = 0;
    private byte[] n_name;
    private int n_value;
    private short n_scnum;
    private short n_type;
    private byte n_sclass;
    private byte n_numaux;
    private byte[] aux;
    private byte x_smclas;
    private XCoffOptionalHeader _optionalHeader;

    public XCoffSymbol(BinaryReader reader, XCoffOptionalHeader optionalHeader) throws IOException {
        this._optionalHeader = optionalHeader;
        this.n_name = reader.readNextByteArray(8);
        this.n_value = reader.readNextInt();
        this.n_scnum = reader.readNextShort();
        this.n_type = reader.readNextShort();
        this.n_sclass = reader.readNextByte();
        this.n_numaux = reader.readNextByte();
        this.aux = new byte[this.n_numaux * 18];
        this.x_smclas = this.n_numaux > 0 ? this.aux[this.aux.length - 7] : (byte)0;
    }

    public boolean isLongName() {
        return this.n_name[0] == 0 && this.n_name[1] == 0 && this.n_name[2] == 0 && this.n_name[3] == 0;
    }

    public String getName() {
        return new String(this.n_name).trim();
    }

    public boolean isFunction() {
        return (this.n_sclass == 2 || this.n_sclass == 107 || this.n_sclass == 111) && this.n_scnum == this._optionalHeader.getSectionNumberForText() && !this.n_name.equals(".text");
    }

    public boolean isVariable() {
        return !(this.n_sclass != 2 && this.n_sclass != 107 && this.n_sclass != 111 || this.n_scnum != this._optionalHeader.getSectionNumberForBss() && this.n_scnum != this._optionalHeader.getSectionNumberForData() || this.x_smclas == 15 || this.x_smclas == 3 || this.x_smclas == 10 || this.n_name.equals(".bss") || this.n_name.equals(".data"));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SYMBOL TABLE ENTRY").append('\n');
        buffer.append("n_value = ").append(this.n_value).append('\n');
        buffer.append("n_scnum = ").append(this.n_scnum).append('\n');
        buffer.append("n_type = ").append(this.n_type).append('\n');
        buffer.append("n_sclass = ").append(this.n_sclass).append('\n');
        buffer.append("n_numaux = ").append(this.n_numaux).append('\n');
        return buffer.toString();
    }
}

