/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableModule
extends CliAbstractTable {
    public CliTableModule(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliModuleRow row = new CliModuleRow(reader.readNextShort(), this.readStringIndex(reader), this.readBlobIndex(reader), this.readBlobIndex(reader), this.readBlobIndex(reader));
            this.rows.add(row);
            this.strings.add(row.nameIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "Module Row", 0);
        struct.add(WORD, "Generation", "reserved, shall be 0");
        struct.add(this.metadataStream.getStringIndexDataType(), "Name", "index into String heap");
        struct.add(this.metadataStream.getGuidIndexDataType(), "MvId", "used to distinguish between versions of same module");
        struct.add(this.metadataStream.getGuidIndexDataType(), "EncId", "reserved, shall be 0");
        struct.add(this.metadataStream.getGuidIndexDataType(), "EncBaseId", "reserved, shall be 0");
        return struct;
    }

    @Override
    public DataType toDataType() {
        StructureDataType rowDt = this.getRowDataType();
        return rowDt;
    }

    @Override
    public int getNumRows() {
        return 1;
    }

    public class CliModuleRow
    extends CliAbstractTableRow {
        public short generation;
        public int nameIndex;
        public int mvIdIndex;
        public int encIdIndex;
        public int encBaseIdIndex;

        public CliModuleRow(short generation, int nameIndex, int mvIdIndex, int encIdIndex, int encBaseIdIndex) {
            this.generation = generation;
            this.nameIndex = nameIndex;
            this.mvIdIndex = mvIdIndex;
            this.encIdIndex = encIdIndex;
            this.encBaseIdIndex = encBaseIdIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("%s MvID %s EncID %s EncBaseID %s", CliTableModule.this.metadataStream.getGuidStream().getGuid(this.nameIndex), CliTableModule.this.metadataStream.getGuidStream().getGuid(this.mvIdIndex), CliTableModule.this.metadataStream.getGuidStream().getGuid(this.encIdIndex), CliTableModule.this.metadataStream.getGuidStream().getGuid(this.encBaseIdIndex));
        }

        @Override
        public String getShortRepresentation() {
            return String.format("%s", CliTableModule.this.metadataStream.getStringsStream().getString(this.nameIndex));
        }
    }
}

