/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.Namespace;

public abstract class ObjectiveC_Method
implements StructConverter {
    protected ObjectiveC1_State _state;
    protected long _index;
    protected ObjectiveC_MethodType _methodType;

    protected ObjectiveC_Method(ObjectiveC1_State state, BinaryReader reader, ObjectiveC_MethodType methodType) {
        this._state = state;
        this._index = reader.getPointerIndex();
        this._methodType = methodType;
    }

    public final long getIndex() {
        return this._index;
    }

    public final ObjectiveC_MethodType getMethodType() {
        return this._methodType;
    }

    public abstract String getName();

    public abstract String getTypes();

    public abstract long getImplementation();

    public void applyTo(Namespace namespace) throws Exception {
        long implementation = this.getImplementation();
        if (implementation == 0L) {
            return;
        }
        if (this.getName() == null && this.getName().length() == 0) {
            return;
        }
        boolean isThumbCode = ObjectiveC1_Utilities.isThumb(this._state.program, implementation);
        if (isThumbCode) {
            --implementation;
        }
        Address implementationAddress = this._state.program.getAddressFactory().getDefaultAddressSpace().getAddress(implementation);
        ObjectiveC1_Utilities.createSymbol(this._state.program, namespace, this.getName(), implementationAddress);
        this._state.methodMap.put(implementationAddress, this);
        if (isThumbCode) {
            this._state.thumbCodeLocations.add(implementationAddress);
        }
    }
}

