/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macos.rm;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.macos.rm.ReferenceListEntry;
import ghidra.app.util.bin.format.macos.rm.ResourceHeader;
import ghidra.app.util.bin.format.macos.rm.ResourceType;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceMap
implements StructConverter {
    private ResourceHeader copy;
    private int handleToNextResourceMap;
    private short fileReferenceNumber;
    private short resourceForkAttributes;
    private short resourceTypeListOffset;
    private short resourceNameListOffset;
    private short numberOfTypes;
    private long _mapStartIndex;
    private List<ResourceType> _resourceTypeList = new ArrayList<ResourceType>();
    private List<ReferenceListEntry> _referenceEntryList = new ArrayList<ReferenceListEntry>();
    private Map<Short, String> _resourceNameMap = new HashMap<Short, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceMap(BinaryReader reader, ResourceHeader header) throws IOException {
        this._mapStartIndex = reader.getPointerIndex();
        this.copy = new ResourceHeader(reader, header.getEntryDescriptor(), true);
        this.handleToNextResourceMap = reader.readNextInt();
        this.fileReferenceNumber = reader.readNextShort();
        this.resourceForkAttributes = reader.readNextShort();
        this.resourceTypeListOffset = reader.readNextShort();
        this.resourceNameListOffset = reader.readNextShort();
        this.numberOfTypes = reader.readNextShort();
        long oldIndex = reader.getPointerIndex();
        try {
            this.parseResourceNameList(reader);
            this.parseResourceTypeList(reader, header);
        }
        finally {
            reader.setPointerIndex(oldIndex);
        }
    }

    private void parseResourceTypeList(BinaryReader reader, ResourceHeader header) throws IOException {
        long resourceTypeListStart = this._mapStartIndex + (long)this.resourceTypeListOffset + 2L;
        reader.setPointerIndex(resourceTypeListStart);
        for (int i = 0; i < this.numberOfTypes + 1; ++i) {
            this._resourceTypeList.add(new ResourceType(reader, header, this, resourceTypeListStart));
        }
    }

    private void parseResourceNameList(BinaryReader reader) throws IOException {
        long start = this._mapStartIndex + (long)this.resourceNameListOffset;
        reader.setPointerIndex(this._mapStartIndex + (long)this.resourceNameListOffset);
        while (reader.getPointerIndex() < reader.length()) {
            long offset = reader.getPointerIndex();
            int length = reader.readNextByte() & 0xFF;
            String name = reader.readNextAsciiString(length);
            this._resourceNameMap.put((short)(offset - start), name);
        }
    }

    public ResourceHeader getCopy() {
        return this.copy;
    }

    public int getHandleToNextResourceMap() {
        return this.handleToNextResourceMap;
    }

    public short getFileReferenceNumber() {
        return this.fileReferenceNumber;
    }

    public short getResourceForkAttributes() {
        return this.resourceForkAttributes;
    }

    public short getResourceTypeListOffset() {
        return this.resourceTypeListOffset;
    }

    public short getResourceNameListOffset() {
        return this.resourceNameListOffset;
    }

    public short getNumberOfTypes() {
        return this.numberOfTypes;
    }

    public List<ResourceType> getResourceTypeList() {
        return this._resourceTypeList;
    }

    public List<ReferenceListEntry> getReferenceEntryList() {
        return this._referenceEntryList;
    }

    public String getStringAt(short offset) {
        if (offset == -1) {
            return null;
        }
        return this._resourceNameMap.get(offset);
    }

    public long getMapStartIndex() {
        return this._mapStartIndex;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(ResourceMap.class);
    }
}

