/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DynamicLinkerCommand
extends LoadCommand {
    private LoadCommandString name;

    public static DynamicLinkerCommand createDynamicLinkerCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        DynamicLinkerCommand dynamicLinkerCommand = (DynamicLinkerCommand)reader.getFactory().create(DynamicLinkerCommand.class, new Object[0]);
        dynamicLinkerCommand.initDynamicLinkerCommand(reader);
        return dynamicLinkerCommand;
    }

    private void initDynamicLinkerCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        this.initLoadCommand(reader);
        this.name = LoadCommandString.createLoadCommandString(reader, this);
    }

    public LoadCommandString getLoadCommandString() {
        return this.name;
    }

    @Override
    public String getCommandName() {
        return "dylinker_command";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(this.name.toDataType(), "name", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address address = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(address, this.toDataType());
                int length = this.getCommandSize() - this.name.getOffset();
                api.createAsciiString(address.add((long)this.name.getOffset()), length);
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
        }
    }
}

