/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class MachHeaderFlags {
    public static final int MH_NOUNDEFS = 1;
    public static final int MH_INCRLINK = 2;
    public static final int MH_DYLDLINK = 4;
    public static final int MH_BINDATLOAD = 8;
    public static final int MH_PREBOUND = 16;
    public static final int MH_SPLIT_SEGS = 32;
    public static final int MH_LAZY_INIT = 64;
    public static final int MH_TWOLEVEL = 128;
    public static final int MH_FORCE_FLAT = 256;
    public static final int MH_NOMULTIDEFS = 512;
    public static final int MH_NOFIXPREBINDING = 1024;
    public static final int MH_PREBINDABLE = 2048;
    public static final int MH_ALLMODSBOUND = 4096;
    public static final int MH_SUBSECTIONS_VIA_SYMBOLS = 8192;
    public static final int MH_CANONICAL = 16384;
    public static final int MH_WEAK_DEFINES = 32768;
    public static final int MH_BINDS_TO_WEAK = 65536;
    public static final int MH_ALLOW_STACK_EXECUTION = 131072;
    public static final int MH_ROOT_SAFE = 262144;
    public static final int MH_SETUID_SAFE = 524288;
    public static final int MH_NO_REEXPORTED_DYLIBS = 0x100000;
    public static final int MH_PIE = 0x200000;
    public static final int MH_DEAD_STRIPPABLE_DYLIB = 0x400000;
    public static final int MH_HAS_TLV_DESCRIPTORS = 0x800000;
    public static final int MH_NO_HEAP_EXECUTION = 0x1000000;
    public static final int MH_APP_EXTENSION_SAFE = 0x2000000;

    public static final List<String> getFlags(int flags) {
        Field[] fields;
        ArrayList<String> list = new ArrayList<String>();
        for (Field field : fields = MachHeaderFlags.class.getDeclaredFields()) {
            if (!field.getName().startsWith("MH_")) continue;
            try {
                Integer value = (Integer)field.get(null);
                if ((flags & value) == 0) continue;
                list.add(field.getName().substring("MH_".length()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }
}

