/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.util.bin.ByteProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class StringTable {
    private byte[] bytes;

    public static StringTable readStringTable(ByteProvider bp) throws IOException {
        byte[] bytes = bp != null ? bp.readBytes(0L, bp.length()) : new byte[]{};
        return new StringTable(bytes);
    }

    public StringTable(byte[] bytes) {
        this.bytes = bytes;
    }

    public boolean isValid(long offset) {
        return offset >= 0L && offset < (long)this.bytes.length;
    }

    public void clear() {
        this.bytes = null;
    }

    public String getStringAtOffset(long offset) throws IOException {
        if (!this.isValid(offset)) {
            throw new IOException("Invalid offset requested " + offset);
        }
        String tmp = new String(this.bytes, (int)offset, StringTable.getNullTermStringLen(this.bytes, (int)offset), StandardCharsets.UTF_8);
        return tmp;
    }

    private static final int getNullTermStringLen(byte[] bytes, int startOffset) {
        int cp;
        for (cp = startOffset; cp < bytes.length && bytes[cp] != 0; ++cp) {
        }
        return cp - startOffset;
    }

    public int getByteCount() {
        return this.bytes.length;
    }

    public void add(int offset, String s) {
        byte[] sBytes = s.getBytes();
        int newLen = Math.max(this.bytes.length, offset + sBytes.length + 1);
        byte[] newBytes = new byte[newLen];
        System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
        System.arraycopy(sBytes, 0, newBytes, offset, sBytes.length);
        this.bytes = newBytes;
    }
}

