/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.Option;
import java.util.List;

public class OptionUtils {
    public static boolean containsOption(String optionName, List<Option> options) {
        return options.stream().anyMatch(o -> o.getName().equals(optionName));
    }

    public static <T> T getOption(String optionName, List<Option> options, T defaultValue) {
        if (options != null) {
            for (Option option : options) {
                if (!option.getName().equals(optionName)) continue;
                return (T)option.getValue();
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanOptionValue(String optionName, List<Option> options, boolean defaultValue) {
        if (options != null) {
            for (Option option : options) {
                Object val;
                if (!option.getName().equals(optionName) || !((val = option.getValue()) instanceof Boolean)) continue;
                return (Boolean)option.getValue();
            }
        }
        return defaultValue;
    }
}

