/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.TableFilterContext;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import docking.widgets.table.constrainteditor.DoNothingColumnConstraintEditor;
import ghidra.app.plugin.core.strings.StringDataInstanceColumnConstraint;
import ghidra.program.model.data.StringDataInstance;

public class IsAsciiColumnConstraint
extends StringDataInstanceColumnConstraint {
    public boolean accepts(StringDataInstance value, TableFilterContext context) {
        String s = value.getStringValue();
        return s != null && s.chars().allMatch(codePoint -> 0 <= codePoint && codePoint < 128);
    }

    public String getName() {
        return "Is Ascii";
    }

    public ColumnConstraintEditor<StringDataInstance> getEditor(ColumnData<StringDataInstance> columnDataSource) {
        return new DoNothingColumnConstraintEditor((ColumnConstraint)this);
    }
}

