/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext;

public class SearchOptions
implements Cloneable {
    private final String text;
    private final boolean functions;
    private final boolean comments;
    private final boolean labels;
    private final boolean instructionMnemonics;
    private final boolean instructionOperands;
    private final boolean dataMnemonics;
    private final boolean dataOperands;
    private final boolean caseSensitive;
    private final boolean direction;
    private final boolean searchAll;
    private final boolean includeNonLoadedBlocks;
    private final boolean databaseSearch;
    private int progress;

    public SearchOptions(String text, boolean quickSearch, boolean functions, boolean comments, boolean labels, boolean instructionMnemonics, boolean instructionOperands, boolean dataMnemonics, boolean dataOperands, boolean caseSensitive, boolean direction, boolean includeNonLoadedBlocks, boolean searchAll) {
        this.text = text;
        this.databaseSearch = quickSearch;
        this.functions = functions;
        this.comments = comments;
        this.labels = labels;
        this.instructionMnemonics = instructionMnemonics;
        this.instructionOperands = instructionOperands;
        this.dataMnemonics = dataMnemonics;
        this.dataOperands = dataOperands;
        this.caseSensitive = caseSensitive;
        this.direction = direction;
        this.searchAll = searchAll;
        this.includeNonLoadedBlocks = includeNonLoadedBlocks;
    }

    SearchOptions(String text, boolean caseSensitive, boolean direction, boolean includeNonLoadedBlocks) {
        this(text, false, false, false, false, false, false, false, false, caseSensitive, direction, includeNonLoadedBlocks, true);
    }

    public String getText() {
        return this.text;
    }

    public boolean searchFunctions() {
        return this.functions;
    }

    public boolean searchLabels() {
        return this.labels;
    }

    public boolean searchComments() {
        return this.comments;
    }

    public boolean searchBothInstructionMnemonicAndOperands() {
        return this.instructionMnemonics & this.instructionOperands;
    }

    public boolean searchInstructionMnemonics() {
        return this.instructionMnemonics;
    }

    public boolean searchInstructionOperands() {
        return this.instructionOperands;
    }

    public boolean searchOnlyInstructionMnemonics() {
        return this.instructionMnemonics && !this.instructionOperands;
    }

    public boolean searchOnlyInstructionOperands() {
        return this.instructionOperands && !this.instructionMnemonics;
    }

    public boolean searchBothDataMnemonicsAndOperands() {
        return this.dataMnemonics & this.dataOperands;
    }

    public boolean searchDataMnemonics() {
        return this.dataMnemonics;
    }

    public boolean searchDataOperands() {
        return this.dataOperands;
    }

    public boolean searchOnlyDataMnemonics() {
        return this.dataMnemonics && !this.dataOperands;
    }

    public boolean searchOnlyDataOperands() {
        return this.dataOperands && !this.dataMnemonics;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isForward() {
        return this.direction;
    }

    boolean searchAllFields() {
        return this.searchAll;
    }

    boolean includeNonLoadedMemoryBlocks() {
        return this.includeNonLoadedBlocks;
    }

    boolean isProgramDatabaseSearch() {
        return this.databaseSearch;
    }

    void setProgress(int progress) {
        this.progress = progress;
    }

    int getProgress() {
        return this.progress;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.caseSensitive ? 1231 : 1237);
        result = 31 * result + (this.comments ? 1231 : 1237);
        result = 31 * result + (this.dataMnemonics ? 1231 : 1237);
        result = 31 * result + (this.dataOperands ? 1231 : 1237);
        result = 31 * result + (this.direction ? 1231 : 1237);
        result = 31 * result + (this.functions ? 1231 : 1237);
        result = 31 * result + (this.instructionMnemonics ? 1231 : 1237);
        result = 31 * result + (this.instructionOperands ? 1231 : 1237);
        result = 31 * result + (this.labels ? 1231 : 1237);
        result = 31 * result + (this.databaseSearch ? 1231 : 1237);
        result = 31 * result + (this.searchAll ? 1231 : 1237);
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchOptions other = (SearchOptions)obj;
        if (this.caseSensitive != other.caseSensitive) {
            return false;
        }
        if (this.comments != other.comments) {
            return false;
        }
        if (this.dataMnemonics != other.dataMnemonics) {
            return false;
        }
        if (this.dataOperands != other.dataOperands) {
            return false;
        }
        if (this.direction != other.direction) {
            return false;
        }
        if (this.functions != other.functions) {
            return false;
        }
        if (this.instructionMnemonics != other.instructionMnemonics) {
            return false;
        }
        if (this.instructionOperands != other.instructionOperands) {
            return false;
        }
        if (this.labels != other.labels) {
            return false;
        }
        if (this.databaseSearch != other.databaseSearch) {
            return false;
        }
        if (this.searchAll != other.searchAll) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

