/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.DialogComponentProvider;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.disassembler.DisassemblerPlugin;
import ghidra.app.plugin.core.disassembler.SetFlowOverrideDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.NoSuchElementException;

class SetFlowOverrideAction
extends ListingContextAction {
    private DisassemblerPlugin plugin;

    public SetFlowOverrideAction(DisassemblerPlugin plugin, String groupName) {
        super("Modify Instruction Flow", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Modify Instruction Flow..."}, null, groupName));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        SetFlowOverrideDialog dialog;
        PluginTool tool = this.plugin.getTool();
        ProgramSelection selection = context.getSelection();
        if (selection != null && !selection.isEmpty()) {
            try {
                if (!this.isValidInstructionSelection(context.getProgram(), selection)) {
                    Msg.showError((Object)((Object)this), (Component)tool.getActiveWindow(), (String)"Invalid Flow-Override Selection", (Object)"Flow Override action does not permit multiple flow instructions within each selection range");
                    return;
                }
            }
            catch (CancelledException e) {
                return;
            }
            catch (NoSuchElementException e) {
                Msg.showError((Object)((Object)this), (Component)tool.getActiveWindow(), (String)"Invalid Flow-Override Selection", (Object)"No instructions found within selection");
                return;
            }
            dialog = new SetFlowOverrideDialog(tool, context.getProgram(), selection);
        } else {
            Address address = context.getAddress();
            if (address == null) {
                return;
            }
            Instruction instr = context.getProgram().getListing().getInstructionAt(address);
            if (instr == null) {
                return;
            }
            dialog = new SetFlowOverrideDialog(tool, instr);
        }
        tool.showDialog((DialogComponentProvider)dialog);
    }

    private boolean isValidInstructionSelection(Program program, ProgramSelection selection) throws NoSuchElementException, CancelledException {
        OverrideSelectionInspector inspectionTask = new OverrideSelectionInspector(program, selection);
        new TaskLauncher((Task)inspectionTask, null, 500);
        return inspectionTask.isValidSelection();
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        ProgramSelection selection = context.getSelection();
        if (selection != null && !selection.isEmpty()) {
            return true;
        }
        Address address = context.getAddress();
        if (address == null) {
            return false;
        }
        Instruction instr = context.getProgram().getListing().getInstructionAt(address);
        if (instr == null) {
            return false;
        }
        return !instr.isFallthrough();
    }

    private class OverrideSelectionInspector
    extends Task {
        final AddressSet targetSet;
        private boolean invalidRangeFound;
        private boolean cancelled;
        private Program program;
        private ProgramSelection selection;

        OverrideSelectionInspector(Program program, ProgramSelection selection) {
            super("Flow Override", true, true, true);
            this.targetSet = new AddressSet();
            this.invalidRangeFound = false;
            this.cancelled = false;
            this.program = program;
            this.selection = selection;
        }

        public void run(TaskMonitor monitor) {
            monitor.setMessage("Inspecting Selection...");
            monitor.initialize((long)this.selection.getNumAddressRanges());
            Listing listing = this.program.getListing();
            int runningRangeTotal = 0;
            int currentRangeTotal = 0;
            block0: for (AddressRange range : this.selection.getAddressRanges()) {
                if (monitor.isCancelled()) {
                    this.cancelled = true;
                    break;
                }
                runningRangeTotal += currentRangeTotal;
                currentRangeTotal = 0;
                Address minAddr = range.getMinAddress();
                Address maxAddr = range.getMaxAddress();
                boolean flowFound = false;
                for (Instruction instr : listing.getInstructions(minAddr, true)) {
                    if (monitor.isCancelled()) {
                        this.cancelled = true;
                        continue block0;
                    }
                    if (instr.getAddress().compareTo((Object)maxAddr) > 0) continue block0;
                    currentRangeTotal = (int)instr.getAddress().subtract(minAddr) + 1;
                    if (!instr.getFlowType().isFallthrough()) {
                        if (flowFound) {
                            Msg.error((Object)((Object)this), (Object)("Invalid flow-override range found at " + minAddr));
                            this.invalidRangeFound = true;
                            return;
                        }
                        flowFound = true;
                        this.targetSet.add(instr.getAddress());
                    }
                    monitor.setProgress((long)(runningRangeTotal + currentRangeTotal));
                }
            }
        }

        boolean isValidSelection() throws NoSuchElementException, CancelledException {
            if (this.invalidRangeFound) {
                return false;
            }
            if (this.cancelled) {
                throw new CancelledException();
            }
            if (this.targetSet.isEmpty()) {
                throw new NoSuchElementException("No flow instructions found in selection");
            }
            return true;
        }
    }
}

