/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.DiffUtility;

public abstract class CodeUnitDetails {
    private static final String NEW_LINE = "\n";
    private static final String INDENT1 = "    ";

    public static String getInstructionDetails(CodeUnit cu) {
        if (cu == null || !(cu instanceof Instruction)) {
            return "You must be on an instruction to see the details.";
        }
        return CodeUnitDetails.getCodeUnitDetails(cu) + CodeUnitDetails.getReferenceDetails(cu);
    }

    public static String getCodeUnitDetails(CodeUnit cu) {
        Object cuRep;
        if (cu == null) {
            return "You must be on a code unit to see the details.";
        }
        String indent = INDENT1;
        StringBuffer buf = new StringBuffer();
        buf.append("Code Unit:\n");
        Address min = cu.getMinAddress();
        Address max = cu.getMaxAddress();
        String addrRangeStr = min + (String)(min.equals((Object)max) ? "" : " - " + max);
        if (cu instanceof Data) {
            cuRep = ((Data)cu).getDataType().getPathName();
        } else if (cu instanceof Instruction) {
            Instruction inst = (Instruction)cu;
            boolean removedFallThrough = inst.isFallThroughOverridden() && inst.getFallThrough() == null;
            boolean hasFlowOverride = inst.getFlowOverride() != FlowOverride.NONE;
            cuRep = cu.toString();
            if (removedFallThrough) {
                cuRep = (String)cuRep + NEW_LINE + indent + CodeUnitDetails.getSpaces(addrRangeStr.length()) + "    Removed FallThrough";
            } else if (inst.isFallThroughOverridden()) {
                Reference[] refs = cu.getReferencesFrom();
                for (int i = 0; i < refs.length; ++i) {
                    if (!refs[i].getReferenceType().isFallthrough()) continue;
                    cuRep = (String)cuRep + NEW_LINE + indent + CodeUnitDetails.getSpaces(addrRangeStr.length()) + "    FallThrough Override: " + DiffUtility.getUserToAddressString(inst.getProgram(), refs[i]);
                }
            }
            if (hasFlowOverride) {
                cuRep = (String)cuRep + NEW_LINE + indent + CodeUnitDetails.getSpaces(addrRangeStr.length()) + "    Flow Override: " + inst.getFlowOverride();
            }
        } else {
            cuRep = cu.toString();
        }
        buf.append(indent + addrRangeStr + INDENT1 + (String)cuRep + NEW_LINE);
        return buf.toString();
    }

    public static String getReferenceDetails(CodeUnit cu) {
        if (cu == null) {
            return "You must be on a code unit to see the details.";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("References: \n");
        buf.append(CodeUnitDetails.getProgramRefDetails(cu.getProgram(), cu.getReferencesFrom()));
        return buf.toString();
    }

    private static String getRefInfo(Program pgm, Reference ref) {
        Symbol sym;
        String typeStr = "Type: " + ref.getReferenceType();
        String fromStr = "  From: " + ref.getFromAddress();
        String operandStr = ref.isMnemonicReference() ? "  Mnemonic" : "  Operand: " + ref.getOperandIndex();
        String toStr = "  To: " + DiffUtility.getUserToAddressString(pgm, ref);
        String sourceStr = "  " + ref.getSource().toString();
        String primaryStr = ref.isPrimary() ? "  Primary" : "";
        Object symbolStr = "";
        long symbolID = ref.getSymbolID();
        if (symbolID != -1L && (sym = pgm.getSymbolTable().getSymbol(symbolID)) != null) {
            symbolStr = "  Symbol: " + sym.getName(true);
        }
        return typeStr + fromStr + operandStr + toStr + sourceStr + primaryStr + (String)symbolStr;
    }

    private static String getProgramRefDetails(Program pgm, Reference[] refs) {
        String indent = INDENT1;
        if (refs.length == 0) {
            return indent + "None";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < refs.length; ++i) {
            if (refs[i].isExternalReference()) {
                buf.append(indent + "External Reference " + CodeUnitDetails.getRefInfo(pgm, refs[i]) + NEW_LINE);
                continue;
            }
            if (refs[i].isStackReference()) {
                buf.append(indent + "Stack Reference " + CodeUnitDetails.getRefInfo(pgm, refs[i]) + NEW_LINE);
                continue;
            }
            buf.append(indent + "Reference " + CodeUnitDetails.getRefInfo(pgm, refs[i]) + NEW_LINE);
        }
        return buf.toString();
    }

    private static String getSpaces(int numSpaces) {
        if (numSpaces <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(numSpaces);
        for (int i = 0; i < numSpaces; ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }
}

